/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;

public final class QuarkusUpdatesRepository {
    private static final String QUARKUS_RECIPE_GA = "io.quarkus:quarkus-update-recipes";
    public static final String DEFAULT_UPDATE_RECIPES_VERSION = "LATEST";
    public static final String DEFAULT_MAVEN_REWRITE_PLUGIN_VERSION = "4.46.0";
    public static final String DEFAULT_GRADLE_REWRITE_PLUGIN_VERSION = "5.38.0";
    public static final String PROP_REWRITE_MAVEN_PLUGIN_VERSION = "rewrite-maven-plugin-version";
    public static final String PROP_REWRITE_GRADLE_PLUGIN_VERSION = "rewrite-gradle-plugin-version";

    private QuarkusUpdatesRepository() {
    }

    public static FetchResult fetchRecipes(MessageWriter log, MavenArtifactResolver artifactResolver, BuildTool buildTool, String recipeVersion, String currentVersion, String targetVersion) {
        String gav = "io.quarkus:quarkus-update-recipes:" + recipeVersion;
        try {
            Artifact artifact = artifactResolver.resolve(DependencyUtils.toArtifact((String)gav)).getArtifact();
            ResourceLoader resourceLoader = ResourceLoaders.resolveFileResourceLoader(artifact.getFile());
            List recipes = resourceLoader.loadResourceAsPath("quarkus-updates/core", path -> {
                try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
                    List list = pathStream.filter(p -> p.getFileName().toString().matches("^\\d\\H+.ya?ml$")).filter(p -> QuarkusUpdatesRepository.shouldApplyRecipe(p.getFileName().toString(), currentVersion, targetVersion)).map(p -> {
                        try {
                            return new String(Files.readAllBytes(p));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }).collect(Collectors.toList());
                    return list;
                }
            });
            Properties props = resourceLoader.loadResourceAsPath("quarkus-updates/", p -> {
                Properties properties = new Properties();
                Path propPath = p.resolve("recipes.properties");
                if (Files.isRegularFile(propPath, new LinkOption[0])) {
                    try (InputStream inStream = Files.newInputStream(propPath, new OpenOption[0]);){
                        properties.load(inStream);
                    }
                }
                return properties;
            });
            String propRewritePluginVersion = QuarkusUpdatesRepository.getPropRewritePluginVersion(props, buildTool);
            log.info(String.format("Resolved io.quarkus:quarkus-updates-recipes:%s with %s recipe(s) to update from %s to %s (initially made for OpenRewrite %s plugin version: %s) ", new Object[]{artifact.getVersion(), recipes.size(), currentVersion, targetVersion, buildTool, propRewritePluginVersion}));
            return new FetchResult(recipes, propRewritePluginVersion);
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve artifact: " + gav, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load recipes in artifact: " + gav, e);
        }
    }

    private static String getPropRewritePluginVersion(Properties props, BuildTool buildTool) {
        switch (buildTool) {
            case MAVEN: {
                return Optional.ofNullable(props.getProperty(PROP_REWRITE_MAVEN_PLUGIN_VERSION)).orElse(DEFAULT_MAVEN_REWRITE_PLUGIN_VERSION);
            }
            case GRADLE: 
            case GRADLE_KOTLIN_DSL: {
                return Optional.ofNullable(props.getProperty(PROP_REWRITE_GRADLE_PLUGIN_VERSION)).orElse(DEFAULT_GRADLE_REWRITE_PLUGIN_VERSION);
            }
        }
        throw new IllegalStateException("This build tool does not support update " + buildTool);
    }

    static boolean shouldApplyRecipe(String recipeFileName, String currentVersion, String targetVersion) {
        String recipeVersion = recipeFileName.replaceFirst("[.][^.]+$", "");
        DefaultArtifactVersion recipeAVersion = new DefaultArtifactVersion(recipeVersion);
        DefaultArtifactVersion currentAVersion = new DefaultArtifactVersion(currentVersion);
        DefaultArtifactVersion targetAVersion = new DefaultArtifactVersion(targetVersion);
        return currentAVersion.compareTo((ArtifactVersion)recipeAVersion) < 0 && targetAVersion.compareTo((ArtifactVersion)recipeAVersion) >= 0;
    }

    public static class FetchResult {
        private final List<String> recipes;
        private final String rewritePluginVersion;

        public FetchResult(List<String> recipes, String rewritePluginVersion) {
            this.rewritePluginVersion = rewritePluginVersion;
            this.recipes = recipes;
        }

        public List<String> getRecipes() {
            return this.recipes;
        }

        public String getRewritePluginVersion() {
            return this.rewritePluginVersion;
        }
    }
}

