/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.ProjectInfoCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.JavaVersion;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.state.ProjectState;
import io.quarkus.devtools.project.state.ProjectStates;
import io.quarkus.devtools.project.update.ExtensionUpdateInfo;
import io.quarkus.devtools.project.update.PlatformInfo;
import io.quarkus.devtools.project.update.ProjectExtensionsUpdateInfo;
import io.quarkus.devtools.project.update.ProjectPlatformUpdateInfo;
import io.quarkus.devtools.project.update.ProjectUpdateInfos;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdateCommand;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdates;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdatesRepository;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class UpdateProjectCommandHandler
implements QuarkusCommandHandler {
    public static final String ADD = "Add:";
    public static final String REMOVE = "Remove:";
    public static final String UPDATE = "Update:";
    public static final String ITEM_FORMAT = "%-7s %s";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        JavaVersion projectJavaVersion = invocation.getQuarkusProject().getJavaVersion();
        invocation.log().info("Detected project Java version: %s", new Object[]{projectJavaVersion});
        if (projectJavaVersion.isEmpty()) {
            String instruction = invocation.getQuarkusProject().getBuildTool().isAnyGradle() ? "java>targetCompatibility" : "maven.compiler.release property";
            String error = String.format("Project Java version not detected, set %s in your build file to fix the error.", instruction);
            invocation.log().error(error);
            return QuarkusCommandOutcome.failure(error);
        }
        invocation.log().info("Detected project Java version: %s", new Object[]{projectJavaVersion});
        ApplicationModel appModel = (ApplicationModel)invocation.getValue("quarkus.update-project.app-model");
        ExtensionCatalog targetCatalog = (ExtensionCatalog)invocation.getValue("quarkus.update-project.target-catalog");
        boolean perModule = invocation.getValue("quarkus.update-project.per-module", false);
        ProjectState currentState = ProjectStates.resolveProjectState(appModel, invocation.getQuarkusProject().getExtensionsCatalog());
        ArtifactCoords currentQuarkusPlatformBom = UpdateProjectCommandHandler.getProjectQuarkusPlatformBOM(currentState);
        QuarkusCommandOutcome failure = UpdateProjectCommandHandler.ensureQuarkusBomVersionIsNotNull(currentQuarkusPlatformBom, invocation.log());
        if (failure != null) {
            return failure;
        }
        ProjectState recommendedState = ProjectUpdateInfos.resolveRecommendedState(currentState, targetCatalog, invocation.log());
        ArtifactCoords recommendedQuarkusPlatformBom = UpdateProjectCommandHandler.getProjectQuarkusPlatformBOM(recommendedState);
        failure = UpdateProjectCommandHandler.ensureQuarkusBomVersionIsNotNull(recommendedQuarkusPlatformBom, invocation.log());
        if (failure != null) {
            return failure;
        }
        if (Objects.equals(currentQuarkusPlatformBom, recommendedQuarkusPlatformBom)) {
            ProjectInfoCommandHandler.logState(currentState, perModule, true, invocation.getQuarkusProject().log());
        } else {
            invocation.log().info("Instructions to update this project from '%s' to '%s':", new Object[]{currentQuarkusPlatformBom, recommendedQuarkusPlatformBom});
            QuarkusProject quarkusProject = invocation.getQuarkusProject();
            ProjectPlatformUpdateInfo platformUpdateInfo = ProjectUpdateInfos.resolvePlatformUpdateInfo(currentState, recommendedState);
            ProjectExtensionsUpdateInfo extensionsUpdateInfo = ProjectUpdateInfos.resolveExtensionsUpdateInfo(currentState, recommendedState);
            UpdateProjectCommandHandler.logUpdates(invocation.getQuarkusProject(), currentState, recommendedState, platformUpdateInfo, extensionsUpdateInfo, false, perModule, invocation.log());
            boolean noRewrite = invocation.getValue("quarkus.update-project.rewrite.disabled", false);
            if (!noRewrite) {
                BuildTool buildTool = quarkusProject.getExtensionManager().getBuildTool();
                String kotlinVersion = (String)this.getMetadata(targetCatalog, "project", "properties", "kotlin-version");
                OptionalInt minJavaVersion = extensionsUpdateInfo.getMinJavaVersion();
                Optional<Integer> updateJavaVersion = minJavaVersion.isPresent() && projectJavaVersion.isPresent() && minJavaVersion.getAsInt() > projectJavaVersion.getAsInt() ? Optional.of(minJavaVersion.getAsInt()) : Optional.empty();
                QuarkusUpdates.ProjectUpdateRequest request = new QuarkusUpdates.ProjectUpdateRequest(buildTool, currentQuarkusPlatformBom.getVersion(), recommendedQuarkusPlatformBom.getVersion(), kotlinVersion, updateJavaVersion, extensionsUpdateInfo);
                Path recipe = null;
                try {
                    recipe = Files.createTempFile("quarkus-project-recipe-", ".yaml", new FileAttribute[0]);
                    String quarkusUpdateRecipes = invocation.getValue("quarkus.update-project.rewrite.quarkus-update-recipes", "LATEST");
                    String additionalUpdateRecipes = invocation.getValue("quarkus.update-project.rewrite.additional-update-recipes", null);
                    QuarkusUpdatesRepository.FetchResult fetchResult = QuarkusUpdates.createRecipe(invocation.log(), recipe, QuarkusProjectHelper.artifactResolver(), buildTool, quarkusUpdateRecipes, additionalUpdateRecipes, request);
                    invocation.log().info("OpenRewrite recipe generated: %s", new Object[]{recipe});
                    String rewritePluginVersion = invocation.getValue("quarkus.update-project.rewrite.plugin-version", fetchResult.getRewritePluginVersion());
                    boolean rewriteDryRun = invocation.getValue("quarkus.update-project.rewrite.dry-run", false);
                    QuarkusUpdateCommand.handle(invocation.log(), buildTool, quarkusProject.getProjectDirPath(), rewritePluginVersion, fetchResult.getRecipesGAV(), recipe, rewriteDryRun);
                }
                catch (IOException e) {
                    throw new QuarkusCommandException("Error while generating the project update script", e);
                }
            }
        }
        return QuarkusCommandOutcome.success();
    }

    private static ArtifactCoords getProjectQuarkusPlatformBOM(ProjectState currentState) {
        for (ArtifactCoords c : currentState.getPlatformBoms()) {
            if (!c.getArtifactId().equals("quarkus-bom") && !c.getArtifactId().equals("quarkus-universe-bom")) continue;
            return c;
        }
        return null;
    }

    private static QuarkusCommandOutcome ensureQuarkusBomVersionIsNotNull(ArtifactCoords bomCoords, MessageWriter log) {
        if (bomCoords == null) {
            String error = "The project state is missing the Quarkus platform BOM";
            log.error(error);
            return QuarkusCommandOutcome.failure(error);
        }
        return null;
    }

    private static void logUpdates(QuarkusProject project, ProjectState currentState, ProjectState recommendedState, ProjectPlatformUpdateInfo platformUpdateInfo, ProjectExtensionsUpdateInfo extensionsUpdateInfo, boolean recommendState, boolean perModule, MessageWriter log) {
        Integer extensionsMinJavaVersion;
        if (currentState.getPlatformBoms().isEmpty()) {
            log.info("The project does not import any Quarkus platform BOM");
            return;
        }
        if (currentState.getExtensions().isEmpty()) {
            log.info("No Quarkus extensions were found among the project dependencies");
            return;
        }
        if (currentState == recommendedState) {
            log.info("The project is up-to-date");
            return;
        }
        if (recommendState) {
            ProjectInfoCommandHandler.logState(recommendedState, perModule, false, log);
            return;
        }
        if (platformUpdateInfo.isPlatformUpdatesAvailable()) {
            log.info("Recommended Quarkus platform BOM updates:");
            if (!platformUpdateInfo.getImportVersionUpdates().isEmpty()) {
                for (PlatformInfo importInfo : platformUpdateInfo.getImportVersionUpdates()) {
                    log.info(String.format(ITEM_FORMAT, UPDATE, importInfo.getImported().toCompactCoords()) + " -> " + importInfo.getRecommendedVersion());
                }
            }
            if (!platformUpdateInfo.getNewImports().isEmpty()) {
                for (PlatformInfo importInfo : platformUpdateInfo.getNewImports()) {
                    log.info(String.format(ITEM_FORMAT, ADD, importInfo.getRecommended().toCompactCoords()));
                }
            }
            if (platformUpdateInfo.isImportsToBeRemoved()) {
                for (PlatformInfo importInfo : platformUpdateInfo.getPlatformImports().values()) {
                    if (importInfo.getRecommended() != null) continue;
                    log.info(String.format(ITEM_FORMAT, REMOVE, importInfo.getImported().toCompactCoords()));
                }
            }
            log.info("");
        }
        if (extensionsUpdateInfo.shouldUpdateExtensions() && !platformUpdateInfo.isPlatformUpdatesAvailable()) {
            log.info("The project is up-to-date");
            return;
        }
        if (extensionsUpdateInfo.getMinJavaVersion().isPresent() && project.getJavaVersion().isPresent() && (extensionsMinJavaVersion = Integer.valueOf(extensionsUpdateInfo.getMinJavaVersion().getAsInt())) > project.getJavaVersion().getAsInt()) {
            log.warn("We detected that some of the updated extensions require an update of the Java version to: %s", new Object[]{extensionsMinJavaVersion});
        }
        for (PlatformInfo platform : platformUpdateInfo.getPlatformImports().values()) {
            String provider = platform.getRecommendedProviderKey();
            if (!extensionsUpdateInfo.containsProvider(provider)) continue;
            log.info("Extensions from " + platform.getRecommendedProviderKey() + ":");
            for (ExtensionUpdateInfo e : extensionsUpdateInfo.extensionsByProvider().getOrDefault(provider, Collections.emptyList())) {
                ExtensionUpdateInfo.VersionUpdateType versionUpdateType = e.getVersionUpdateType();
                if (e.hasKeyChanged()) {
                    log.info(String.format(ITEM_FORMAT, UPDATE, e.getCurrentDep().getArtifact().toCompactCoords() + " -> " + e.getRecommendedDependency().getArtifact().toCompactCoords()));
                    continue;
                }
                switch (versionUpdateType) {
                    case PLATFORM_MANAGED: {
                        break;
                    }
                    case RECOMMEND_PLATFORM_MANAGED: {
                        log.info(String.format(ITEM_FORMAT, UPDATE, e.getCurrentDep().getArtifact().toCompactCoords() + " -> drop version (managed by platform)"));
                        break;
                    }
                    case ADD_VERSION: {
                        log.info(String.format(ITEM_FORMAT, UPDATE, e.getRecommendedDependency().getArtifact().toCompactCoords() + " -> add version (managed by platform)"));
                        break;
                    }
                    case UPDATE_VERSION: {
                        log.info(String.format(ITEM_FORMAT, UPDATE, e.getCurrentDep().getArtifact().toCompactCoords() + " -> " + e.getRecommendedDependency().getVersion()));
                    }
                }
            }
            log.info("");
        }
    }

    private <T> T getMetadata(ExtensionCatalog catalog, String ... path) {
        Map currentValue = catalog.getMetadata();
        for (String pathElement : path) {
            if (!(currentValue instanceof Map)) {
                return null;
            }
            currentValue = currentValue.get(pathElement);
        }
        return (T)currentValue;
    }
}

