/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.messagewriter.MessageFormatter;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.JavaVersion;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.state.ProjectState;
import io.quarkus.devtools.project.state.ProjectStates;
import io.quarkus.devtools.project.update.ExtensionUpdateInfo;
import io.quarkus.devtools.project.update.PlatformInfo;
import io.quarkus.devtools.project.update.ProjectExtensionsUpdateInfo;
import io.quarkus.devtools.project.update.ProjectPlatformUpdateInfo;
import io.quarkus.devtools.project.update.ProjectUpdateInfos;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdateCommand;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdates;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdatesRepository;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UpdateProjectCommandHandler
implements QuarkusCommandHandler {
    public static final String ITEM_FORMAT = " %-7s %s";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        JavaVersion projectJavaVersion = invocation.getQuarkusProject().getJavaVersion();
        if (projectJavaVersion.isEmpty()) {
            String instruction = invocation.getQuarkusProject().getBuildTool().isAnyGradle() ? "java>targetCompatibility" : "maven.compiler.release property";
            String error = String.format("Project Java version not detected, set %s in your build file to fix the error.", instruction);
            invocation.log().error(error);
            return QuarkusCommandOutcome.failure(error);
        }
        invocation.log().info("Detected project Java version: %s", new Object[]{projectJavaVersion});
        ApplicationModel appModel = (ApplicationModel)invocation.getValue("quarkus.update-project.app-model");
        ExtensionCatalog targetCatalog = (ExtensionCatalog)invocation.getValue("quarkus.update-project.target-catalog");
        ProjectState currentState = ProjectStates.resolveProjectState(appModel, invocation.getQuarkusProject().getExtensionsCatalog());
        ArtifactCoords currentQuarkusPlatformBom = UpdateProjectCommandHandler.getProjectQuarkusPlatformBOM(currentState);
        QuarkusCommandOutcome<Void> failure = UpdateProjectCommandHandler.ensureQuarkusBomVersionIsNotNull(currentQuarkusPlatformBom, invocation.log());
        if (failure != null) {
            return failure;
        }
        ProjectState recommendedState = ProjectUpdateInfos.resolveRecommendedState(currentState, targetCatalog, invocation.log());
        ArtifactCoords recommendedQuarkusPlatformBom = UpdateProjectCommandHandler.getProjectQuarkusPlatformBOM(recommendedState);
        failure = UpdateProjectCommandHandler.ensureQuarkusBomVersionIsNotNull(recommendedQuarkusPlatformBom, invocation.log());
        if (failure != null) {
            return failure;
        }
        ProjectPlatformUpdateInfo platformUpdateInfo = ProjectUpdateInfos.resolvePlatformUpdateInfo(currentState, recommendedState);
        ProjectExtensionsUpdateInfo extensionsUpdateInfo = ProjectUpdateInfos.resolveExtensionsUpdateInfo(currentState, recommendedState);
        boolean shouldUpdate = UpdateProjectCommandHandler.logUpdates(invocation.getQuarkusProject(), currentState, recommendedState, platformUpdateInfo, extensionsUpdateInfo, invocation.log());
        Boolean rewrite = invocation.getValue("quarkus.update-project.rewrite.yes", null);
        boolean rewriteDryRun = invocation.getValue("quarkus.update-project.rewrite.dry-run", false);
        if (shouldUpdate) {
            QuarkusProject quarkusProject = invocation.getQuarkusProject();
            BuildTool buildTool = quarkusProject.getExtensionManager().getBuildTool();
            String kotlinVersion = (String)this.getMetadata(targetCatalog, "project", "properties", "kotlin-version");
            Optional<Integer> updateJavaVersion = UpdateProjectCommandHandler.resolveUpdateJavaVersion(extensionsUpdateInfo, projectJavaVersion);
            QuarkusUpdates.ProjectUpdateRequest request = new QuarkusUpdates.ProjectUpdateRequest(buildTool, currentQuarkusPlatformBom.getVersion(), recommendedQuarkusPlatformBom.getVersion(), kotlinVersion, updateJavaVersion, extensionsUpdateInfo);
            Path recipe = null;
            try {
                Path projectDir = invocation.getQuarkusProject().getProjectDirPath();
                Path buildDir = projectDir.resolve(invocation.getQuarkusProject().getBuildTool().getBuildDirectory());
                Path rewriteDir = buildDir.resolve("rewrite");
                recipe = rewriteDir.resolve("rewrite.yaml");
                Files.deleteIfExists(recipe);
                Files.createDirectories(recipe.getParent(), new FileAttribute[0]);
                String quarkusUpdateRecipes = invocation.getValue("quarkus.update-project.rewrite.quarkus-update-recipes", "LATEST");
                String additionalUpdateRecipes = invocation.getValue("quarkus.update-project.rewrite.additional-update-recipes", null);
                QuarkusUpdatesRepository.FetchResult fetchResult = QuarkusUpdates.createRecipe(invocation.log(), recipe, QuarkusProjectHelper.artifactResolver(), buildTool, quarkusUpdateRecipes, additionalUpdateRecipes, request);
                quarkusProject.log().info("");
                quarkusProject.log().info("We have generated a recipe file to update your project (versions updates + specific recipes):");
                quarkusProject.log().info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.UNDERLINE, (String)projectDir.relativize(recipe).toString()));
                quarkusProject.log().info("");
                if (rewriteDryRun) {
                    rewrite = true;
                }
                if (rewrite == null) {
                    CompletableFuture<String> userInputFuture = CompletableFuture.supplyAsync(() -> UpdateProjectCommandHandler.askUserConfirmationForUpdate(invocation.log()));
                    try {
                        String userInput = userInputFuture.get(2L, TimeUnit.MINUTES).toLowerCase().trim();
                        if (userInput.equalsIgnoreCase("y")) {
                            rewrite = true;
                        } else if (userInput.equalsIgnoreCase("d")) {
                            rewriteDryRun = true;
                            rewrite = true;
                        } else {
                            quarkusProject.log().info("");
                            quarkusProject.log().info("Project update has been skipped.");
                            rewrite = false;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException | TimeoutException e) {
                        quarkusProject.log().info("");
                        quarkusProject.log().info("Project update has been skipped after timeout.");
                        rewrite = false;
                    }
                }
                if (rewrite.booleanValue()) {
                    String rewritePluginVersion = invocation.getValue("quarkus.update-project.rewrite.plugin-version", fetchResult.getRewritePluginVersion());
                    quarkusProject.log().info("Running recipe%s with OpenRewrite %s...", new Object[]{rewriteDryRun ? " in dry mode" : "", rewritePluginVersion});
                    quarkusProject.log().info("");
                    Path logFile = recipe.getParent().resolve("rewrite.log");
                    QuarkusUpdateCommand.handle(invocation.log(), buildTool, quarkusProject.getProjectDirPath(), rewritePluginVersion, fetchResult.getRecipesGAV(), recipe, logFile, rewriteDryRun);
                    Path patchFile = rewriteDir.resolve("rewrite.patch");
                    if (rewriteDryRun && Files.isRegularFile(patchFile, new LinkOption[0])) {
                        quarkusProject.log().info("Patch file available:");
                        quarkusProject.log().info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.UNDERLINE, (String)projectDir.relativize(patchFile).toString()));
                        quarkusProject.log().info("");
                    }
                } else {
                    UpdateProjectCommandHandler.printSeparator(quarkusProject.log());
                }
            }
            catch (IOException e) {
                throw new QuarkusCommandException("Error while generating the project update script", e);
            }
        }
        return QuarkusCommandOutcome.success();
    }

    private static String askUserConfirmationForUpdate(MessageWriter log) {
        System.out.print(System.lineSeparator() + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.BOLD, (String)"Do you want run the generated update recipe with OpenRewrite ?") + " ([" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)"y") + "]es, [" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.RED, (String)"n") + "]o, [" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.BLUE, (String)"d") + "]ry-run)" + System.lineSeparator() + System.lineSeparator());
        Scanner scanner = new Scanner(new FilterInputStream(System.in){

            @Override
            public void close() throws IOException {
            }
        });
        try {
            String string = scanner.nextLine();
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.debug("Failed to collect user input for analytics", new Object[]{e});
                return "";
            }
        }
    }

    private static Optional<Integer> resolveUpdateJavaVersion(ProjectExtensionsUpdateInfo extensionsUpdateInfo, JavaVersion projectJavaVersion) {
        OptionalInt minJavaVersion = extensionsUpdateInfo.getMinJavaVersion();
        Optional<Integer> updateJavaVersion = minJavaVersion.isPresent() && projectJavaVersion.isPresent() && minJavaVersion.getAsInt() > projectJavaVersion.getAsInt() ? Optional.of(minJavaVersion.getAsInt()) : Optional.empty();
        return updateJavaVersion;
    }

    private static ArtifactCoords getProjectQuarkusPlatformBOM(ProjectState currentState) {
        for (ArtifactCoords c : currentState.getPlatformBoms()) {
            if (!c.getArtifactId().equals("quarkus-bom") && !c.getArtifactId().equals("quarkus-universe-bom")) continue;
            return c;
        }
        return null;
    }

    private static QuarkusCommandOutcome<Void> ensureQuarkusBomVersionIsNotNull(ArtifactCoords bomCoords, MessageWriter log) {
        if (bomCoords == null) {
            String error = "The project state is missing the Quarkus platform BOM";
            log.error(error);
            return QuarkusCommandOutcome.failure(error);
        }
        return null;
    }

    private static boolean logUpdates(QuarkusProject project, ProjectState currentState, ProjectState recommendedState, ProjectPlatformUpdateInfo platformUpdateInfo, ProjectExtensionsUpdateInfo extensionsUpdateInfo, MessageWriter log) {
        Object extensionsMinJavaVersion;
        UpdateProjectCommandHandler.printSeparator(log);
        if (currentState.getPlatformBoms().isEmpty()) {
            log.info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.RED, (String)"The project does not import any Quarkus platform BOM"));
            UpdateProjectCommandHandler.printSeparator(log);
            return false;
        }
        if (currentState.getExtensions().isEmpty()) {
            log.info("No Quarkus extensions were found among the project dependencies");
            UpdateProjectCommandHandler.printSeparator(log);
            return false;
        }
        if (currentState == recommendedState) {
            log.info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)"The project is up-to-date)"));
            UpdateProjectCommandHandler.printSeparator(log);
            return false;
        }
        if (platformUpdateInfo.isPlatformUpdatesAvailable()) {
            log.info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.BOLD, (String)"Suggested Quarkus platform BOM updates:"));
            if (!platformUpdateInfo.getImportVersionUpdates().isEmpty()) {
                for (PlatformInfo importInfo : platformUpdateInfo.getImportVersionUpdates()) {
                    log.info(String.format(ITEM_FORMAT, "~", importInfo.getImported().getKey().toGacString() + ":pom:[" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.RED, (String)importInfo.getImported().getVersion()) + " -> " + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)importInfo.getRecommendedVersion()) + "]"));
                }
            }
            if (!platformUpdateInfo.getNewImports().isEmpty()) {
                for (PlatformInfo importInfo : platformUpdateInfo.getNewImports()) {
                    log.info(String.format(ITEM_FORMAT, "+", "[" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)importInfo.getRecommended().toCompactCoords()) + "] to add"));
                }
            }
            if (platformUpdateInfo.isImportsToBeRemoved()) {
                for (PlatformInfo importInfo : platformUpdateInfo.getPlatformImports().values()) {
                    if (importInfo.getRecommended() != null) continue;
                    log.info(String.format(ITEM_FORMAT, "-", "[" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.RED, (String)importInfo.getImported().toCompactCoords()) + "] to remove"));
                }
            }
            log.info("");
        } else {
            if (!extensionsUpdateInfo.shouldUpdateExtensions()) {
                log.info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)("The project is up-to-date " + MessageIcons.UP_TO_DATE_ICON.iconOrMessage())));
                UpdateProjectCommandHandler.printSeparator(log);
                return false;
            }
            log.info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)("Quarkus platform BOM(s) are up-to-date " + MessageIcons.UP_TO_DATE_ICON.iconOrMessage())));
            log.info("");
        }
        if (extensionsUpdateInfo.getMinJavaVersion().isPresent() && project.getJavaVersion().isPresent() && (Integer)(extensionsMinJavaVersion = Integer.valueOf(extensionsUpdateInfo.getMinJavaVersion().getAsInt())) > project.getJavaVersion().getAsInt()) {
            log.warn("We detected that some of the updated extensions require an update of the Java version to: %s", new Object[]{extensionsMinJavaVersion});
        }
        for (PlatformInfo platform : platformUpdateInfo.getPlatformImports().values()) {
            String provider = platform.getRecommendedProviderKey();
            List<ExtensionUpdateInfo> extensions = extensionsUpdateInfo.extensionsByProvider().getOrDefault(provider, Collections.emptyList()).stream().filter(ExtensionUpdateInfo::isUpdateRecommended).toList();
            if (extensions.isEmpty()) continue;
            log.info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.BOLD, (String)"Suggested extensions updates for '%s':".formatted(platform.getRecommendedProviderKey())));
            for (ExtensionUpdateInfo e : extensions) {
                ExtensionUpdateInfo.VersionUpdateType versionUpdateType = e.getVersionUpdateType();
                if (e.hasKeyChanged()) {
                    log.info(String.format(ITEM_FORMAT, "~", UpdateProjectCommandHandler.updateInfo(e)));
                    continue;
                }
                switch (versionUpdateType) {
                    case PLATFORM_MANAGED: {
                        log.info(String.format(ITEM_FORMAT, MessageIcons.UP_TO_DATE_ICON.iconOrMessage(), e.getCurrentDep().getArtifact().getKey().toGacString() + " (synced with BOM)"));
                        break;
                    }
                    case RECOMMEND_PLATFORM_MANAGED: {
                        log.info(String.format(ITEM_FORMAT, "-", e.getCurrentDep().getArtifact().getKey().toGacString()) + ":[" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.RED, (String)e.getCurrentDep().getVersion()) + " -> " + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)"managed") + "]");
                        break;
                    }
                    case ADD_VERSION: {
                        log.info(String.format(ITEM_FORMAT, versionUpdateType.equals((Object)ExtensionUpdateInfo.VersionUpdateType.ADD_VERSION) ? "+" : "-", e.getCurrentDep().getArtifact().getKey().toGacString()) + ":[" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.RED, (String)"managed") + " -> " + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)e.getRecommendedDependency().getVersion()) + "]");
                        break;
                    }
                    case UPDATE_VERSION: {
                        log.info(String.format(ITEM_FORMAT, "~", UpdateProjectCommandHandler.updateInfo(e)));
                    }
                }
            }
            log.info("");
        }
        List<ExtensionUpdateInfo> simpleVersionUpdates = extensionsUpdateInfo.getSimpleVersionUpdates().stream().filter(u -> !u.getCurrentDep().isPlatformExtension()).toList();
        if (!simpleVersionUpdates.isEmpty()) {
            log.info(MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.BOLD, (String)"Suggested extensions updates from other origins:"));
            for (ExtensionUpdateInfo u2 : simpleVersionUpdates) {
                if (u2.getVersionUpdateType() == ExtensionUpdateInfo.VersionUpdateType.PLATFORM_MANAGED) {
                    log.info(String.format(ITEM_FORMAT, "-", u2.getCurrentDep().getArtifact().getKey().toGacString()) + ":[" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.RED, (String)u2.getCurrentDep().getVersion()) + "]");
                    continue;
                }
                log.info(String.format(ITEM_FORMAT, "~", UpdateProjectCommandHandler.updateInfo(u2)));
            }
        }
        UpdateProjectCommandHandler.printSeparator(log);
        return true;
    }

    private static String updateInfo(ExtensionUpdateInfo u) {
        return UpdateProjectCommandHandler.updateInfo(u.getCurrentDep().getArtifact(), u.getRecommendedDependency().getVersion());
    }

    static void printSeparator(MessageWriter log) {
        log.info("");
        log.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        log.info("");
    }

    static String updateInfo(ArtifactCoords current, String newVersion) {
        return current.getKey().toGacString() + ":[" + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.RED, (String)current.getVersion()) + " -> " + MessageFormatter.format((MessageFormatter.Format)MessageFormatter.Format.GREEN, (String)newVersion) + "]";
    }

    private <T> T getMetadata(ExtensionCatalog catalog, String ... path) {
        Map currentValue = catalog.getMetadata();
        for (String pathElement : path) {
            if (!(currentValue instanceof Map)) {
                return null;
            }
            currentValue = currentValue.get(pathElement);
        }
        return (T)currentValue;
    }
}

