/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.state;

import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExtensionProvider {
    private final String key;
    private final ArtifactCoords coords;
    private final boolean platform;
    private final Map<ArtifactKey, TopExtensionDependency> providedExtensions;

    static String key(ExtensionOrigin origin) {
        if (origin == null) {
            return "unknown origin";
        }
        if (origin.isPlatform()) {
            return origin.getBom().getGroupId() + ":" + origin.getBom().getArtifactId();
        }
        return ExtensionProvider.groupIdToHost(GACTV.fromString((String)origin.getId()).getGroupId());
    }

    public static String key(ArtifactCoords coords, boolean platform) {
        if (coords == null) {
            return "unknown origin";
        }
        if (platform) {
            return coords.getGroupId() + ":" + coords.getArtifactId();
        }
        return ExtensionProvider.groupIdToHost(coords.getGroupId());
    }

    private static String groupIdToHost(String groupId) {
        StringBuilder buf = new StringBuilder();
        int i = groupId.lastIndexOf(46);
        int end = groupId.length();
        while (i > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(groupId.substring(i + 1, end));
            end = i;
            i = groupId.lastIndexOf(46, i - 1);
        }
        if (buf.length() > 0) {
            buf.append('.');
        }
        buf.append(groupId.substring(0, end));
        return buf.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private ExtensionProvider(ArtifactCoords coords, boolean platform, Map<ArtifactKey, TopExtensionDependency> providedExtensions) {
        this.key = ExtensionProvider.key(coords, platform);
        this.coords = coords;
        this.platform = platform;
        this.providedExtensions = providedExtensions;
    }

    public String getKey() {
        return this.key;
    }

    public ArtifactCoords getArtifact() {
        return this.coords;
    }

    public Collection<TopExtensionDependency> getExtensions() {
        return this.providedExtensions.values();
    }

    public boolean isPlatform() {
        return this.platform;
    }

    public boolean isUnknown() {
        return this.coords == null;
    }

    public static class Builder {
        private ArtifactCoords coords;
        private Boolean platform;
        private ExtensionOrigin origin;
        private final Map<ArtifactKey, TopExtensionDependency> providedExtensions = new LinkedHashMap<ArtifactKey, TopExtensionDependency>();

        private Builder() {
        }

        public Builder setArtifact(ArtifactCoords coords) {
            this.coords = coords;
            return this;
        }

        public Builder setPlatform(boolean platform) {
            this.platform = platform;
            return this;
        }

        public Builder setOrigin(ExtensionOrigin origin) {
            this.origin = origin;
            return this;
        }

        public Builder addExtension(TopExtensionDependency e) {
            this.providedExtensions.put(e.getKey(), e);
            return this;
        }

        public ExtensionProvider build() {
            if (this.coords == null && this.origin != null) {
                Object object = this.coords = this.origin.isPlatform() ? this.origin.getBom() : GACTV.fromString((String)this.origin.getId());
            }
            if (this.platform == null) {
                this.platform = this.origin == null ? false : this.origin.isPlatform();
            }
            return new ExtensionProvider(this.coords, this.platform, this.providedExtensions);
        }
    }
}

