/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.plugin.CatalogService;
import io.quarkus.cli.plugin.JBangAlias;
import io.quarkus.cli.plugin.JBangCatalog;
import io.quarkus.cli.plugin.JBangSupport;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JBangCatalogService
extends CatalogService<JBangCatalog> {
    private static final Function<Path, Path> RELATIVE_PLUGIN_CATALOG = p -> p.resolve(".jbang").resolve("jbang-catalog.json");
    private static final String PATH_REGEX = "^\\s*\\((?<path>.*)\\)\\s*$";
    private static final Pattern PATH = Pattern.compile("^\\s*\\((?<path>.*)\\)\\s*$");
    private final String pluginPrefix;
    private final String fallbackCatalog;
    private final String[] remoteCatalogs;
    private final JBangSupport jbang;

    public JBangCatalogService(MessageWriter output) {
        this(output, "quarkus-", "quarkusio", new String[0]);
    }

    public JBangCatalogService(MessageWriter output, String pluginPrefix, String fallbackCatalog, String ... remoteCatalogs) {
        this(false, output, pluginPrefix, fallbackCatalog, remoteCatalogs);
    }

    public JBangCatalogService(boolean interactiveMode, MessageWriter output, String pluginPrefix, String fallbackCatalog, String ... remoteCatalogs) {
        super(JBangCatalog.class, GIT_ROOT, RELATIVE_PLUGIN_CATALOG);
        this.pluginPrefix = pluginPrefix;
        this.fallbackCatalog = fallbackCatalog;
        this.remoteCatalogs = remoteCatalogs;
        this.jbang = new JBangSupport(interactiveMode, output);
    }

    @Override
    public JBangCatalog readCatalog(Path path) {
        if (!this.jbang.isAvailable() && !this.jbang.isInstallable()) {
            return new JBangCatalog();
        }
        JBangCatalog localCatalog = (JBangCatalog)super.readCatalog(path);
        Map<String, JBangAlias> aliases = localCatalog.getAliases().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(this.pluginPrefix + "-")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (JBangAlias)e.getValue()));
        return new JBangCatalog(localCatalog.getCatalogs(), aliases, localCatalog.getCatalogRef(), localCatalog.getCatalogLocation());
    }

    public JBangCatalog readCombinedCatalog(Optional<Path> projectDir, Optional<Path> userDir) {
        if (!this.jbang.isAvailable() && !this.jbang.isInstallable()) {
            return new JBangCatalog();
        }
        HashMap<String, JBangCatalog> catalogs = new HashMap<String, JBangCatalog>();
        HashMap<String, JBangAlias> aliases = new HashMap<String, JBangAlias>();
        Optional<JBangCatalog> projectCatalog = this.readProjectCatalog(projectDir);
        Optional<JBangCatalog> userCatalog = this.readUserCatalog(userDir);
        userCatalog.ifPresent(u -> aliases.putAll(u.getAliases()));
        projectCatalog.ifPresent(p -> {
            aliases.putAll(p.getAliases());
            Optional<String> catalogFile = projectDir.map(d -> RELATIVE_PLUGIN_CATALOG.apply((Path)d).toAbsolutePath().toString());
            catalogFile.ifPresent(f -> {
                List<String> lines = this.jbang.execute("alias", "list", "-f", (String)f, "--verbose");
                aliases.putAll(this.readAliases(lines));
            });
        });
        if (this.remoteCatalogs.length == 0) {
            aliases.putAll(this.listAliasesOrFallback(this.jbang, this.fallbackCatalog).entrySet().stream().filter(e -> !aliases.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        } else {
            for (String remoteCatalog : this.remoteCatalogs) {
                aliases.putAll(this.listAliases(this.jbang, remoteCatalog).entrySet().stream().filter(e -> !aliases.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
        }
        return new JBangCatalog(catalogs, aliases, Optional.empty(), Optional.empty());
    }

    private Map<String, JBangAlias> listAliases(JBangSupport jbang, String remoteCatalog) {
        List<String> lines = jbang.execute("alias", "list", "--verbose", remoteCatalog);
        return this.readAliases(lines);
    }

    private Map<String, JBangAlias> listAliasesOrFallback(JBangSupport jbang, String fallbackCatalog) {
        List localCatalogs = jbang.execute("catalog", "list").stream().map(l -> l.substring(0, l.indexOf(" "))).collect(Collectors.toList());
        if (!localCatalogs.isEmpty()) {
            HashMap<String, JBangAlias> aliases = new HashMap<String, JBangAlias>();
            for (String catalog : localCatalogs) {
                aliases.putAll(this.listAliases(jbang, catalog));
            }
            return aliases;
        }
        return this.listAliases(jbang, fallbackCatalog);
    }

    private Map<String, JBangAlias> readAliases(List<String> lines) {
        HashMap<String, JBangAlias> aliases = new HashMap<String, JBangAlias>();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.startsWith(this.pluginPrefix)) continue;
            String name = JBangCatalogService.aliasName(line);
            Optional<String> remote = JBangCatalogService.aliasRemote(line);
            Optional<String> next = i + 1 < lines.size() ? Optional.of(lines.get(i + 1)) : Optional.empty();
            Optional path = next.filter(n -> n.matches(PATH_REGEX)).flatMap(JBangCatalogService::aliasPath);
            Optional<String> description = path.filter(JBangCatalogService::hasDescription).map(JBangCatalogService::aliasDescription);
            JBangAlias alias = new JBangAlias(name, description, remote);
            aliases.put(name, alias);
        }
        return aliases;
    }

    private static final String aliasName(String s) {
        return s.split("=")[0].trim();
    }

    private static final Optional<String> aliasRemote(String s) {
        if (s == null || s.isEmpty()) {
            return Optional.empty();
        }
        String nameWithRemote = s.split("=")[0].trim();
        if (!nameWithRemote.contains("@")) {
            return Optional.empty();
        }
        return Optional.of(nameWithRemote.split("@")[1].trim());
    }

    private static final boolean hasDescription(String s) {
        return s.contains("=");
    }

    private static final String aliasDescription(String s) {
        return s.split("=")[1].trim();
    }

    private static final Optional<String> aliasPath(String s) {
        Matcher m = PATH.matcher(s);
        if (m.matches()) {
            return Optional.of(m.group("path"));
        }
        return Optional.empty();
    }
}

