/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.devtools.exec.Executable;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.utils.Prompt;
import io.quarkus.fs.util.ZipUtils;
import io.smallrye.common.process.ProcessBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;

public class JBangSupport {
    private static final boolean IS_OS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    private static final String JBANG_EXECUTABLE = IS_OS_WINDOWS ? "jbang.cmd" : "jbang";
    private static final Predicate<Path> EXISTS_AND_WRITABLE = p -> p != null && p.toFile().exists() && p.toFile().canWrite();
    private static final String[] windowsWrapper = new String[]{"jbang.cmd", "jbang.ps1"};
    private static final String otherWrapper = "jbang";
    private final boolean interactiveMode;
    private final MessageWriter output;
    private Path workingDirectory;
    private Optional<Boolean> installed = Optional.empty();
    private Optional<String> version = Optional.empty();

    public JBangSupport(boolean interactiveMode, MessageWriter output) {
        this(interactiveMode, output, Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    public JBangSupport(boolean interactiveMode, MessageWriter output, Path workingDirectory) {
        this.interactiveMode = interactiveMode;
        this.output = output;
        this.workingDirectory = workingDirectory;
    }

    public Optional<File> findWrapper() {
        return Optional.ofNullable(Executable.findWrapper(this.workingDirectory, windowsWrapper, otherWrapper));
    }

    public Optional<File> findExecutableInPath() {
        try {
            return Optional.ofNullable(Executable.findExecutableFile(otherWrapper));
        }
        catch (Exception e) {
            this.output.warn("jbang not found in PATH");
            return Optional.empty();
        }
    }

    public Optional<File> findExecutableInLocalJbang() {
        try {
            return Optional.ofNullable(this.getInstallationDir()).map(d -> d.resolve("bin").resolve(JBANG_EXECUTABLE)).map(Path::toFile).filter(File::exists);
        }
        catch (Exception e) {
            this.output.warn("jbang not found in .jbang");
            return Optional.empty();
        }
    }

    public Optional<File> getOptionalExecutable() {
        return this.getOptionalExecutable(true);
    }

    public Optional<File> getOptionalExecutable(boolean shouldEnsureInstallation) {
        return this.findWrapper().or(() -> this.findExecutableInPath()).or(() -> this.findExecutableInLocalJbang()).or(() -> shouldEnsureInstallation && this.ensureJBangIsInstalled() ? this.findExecutableInLocalJbang() : Optional.empty()).map(e -> {
            if (!e.canExecute()) {
                e.setExecutable(true);
            }
            return e;
        });
    }

    public File getExecutable() {
        return this.getOptionalExecutable().orElseThrow(() -> new IllegalStateException("Unable to find and install JBang"));
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public List<String> getCommand() {
        return List.of(this.getExecutable().getAbsolutePath());
    }

    public List<String> execute(String ... args) {
        return (List)ProcessBuilder.newBuilder((Path)this.getExecutable().toPath()).arguments(args).output().processWith(br -> br.lines().limit(100000L).map(s -> s.replaceAll("\u001b\\[[;\\d]*m", "")).toList()).run();
    }

    public Optional<String> version() {
        if (this.version.isPresent()) {
            return this.version;
        }
        this.version = this.execute("version").stream().findFirst();
        return this.version;
    }

    public boolean isAvailable() {
        return this.getOptionalExecutable(false).isPresent() && this.version().isPresent();
    }

    public boolean isInstallable() {
        return this.interactiveMode;
    }

    public boolean promptForInstallation() {
        return this.interactiveMode && Prompt.yesOrNo(true, "JBang is needed to list/run JBang plugins, would you like to install it now?", new String[0]);
    }

    public boolean ensureJBangIsInstalled() {
        if (!this.installed.isPresent()) {
            this.installed = Optional.of(this.doEnsureJBangIsInstalledInternal());
        }
        return this.installed.orElseThrow();
    }

    private boolean doEnsureJBangIsInstalledInternal() {
        if (this.isAvailable()) {
            return true;
        }
        if (!this.isInstallable()) {
            this.output.warn("JBang is not installable");
            return false;
        }
        if (this.promptForInstallation()) {
            try {
                this.installJBang();
                return true;
            }
            catch (Exception e) {
                this.output.warn("Failed to install JBang");
                return false;
            }
        }
        return false;
    }

    private Path getInstallationDir() {
        Path currentDir = this.workingDirectory;
        Optional<Path> dir = Optional.ofNullable(currentDir).filter(EXISTS_AND_WRITABLE);
        while (dir.map(Path::getParent).filter(EXISTS_AND_WRITABLE).isPresent()) {
            dir = dir.map(Path::getParent);
        }
        return dir.map(d -> d.resolve(".jbang")).orElseThrow(() -> new IllegalStateException("Failed to determine .jbang directory"));
    }

    private void installJBang() {
        try {
            String uri = "https://www.jbang.dev/releases/latest/download/jbang.zip";
            Path downloadDir = Files.createTempDirectory("jbang-download-", new FileAttribute[0]);
            if (!downloadDir.toFile().exists() && !downloadDir.toFile().mkdirs()) {
                throw new IOException("Failed to create JBang download directory: " + downloadDir.toAbsolutePath().toString());
            }
            Path downloadFile = downloadDir.resolve("jbang.zip");
            Path installDir = this.getInstallationDir();
            if (!installDir.toFile().exists() && !installDir.toFile().mkdirs()) {
                throw new IOException("Failed to create JBang install directory: " + installDir.toAbsolutePath().toString());
            }
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(uri)).GET().build();
            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFile(downloadFile));
            ZipUtils.unzip((Path)downloadFile, (Path)downloadDir);
            ZipUtils.copyFromZip((Path)downloadDir.resolve(otherWrapper), (Path)installDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

