/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.data;

import io.quarkus.devtools.commands.data.ValueMap;
import java.util.Objects;

public class QuarkusCommandOutcome<T>
extends ValueMap<QuarkusCommandOutcome<T>> {
    private final boolean success;
    private final String message;
    private final T result;

    public static <T> QuarkusCommandOutcome<T> success() {
        return new QuarkusCommandOutcome<Object>(true, null, null);
    }

    public static <T> QuarkusCommandOutcome<T> success(T result) {
        return new QuarkusCommandOutcome<T>(true, null, result);
    }

    public static QuarkusCommandOutcome<Void> failure(String message) {
        Objects.requireNonNull(message, "Message may not be null in case of a failure");
        return new QuarkusCommandOutcome<Object>(false, message, null);
    }

    private QuarkusCommandOutcome(boolean success, String message, T result) {
        this.success = success;
        this.message = message;
        this.result = result;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public T getResult() {
        return this.result;
    }
}

