/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client;

import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.client.RegistryConfigResolver;
import io.quarkus.registry.client.RegistryNonPlatformExtensionsResolver;
import io.quarkus.registry.client.RegistryPlatformExtensionsResolver;
import io.quarkus.registry.client.RegistryPlatformsResolver;
import io.quarkus.registry.config.RegistryConfig;
import java.util.Objects;

public class RegistryClient
implements RegistryNonPlatformExtensionsResolver,
RegistryPlatformExtensionsResolver,
RegistryPlatformsResolver,
RegistryConfigResolver {
    private final RegistryPlatformsResolver platforms;
    private final RegistryPlatformExtensionsResolver platformExtensions;
    private final RegistryNonPlatformExtensionsResolver nonPlatformExtensions;
    protected RegistryConfig config;

    public RegistryClient(RegistryConfig config, RegistryPlatformsResolver platforms, RegistryPlatformExtensionsResolver platformExtensions, RegistryNonPlatformExtensionsResolver nonPlatformExtensions) {
        this.config = config;
        this.platforms = platforms;
        this.platformExtensions = Objects.requireNonNull(platformExtensions);
        this.nonPlatformExtensions = nonPlatformExtensions;
    }

    @Override
    public PlatformCatalog resolvePlatforms(String quarkusVersion) throws RegistryResolutionException {
        return this.platforms == null ? null : this.platforms.resolvePlatforms(quarkusVersion);
    }

    @Override
    public ExtensionCatalog resolvePlatformExtensions(ArtifactCoords platformCoords) throws RegistryResolutionException {
        return this.platformExtensions.resolvePlatformExtensions(platformCoords);
    }

    @Override
    public ExtensionCatalog resolveNonPlatformExtensions(String quarkusVersion) throws RegistryResolutionException {
        return this.nonPlatformExtensions == null ? null : this.nonPlatformExtensions.resolveNonPlatformExtensions(quarkusVersion);
    }

    @Override
    public RegistryConfig resolveRegistryConfig() throws RegistryResolutionException {
        return this.config;
    }
}

