/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.client.RegistryClientFactory;
import io.quarkus.registry.client.maven.MavenNonPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenPlatformsResolver;
import io.quarkus.registry.config.RegistryArtifactConfig;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import io.quarkus.registry.config.RegistryMavenConfig;
import io.quarkus.registry.config.RegistryMavenRepoConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import io.quarkus.registry.config.json.JsonRegistryConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenRepoConfig;
import io.quarkus.registry.config.json.JsonRegistryPlatformsConfig;
import io.quarkus.registry.config.json.RegistriesConfigMapperHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactResult;

public class MavenRegistryClientFactory
implements RegistryClientFactory {
    private MessageWriter log;
    private MavenArtifactResolver originalResolver;
    private List<RemoteRepository> singleRegistryRepos = new ArrayList<RemoteRepository>();

    public MavenRegistryClientFactory(MavenArtifactResolver resolver, MessageWriter log) {
        this.originalResolver = Objects.requireNonNull(resolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public RegistryClient buildRegistryClient(RegistryConfig config) throws RegistryResolutionException {
        MavenPlatformsResolver platformsResolver;
        MavenNonPlatformExtensionsResolver nonPlatformExtensionsResolver;
        RegistryNonPlatformExtensionsConfig nonPlatformExtensions;
        RegistryConfig descriptor;
        ArtifactResult result;
        Objects.requireNonNull(config, "The registry config is null");
        RegistryDescriptorConfig descriptorConfig = Objects.requireNonNull(config.getDescriptor(), "The registry descriptor configuration is missing");
        MavenArtifactResolver resolver = this.originalResolver;
        this.singleRegistryRepos.clear();
        this.determineExtraRepos(config, resolver.getRepositories());
        List aggregatedRepos = resolver.getRepositories();
        if (!this.singleRegistryRepos.isEmpty()) {
            aggregatedRepos = resolver.getRemoteRepositoryManager().aggregateRepositories(resolver.getSession(), Collections.emptyList(), this.singleRegistryRepos, true);
            aggregatedRepos = resolver.getRemoteRepositoryManager().aggregateRepositories(resolver.getSession(), aggregatedRepos, resolver.getRepositories(), false);
            resolver = MavenRegistryClientFactory.newResolver(resolver, aggregatedRepos);
        }
        ArtifactCoords originalDescrCoords = descriptorConfig.getArtifact();
        DefaultArtifact registryDescriptorCoords = new DefaultArtifact(originalDescrCoords.getGroupId(), originalDescrCoords.getArtifactId(), originalDescrCoords.getClassifier(), originalDescrCoords.getType(), originalDescrCoords.getVersion());
        try {
            result = resolver.resolve((Artifact)registryDescriptorCoords);
        }
        catch (BootstrapMavenException e) {
            StringWriter buf = new StringWriter();
            try (BufferedWriter writer = new BufferedWriter(buf);){
                writer.write("Failed to resolve Quarkus extensions registry descriptor ");
                writer.write(registryDescriptorCoords.toString());
                writer.write(" using the following repositories:");
                for (RemoteRepository repo : aggregatedRepos) {
                    writer.newLine();
                    writer.write("- ");
                    writer.write(repo.getId());
                    writer.write(" (");
                    writer.write(repo.getUrl());
                    writer.write(")");
                }
            }
            catch (IOException e1) {
                buf.append(e.getLocalizedMessage());
            }
            throw new RegistryResolutionException(buf.toString());
        }
        String srcRepoId = result.getRepository() == null ? "n/a" : result.getRepository().getId();
        this.log.debug("Resolved registry descriptor %s from %s", new Object[]{registryDescriptorCoords, srcRepoId});
        if (!this.singleRegistryRepos.isEmpty()) {
            if (srcRepoId != null && !"local".equals(srcRepoId)) {
                String srcRepoUrl = null;
                for (RemoteRepository repo : resolver.getRepositories()) {
                    if (!repo.getId().equals(srcRepoId)) continue;
                    srcRepoUrl = repo.getUrl();
                    break;
                }
                if (srcRepoUrl == null) {
                    throw new IllegalStateException("Failed to locate the repository URL corresponding to repository " + srcRepoId);
                }
            } else {
                this.log.debug("Failed to determine the remote repository for %s registry descriptor %s", new Object[]{config.getId(), registryDescriptorCoords});
            }
        }
        try {
            descriptor = RegistriesConfigMapperHelper.deserialize(result.getArtifact().getFile().toPath(), JsonRegistryConfig.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize registries descriptor " + result.getArtifact().getFile(), e);
        }
        if (!MavenRegistryClientFactory.isComplete(config, descriptor)) {
            JsonRegistryConfig complete = new JsonRegistryConfig();
            MavenRegistryClientFactory.complete(complete, config, descriptor);
            config = complete;
        }
        if ((nonPlatformExtensions = config.getNonPlatformExtensions()) == null || nonPlatformExtensions.isDisabled()) {
            this.log.debug("Non-platform extension catalogs were disabled for registry %s", new Object[]{config.getId()});
            nonPlatformExtensionsResolver = null;
        } else {
            nonPlatformExtensionsResolver = new MavenNonPlatformExtensionsResolver(nonPlatformExtensions, resolver, this.log);
        }
        RegistryPlatformsConfig platformsConfig = config.getPlatforms();
        if (platformsConfig == null || platformsConfig.isDisabled()) {
            this.log.debug("Platform catalogs were disabled for registry %s", new Object[]{config.getId()});
            platformsResolver = null;
        } else {
            platformsResolver = new MavenPlatformsResolver(platformsConfig, resolver, this.log);
        }
        return new RegistryClient(config, platformsResolver, Boolean.TRUE.equals(config.getPlatforms().getExtensionCatalogsIncluded()) ? new MavenPlatformExtensionsResolver(resolver, this.log) : new MavenPlatformExtensionsResolver(this.originalResolver, this.log), nonPlatformExtensionsResolver);
    }

    private static void complete(JsonRegistryConfig complete, RegistryConfig original, RegistryConfig descriptor) {
        complete.setId(original.getId() == null ? descriptor.getId() : original.getId());
        if (original.getDescriptor() == null) {
            complete.setDescriptor(descriptor.getDescriptor());
        } else {
            complete.setDescriptor(original.getDescriptor());
        }
        if (original.getPlatforms() == null) {
            complete.setPlatforms(descriptor.getPlatforms());
        } else {
            complete.setPlatforms(MavenRegistryClientFactory.complete(original.getPlatforms(), descriptor.getPlatforms()));
        }
        if (original.getNonPlatformExtensions() == null) {
            complete.setNonPlatformExtensions(descriptor.getNonPlatformExtensions());
        } else {
            complete.setNonPlatformExtensions(descriptor.getNonPlatformExtensions());
        }
        if (original.getUpdatePolicy() == null) {
            complete.setUpdatePolicy(descriptor.getUpdatePolicy());
        } else {
            complete.setUpdatePolicy(original.getUpdatePolicy());
        }
        if (original.getMaven() == null) {
            complete.setMaven(descriptor.getMaven());
        } else if (MavenRegistryClientFactory.isComplete(original.getMaven())) {
            complete.setMaven(original.getMaven());
        } else {
            JsonRegistryMavenConfig completeMavenConfig = new JsonRegistryMavenConfig();
            complete.setMaven(completeMavenConfig);
            MavenRegistryClientFactory.complete(completeMavenConfig, original.getMaven(), descriptor.getMaven() == null ? completeMavenConfig : descriptor.getMaven());
        }
        if (original.getQuarkusVersions() == null) {
            complete.setQuarkusVersions(descriptor.getQuarkusVersions());
        }
    }

    private static RegistryPlatformsConfig complete(RegistryPlatformsConfig client, RegistryPlatformsConfig descriptor) {
        if (client == null) {
            return descriptor;
        }
        if (MavenRegistryClientFactory.isComplete(client)) {
            return client;
        }
        JsonRegistryPlatformsConfig complete = new JsonRegistryPlatformsConfig();
        complete.setArtifact(client.getArtifact() == null ? descriptor.getArtifact() : client.getArtifact());
        complete.setDisabled(client.isDisabled());
        complete.setExtensionCatalogsIncluded(client.getExtensionCatalogsIncluded() == null ? descriptor.getExtensionCatalogsIncluded() : client.getExtensionCatalogsIncluded());
        return complete;
    }

    private static void complete(JsonRegistryMavenConfig complete, RegistryMavenConfig original, RegistryMavenConfig descriptor) {
        if (original.getRepository() == null) {
            complete.setRepository(descriptor.getRepository());
        } else if (MavenRegistryClientFactory.isComplete(original.getRepository()) || descriptor.getRepository() == null) {
            complete.setRepository(original.getRepository());
        } else {
            JsonRegistryMavenRepoConfig completeRepo = new JsonRegistryMavenRepoConfig();
            complete.setRepository(completeRepo);
            MavenRegistryClientFactory.complete(completeRepo, original.getRepository(), descriptor.getRepository());
        }
    }

    private static void complete(JsonRegistryMavenRepoConfig complete, RegistryMavenRepoConfig original, RegistryMavenRepoConfig descriptor) {
        complete.setId(original.getId() == null ? descriptor.getId() : original.getId());
        complete.setUrl(original.getUrl() == null ? descriptor.getUrl() : original.getUrl());
    }

    private static boolean isComplete(RegistryConfig client, RegistryConfig descriptor) {
        if (client.isDisabled()) {
            return true;
        }
        if (client.getDescriptor() == null) {
            return false;
        }
        if (!MavenRegistryClientFactory.isComplete(client.getPlatforms(), descriptor.getPlatforms())) {
            return false;
        }
        if (!MavenRegistryClientFactory.isComplete(client.getNonPlatformExtensions())) {
            return false;
        }
        if (!MavenRegistryClientFactory.isComplete(client.getMaven())) {
            return false;
        }
        if (client.getQuarkusVersions() == null && descriptor.getQuarkusVersions() != null) {
            return false;
        }
        return client.getUpdatePolicy() != null || descriptor.getUpdatePolicy() == null;
    }

    private static boolean isComplete(RegistryMavenConfig config) {
        if (config == null) {
            return false;
        }
        return MavenRegistryClientFactory.isComplete(config.getRepository());
    }

    private static boolean isComplete(RegistryPlatformsConfig client, RegistryPlatformsConfig descriptor) {
        if (!MavenRegistryClientFactory.isComplete(client)) {
            return false;
        }
        return descriptor == null || !Boolean.TRUE.equals(descriptor.getExtensionCatalogsIncluded()) || client.getExtensionCatalogsIncluded() != null;
    }

    private static boolean isComplete(RegistryArtifactConfig config) {
        if (config == null) {
            return false;
        }
        return config.isDisabled() || config.getArtifact() != null;
    }

    private static boolean isComplete(RegistryMavenRepoConfig config) {
        if (config == null) {
            return false;
        }
        if (config.getId() == null) {
            return false;
        }
        return config.getUrl() != null;
    }

    private static MavenArtifactResolver newResolver(MavenArtifactResolver resolver, List<RemoteRepository> aggregatedRepos) {
        try {
            BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setRepositorySystem(resolver.getSystem()).setRepositorySystemSession(resolver.getSession()).setRemoteRepositoryManager(resolver.getRemoteRepositoryManager()).setRemoteRepositories(aggregatedRepos).setLocalRepository(resolver.getMavenContext().getLocalRepo()).setCurrentProject(resolver.getMavenContext().getCurrentProject()));
            return new MavenArtifactResolver(mvnCtx);
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to initialize maven context", e);
        }
    }

    private void determineExtraRepos(RegistryConfig config, List<RemoteRepository> configuredRepos) {
        RegistryMavenConfig mavenConfig = config.getMaven() == null ? null : config.getMaven();
        RegistryMavenRepoConfig repoConfig = mavenConfig == null ? null : mavenConfig.getRepository();
        String repoUrl = repoConfig == null || repoConfig.getUrl() == null ? "https://oss.sonatype.org/content/repositories/snapshots" : repoConfig.getUrl();
        this.addRegistryRepo(repoUrl, repoConfig == null || repoConfig.getId() == null ? config.getId() : repoConfig.getId(), config.getUpdatePolicy(), configuredRepos);
    }

    private void addRegistryRepo(String repoUrl, String defaultRepoId, String updatePolicy, List<RemoteRepository> configuredRepos) {
        HashSet<String> ids = new HashSet<String>(configuredRepos.size());
        for (RemoteRepository repo : configuredRepos) {
            if (repo.getUrl().equals(repoUrl)) {
                return;
            }
            ids.add(repo.getId());
        }
        String repoId = defaultRepoId;
        if (ids.contains(repoId)) {
            String tmp;
            int i = 2;
            while (!ids.contains(tmp = repoId + "-" + i++)) {
            }
            repoId = tmp;
        }
        RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repoId, "default", repoUrl);
        if (updatePolicy != null) {
            if (updatePolicy.equalsIgnoreCase("daily") || updatePolicy.equalsIgnoreCase("always") || updatePolicy.equalsIgnoreCase("never") || updatePolicy.startsWith("interval")) {
                repoBuilder.setPolicy(new RepositoryPolicy(true, updatePolicy, "warn"));
            } else {
                throw new IllegalStateException("Unrecognized update policy '" + updatePolicy + "' for repository " + repoId);
            }
        }
        this.singleRegistryRepos.add(repoBuilder.build());
    }
}

