/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import io.quarkus.registry.config.RegistryMavenConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import io.quarkus.registry.config.RegistryQuarkusVersionsConfig;
import io.quarkus.registry.config.json.JsonRegistryDescriptorConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenConfig;
import io.quarkus.registry.config.json.JsonRegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.json.JsonRegistryPlatformsConfig;
import io.quarkus.registry.config.json.JsonRegistryQuarkusVersionsConfig;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JsonRegistryConfig
implements RegistryConfig {
    private String id;
    private boolean disabled;
    private String updatePolicy;
    private RegistryDescriptorConfig descriptor;
    private RegistryPlatformsConfig platforms;
    private RegistryNonPlatformExtensionsConfig nonPlatformExtensions;
    private RegistryMavenConfig mavenConfig;
    private RegistryQuarkusVersionsConfig versionsConfig;

    public JsonRegistryConfig() {
    }

    public JsonRegistryConfig(String id) {
        this.id = Objects.requireNonNull(id, "QER ID can't be null");
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = Objects.requireNonNull(id);
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    @Override
    @JsonDeserialize(as=JsonRegistryDescriptorConfig.class)
    public RegistryDescriptorConfig getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(RegistryDescriptorConfig descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    @JsonDeserialize(as=JsonRegistryPlatformsConfig.class)
    public RegistryPlatformsConfig getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(RegistryPlatformsConfig platforms) {
        this.platforms = platforms;
    }

    @Override
    @JsonDeserialize(as=JsonRegistryNonPlatformExtensionsConfig.class)
    public RegistryNonPlatformExtensionsConfig getNonPlatformExtensions() {
        return this.nonPlatformExtensions;
    }

    public void setNonPlatformExtensions(RegistryNonPlatformExtensionsConfig nonPlatformExtensions) {
        this.nonPlatformExtensions = nonPlatformExtensions;
    }

    boolean isIdOnly() {
        return this.mavenConfig == null;
    }

    @Override
    @JsonDeserialize(as=JsonRegistryMavenConfig.class)
    public RegistryMavenConfig getMaven() {
        return this.mavenConfig;
    }

    public void setMaven(RegistryMavenConfig mavenConfig) {
        this.mavenConfig = mavenConfig;
    }

    @Override
    @JsonDeserialize(as=JsonRegistryQuarkusVersionsConfig.class)
    public RegistryQuarkusVersionsConfig getQuarkusVersions() {
        return this.versionsConfig;
    }

    public void setQuarkusVersions(RegistryQuarkusVersionsConfig quarkusVersions) {
        this.versionsConfig = quarkusVersions;
    }

    public String toString() {
        return "[" + this.id + " maven=" + this.mavenConfig + "]";
    }
}

