/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.union;

import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.union.Element;
import io.quarkus.registry.union.ElementCatalog;
import io.quarkus.registry.union.Member;
import io.quarkus.registry.union.Union;
import io.quarkus.registry.union.UnionVersion;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class ElementCatalogBuilder {
    private final Map<Object, ElementBuilder> elements = new HashMap<Object, ElementBuilder>();
    private final Map<Object, MemberBuilder> members = new HashMap<Object, MemberBuilder>();
    private final Map<UnionVersion, UnionBuilder> unions = new HashMap<UnionVersion, UnionBuilder>();

    public static ElementCatalogBuilder newInstance() {
        return new ElementCatalogBuilder();
    }

    private ElementBuilder getOrCreateElement(Object elementKey, Object elementVersion) {
        return this.elements.computeIfAbsent(elementKey, k -> new ElementBuilder(k, elementVersion));
    }

    private MemberBuilder getOrCreateMember(Object key, Object version) {
        return this.members.computeIfAbsent(key + ":" + version, k -> new MemberBuilder(key, version));
    }

    public UnionBuilder getOrCreateUnion(int version) {
        return this.getOrCreateUnion(IntVersion.get(version));
    }

    public UnionBuilder getOrCreateUnion(UnionVersion version) {
        return this.unions.computeIfAbsent(version, v -> new UnionBuilder(version));
    }

    public ElementCatalog build() {
        final HashMap<Object, Element> map = new HashMap<Object, Element>(this.elements.size());
        for (ElementBuilder eb : this.elements.values()) {
            Element e = eb.build();
            map.put(e.key(), e);
        }
        for (MemberBuilder m : this.members.values()) {
            m.build();
        }
        for (UnionBuilder u : this.unions.values()) {
            u.build();
        }
        ElementCatalog catalog = new ElementCatalog(){

            @Override
            public Collection<Element> elements() {
                return map.values();
            }

            @Override
            public Collection<Object> elementKeys() {
                return ElementCatalogBuilder.this.elements.keySet();
            }

            @Override
            public Element get(Object elementKey) {
                return (Element)map.get(elementKey);
            }

            public String toString() {
                return ElementCatalogBuilder.this.elements.toString();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }
        };
        return catalog;
    }

    public static void dump(PrintStream ps, ElementCatalog catalog) {
        ps.println("Element Catalog:");
        TreeMap<UnionVersion, Map> unions = new TreeMap<UnionVersion, Map>();
        for (Element element : catalog.elements()) {
            for (Member m : element.members()) {
                for (UnionVersion uv : m.unions()) {
                    unions.computeIfAbsent(uv, v -> new HashMap()).put(m.key(), m);
                }
            }
        }
        for (Map.Entry entry : unions.entrySet()) {
            System.out.println("Union " + entry.getKey());
            for (Member m : ((Map)entry.getValue()).values()) {
                System.out.println("  Member " + m.key() + ":" + m.version());
                for (Object e : m.elementKeys()) {
                    System.out.println("    Element " + e);
                }
            }
        }
    }

    public static List<ArtifactCoords> getBoms(ElementCatalog elementCatalog, Collection<String> elementKeys) {
        Comparator comparator = Comparable::compareTo;
        TreeMap unionVersions = new TreeMap(comparator.reversed());
        for (String elementKey : elementKeys) {
            Element e = elementCatalog.get(elementKey);
            if (e == null) {
                throw new RuntimeException("Element " + elementKey + " not found in the catalog " + elementCatalog.elementKeys());
            }
            for (Member m : e.members()) {
                for (UnionVersion uv : m.unions()) {
                    unionVersions.computeIfAbsent(uv, v -> new HashMap()).put(ArtifactCoords.fromString((String)(m.key() + "::pom:" + m.version())), m);
                }
            }
        }
        for (Map members : unionVersions.values()) {
            Member m;
            HashSet<Object> memberElementKeys = new HashSet<Object>();
            Iterator i = members.values().iterator();
            m = null;
            while (i.hasNext()) {
                m = (Member)i.next();
                memberElementKeys.addAll(m.elementKeys());
            }
            if (!memberElementKeys.containsAll(elementKeys)) continue;
            ArrayList<ArtifactCoords> boms = new ArrayList<ArtifactCoords>();
            for (ArtifactCoords bom : members.keySet()) {
                boms.add(bom);
            }
            return boms;
        }
        return Collections.emptyList();
    }

    static class IntVersion
    implements UnionVersion {
        private final Integer version;

        static UnionVersion get(Integer i) {
            return new IntVersion(i);
        }

        public IntVersion(int version) {
            this.version = version;
        }

        @Override
        public int compareTo(UnionVersion o) {
            if (o instanceof IntVersion) {
                return this.version.compareTo(((IntVersion)o).version);
            }
            throw new IllegalArgumentException(o + " is not an instance of " + IntVersion.class.getName());
        }

        public String toString() {
            return this.version.toString();
        }
    }

    private abstract class BuildCallback<T> {
        private BuildCallback() {
        }

        protected abstract void created(T var1);
    }

    public class UnionBuilder
    extends BuildCallback<Member> {
        private final UnionVersion version;
        private final List<MemberBuilder> memberBuilders = new ArrayList<MemberBuilder>();
        private final Map<Object, Member> members = new HashMap<Object, Member>();

        private UnionBuilder(UnionVersion version) {
            this.version = Objects.requireNonNull(version);
        }

        public MemberBuilder getOrCreateMember(Object memberKey, Object memberVersion) {
            MemberBuilder mb = ElementCatalogBuilder.this.getOrCreateMember(memberKey, memberVersion);
            this.memberBuilders.add(mb);
            return mb.addUnion(this);
        }

        @Override
        protected void created(Member t) {
            this.members.put(t.key(), t);
        }

        public Union build() {
            Union u = new Union(){

                @Override
                public UnionVersion verion() {
                    return UnionBuilder.this.version;
                }

                @Override
                public Collection<Member> members() {
                    return UnionBuilder.this.members.values();
                }

                @Override
                public Member member(Object memberKey) {
                    return UnionBuilder.this.members.get(memberKey);
                }

                public String toString() {
                    return UnionBuilder.this.version.toString() + UnionBuilder.this.members;
                }
            };
            for (MemberBuilder mb : this.memberBuilders) {
                mb.initialUnion = u;
            }
            return u;
        }
    }

    public class MemberBuilder
    extends BuildCallback<Element> {
        private final Object key;
        private final Object version;
        private Union initialUnion;
        private List<UnionVersion> unionVersions = new ArrayList<UnionVersion>();
        private final List<BuildCallback<Member>> callbacks = new ArrayList<BuildCallback<Member>>();
        private final Map<Object, Element> elements = new HashMap<Object, Element>();

        private MemberBuilder(Object key, Object version) {
            this.key = Objects.requireNonNull(key);
            this.version = Objects.requireNonNull(version);
        }

        public ElementBuilder addElement(Object elementKey) {
            return ElementCatalogBuilder.this.getOrCreateElement(elementKey, this.version).addCallback(this);
        }

        MemberBuilder addUnion(UnionBuilder union) {
            this.callbacks.add(union);
            this.unionVersions.add(union.version);
            return this;
        }

        @Override
        protected void created(Element t) {
            this.elements.put(t.key(), t);
        }

        public Member build() {
            Member m = new Member(){

                @Override
                public Object key() {
                    return MemberBuilder.this.key;
                }

                @Override
                public Object version() {
                    return MemberBuilder.this.version;
                }

                @Override
                public Union initialUnion() {
                    return MemberBuilder.this.initialUnion;
                }

                @Override
                public Collection<Element> elements() {
                    return MemberBuilder.this.elements.values();
                }

                @Override
                public Collection<Object> elementKeys() {
                    return MemberBuilder.this.elements.keySet();
                }

                @Override
                public Element get(Object elementKey) {
                    return MemberBuilder.this.elements.get(elementKey);
                }

                public String toString() {
                    return MemberBuilder.this.key.toString() + "#" + MemberBuilder.this.version + MemberBuilder.this.elements.values();
                }

                @Override
                public boolean containsAll(Collection<Object> elementKeys) {
                    return MemberBuilder.this.elements.keySet().containsAll(elementKeys);
                }

                @Override
                public Collection<UnionVersion> unions() {
                    return MemberBuilder.this.unionVersions;
                }

                @Override
                public boolean isEmpty() {
                    return MemberBuilder.this.elements.isEmpty();
                }
            };
            this.callbacks.forEach(c -> c.created(m));
            return m;
        }
    }

    public class ElementBuilder
    extends BuildCallback<Member> {
        private final Object key;
        private final Object version;
        private final List<BuildCallback<Element>> callbacks = new ArrayList<BuildCallback<Element>>(4);
        private final List<Member> members = new ArrayList<Member>();

        private ElementBuilder(Object key, Object version) {
            this.key = Objects.requireNonNull(key);
            this.version = Objects.requireNonNull(version);
        }

        private ElementBuilder addCallback(MemberBuilder callback) {
            this.callbacks.add(callback);
            callback.callbacks.add(this);
            return this;
        }

        private Element build() {
            Element e = new Element(){

                @Override
                public Object key() {
                    return ElementBuilder.this.key;
                }

                @Override
                public Collection<Member> members() {
                    return ElementBuilder.this.members;
                }

                public String toString() {
                    return ElementBuilder.this.key.toString() + "#" + ElementBuilder.this.version;
                }
            };
            this.callbacks.forEach(c -> c.created(e));
            return e;
        }

        @Override
        protected void created(Member t) {
            this.members.add(t);
        }
    }
}

