/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.resolution.ArtifactResult;

public class MavenRegistryArtifactResolverWithCleanup
implements MavenRegistryArtifactResolver {
    private final MavenArtifactResolver resolver;
    private final boolean cleanupTimestampedVersions;

    public MavenRegistryArtifactResolverWithCleanup(MavenArtifactResolver resolver, boolean cleanupOldTimestampedVersions) {
        this.resolver = Objects.requireNonNull(resolver, "resolver can't be null");
        this.cleanupTimestampedVersions = cleanupOldTimestampedVersions;
    }

    @Override
    public Path resolve(Artifact artifact) throws BootstrapMavenException {
        return MavenRegistryArtifactResolverWithCleanup.resolveAndCleanupOldTimestampedVersions(this.resolver, artifact, this.cleanupTimestampedVersions).getArtifact().getFile().toPath();
    }

    @Override
    public String getLatestVersionFromRange(Artifact artifact, String versionRange) throws BootstrapMavenException {
        return this.resolver.getLatestVersionFromRange(artifact, versionRange);
    }

    protected static ArtifactResult resolveAndCleanupOldTimestampedVersions(MavenArtifactResolver resolver, Artifact artifact, boolean cleanupOldTimestampedVersions) throws BootstrapMavenException {
        if (!artifact.isSnapshot() || !cleanupOldTimestampedVersions) {
            return resolver.resolve(artifact);
        }
        LocalRepositoryManager localRepoManager = resolver.getSession().getLocalRepositoryManager();
        File jsonDir = new File(localRepoManager.getRepository().getBasedir(), localRepoManager.getPathForLocalArtifact(artifact)).getParentFile();
        List existingFiles = jsonDir.exists() ? Arrays.asList(jsonDir.list()) : Collections.emptyList();
        ArtifactResult result = resolver.resolve(artifact);
        File[] jsonDirContent = jsonDir.listFiles();
        if (jsonDirContent != null && jsonDirContent.length > existingFiles.size()) {
            String fileName = result.getArtifact().getFile().getName();
            for (File c : jsonDirContent) {
                if (c.getName().length() <= fileName.length() || !c.getName().startsWith(artifact.getArtifactId()) || !c.getName().endsWith(artifact.getClassifier()) || !existingFiles.contains(c.getName())) continue;
                c.deleteOnExit();
            }
        }
        return result;
    }
}

