/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.union;

import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import io.quarkus.registry.union.Element;
import io.quarkus.registry.union.ElementCatalog;
import io.quarkus.registry.union.Member;
import io.quarkus.registry.union.Union;
import io.quarkus.registry.union.UnionVersion;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ElementCatalogBuilder<M> {
    private final Map<Object, ElementBuilder<M>> elements = new HashMap<Object, ElementBuilder<M>>();
    private final Map<Object, MemberBuilder<M>> members = new HashMap<Object, MemberBuilder<M>>();
    private final Map<UnionVersion, UnionBuilder<M>> unions = new HashMap<UnionVersion, UnionBuilder<M>>();

    public static <T> ElementCatalogBuilder<T> newInstance() {
        return new ElementCatalogBuilder();
    }

    private ElementBuilder<M> getOrCreateElement(Object elementKey, Object elementVersion) {
        return this.elements.computeIfAbsent(elementKey, k -> new ElementBuilder(k, elementVersion));
    }

    private MemberBuilder<M> getOrCreateMember(Object key, Object version, M instance) {
        return this.members.computeIfAbsent(key + ":" + version, k -> new MemberBuilder<Object>(key, version, this, instance));
    }

    public UnionBuilder<M> getOrCreateUnion(int version) {
        return this.getOrCreateUnion(IntVersion.get(version));
    }

    public UnionBuilder<M> getOrCreateUnion(UnionVersion version) {
        return this.unions.computeIfAbsent(version, v -> new UnionBuilder(version, this));
    }

    public ElementCatalog<M> build() {
        final HashMap<Object, Element<M>> builtElements = new HashMap<Object, Element<M>>(this.elements.size());
        for (ElementBuilder<M> elementBuilder : this.elements.values()) {
            Element<M> element = elementBuilder.build();
            builtElements.put(element.key(), element);
        }
        for (MemberBuilder memberBuilder : this.members.values()) {
            memberBuilder.build();
        }
        final ArrayList<Union<M>> builtUnions = new ArrayList<Union<M>>(this.unions.size());
        for (UnionBuilder<M> unionBuilder : this.unions.values()) {
            builtUnions.add(unionBuilder.build());
        }
        ElementCatalog elementCatalog = new ElementCatalog<M>(){

            @Override
            public Collection<Element<M>> elements() {
                return builtElements.values();
            }

            @Override
            public Collection<Object> elementKeys() {
                return builtElements.keySet();
            }

            @Override
            public Element<M> get(Object elementKey) {
                return (Element)builtElements.get(elementKey);
            }

            public String toString() {
                return builtElements.toString();
            }

            @Override
            public boolean isEmpty() {
                return builtElements.isEmpty();
            }

            @Override
            public Collection<Union<M>> unions() {
                return builtUnions;
            }
        };
        return elementCatalog;
    }

    public static <T> void dump(PrintStream ps, ElementCatalog<T> catalog) {
        ps.println("Element Catalog:");
        TreeMap<UnionVersion, Map> unions = new TreeMap<UnionVersion, Map>();
        for (Element<T> element : catalog.elements()) {
            for (Member<T> member : element.members()) {
                for (Union u : member.unions()) {
                    unions.computeIfAbsent(u.version(), v -> new HashMap()).put(member.key(), member);
                }
            }
        }
        for (Map.Entry entry : unions.entrySet()) {
            System.out.println("Union " + entry.getKey());
            for (Member<Object> member : ((Map)entry.getValue()).values()) {
                System.out.println("  Member " + member.key() + ":" + member.version());
                for (Object e : member.elementKeys()) {
                    System.out.println("    Element " + e);
                }
            }
        }
    }

    public static <T> List<T> getMembersForElements(ElementCatalog<T> elementCatalog, Collection<String> elementKeys) {
        TreeMap<UnionVersion, Map> unionVersions = new TreeMap<UnionVersion, Map>(Comparable::compareTo);
        for (String elementKey : elementKeys) {
            Element<T> e = elementCatalog.get(elementKey);
            if (e == null) {
                throw new RuntimeException("Element " + elementKey + " not found in the catalog " + elementCatalog.elementKeys());
            }
            for (Member<T> member : e.members()) {
                for (Union u : member.unions()) {
                    unionVersions.computeIfAbsent(u.version(), v -> new IdentityHashMap()).put(member, member);
                }
            }
        }
        HashSet<Object> memberElementKeys = new HashSet<Object>();
        for (Map members : unionVersions.values()) {
            memberElementKeys.clear();
            for (Member<Object> member : members.values()) {
                memberElementKeys.addAll(member.elementKeys());
            }
            if (!memberElementKeys.containsAll(elementKeys)) continue;
            return members.values().stream().map(Member::getInstance).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static void addUnionMember(UnionBuilder<ExtensionCatalog> union, ExtensionCatalog ec) {
        MemberBuilder<ExtensionCatalog> builder = union.getOrCreateMember(ec.getId(), ec.getBom().getVersion(), ec);
        ec.getExtensions().forEach(e -> builder.addElement(e.getArtifact().getGroupId() + ":" + e.getArtifact().getArtifactId()));
    }

    public static void setElementCatalog(ExtensionCatalog extCatalog, ElementCatalog<?> elemCatalog) {
        if (!elemCatalog.isEmpty()) {
            Map<String, Object> metadata = extCatalog.getMetadata();
            if (metadata.isEmpty()) {
                metadata = new HashMap<String, Object>(1);
                ((JsonExtensionCatalog)extCatalog).setMetadata(metadata);
            }
            metadata.put("element-catalog", elemCatalog);
        }
    }

    public static boolean hasElementCatalog(ExtensionCatalog extCatalog) {
        return extCatalog.getMetadata().containsKey("element-catalog");
    }

    public static <T> ElementCatalog<T> getElementCatalog(ExtensionCatalog extCatalog, Class<T> t) {
        return (ElementCatalog)extCatalog.getMetadata().get("element-catalog");
    }

    static class IntVersion
    implements UnionVersion {
        private final Integer version;

        static UnionVersion get(Integer i) {
            return new IntVersion(i);
        }

        public IntVersion(int version) {
            this.version = version;
        }

        @Override
        public int compareTo(UnionVersion o) {
            if (o instanceof IntVersion) {
                return this.version.compareTo(((IntVersion)o).version);
            }
            throw new IllegalArgumentException(o + " is not an instance of " + IntVersion.class.getName());
        }

        public String toString() {
            return this.version.toString();
        }
    }

    private static abstract class BuildCallback<T> {
        private BuildCallback() {
        }

        protected abstract void created(T var1);
    }

    public static class UnionBuilder<T>
    extends BuildCallback<Member<T>> {
        private final UnionVersion version;
        private final ElementCatalogBuilder<T> catalogBuilder;
        private final List<MemberBuilder<T>> memberBuilders = new ArrayList<MemberBuilder<T>>();
        private final Map<Object, Member<T>> members = new HashMap<Object, Member<T>>();

        private UnionBuilder(UnionVersion version, ElementCatalogBuilder<T> catalogBuilder) {
            this.version = Objects.requireNonNull(version);
            this.catalogBuilder = catalogBuilder;
        }

        public UnionVersion version() {
            return this.version;
        }

        public MemberBuilder<T> getOrCreateMember(Object memberKey, Object memberVersion) {
            return this.getOrCreateMember(memberKey, memberVersion, null);
        }

        public MemberBuilder<T> getOrCreateMember(Object memberKey, Object memberVersion, T instance) {
            MemberBuilder<T> mb = this.catalogBuilder.getOrCreateMember(memberKey, memberVersion, instance);
            this.memberBuilders.add(mb);
            return mb.addUnion(this);
        }

        @Override
        protected void created(Member<T> t) {
            this.members.put(t.key(), t);
        }

        public Union<T> build() {
            Union u = new Union<T>(){

                @Override
                public UnionVersion version() {
                    return version;
                }

                @Override
                public Collection<Member<T>> members() {
                    return members.values();
                }

                @Override
                public Member<T> member(Object memberKey) {
                    return members.get(memberKey);
                }

                public String toString() {
                    return version.toString() + members;
                }
            };
            for (MemberBuilder<T> mb : this.memberBuilders) {
                mb.createdUnion(u);
            }
            return u;
        }
    }

    public static class MemberBuilder<T>
    extends BuildCallback<Element<T>> {
        private final Object key;
        private final Object version;
        private final ElementCatalogBuilder<T> catalogBuilder;
        private final T instance;
        private List<Union<T>> unions = new ArrayList<Union<T>>();
        private final List<BuildCallback<Member<T>>> callbacks = new ArrayList<BuildCallback<Member<T>>>();
        private final Map<Object, Element<T>> elements = new HashMap<Object, Element<T>>();

        private MemberBuilder(Object key, Object version, ElementCatalogBuilder<T> catalogBuilder, T instance) {
            this.key = Objects.requireNonNull(key);
            this.version = Objects.requireNonNull(version);
            this.catalogBuilder = catalogBuilder;
            this.instance = instance;
        }

        public ElementBuilder<T> addElement(Object elementKey) {
            return this.catalogBuilder.getOrCreateElement(elementKey, this.version).addCallback(this);
        }

        MemberBuilder<T> addUnion(UnionBuilder<T> union) {
            this.callbacks.add(union);
            return this;
        }

        @Override
        protected void created(Element<T> t) {
            this.elements.put(t.key(), t);
        }

        private void createdUnion(Union<T> union) {
            this.unions.add(union);
        }

        public Member<T> build() {
            Member m = new Member<T>(){

                @Override
                public Object key() {
                    return key;
                }

                @Override
                public Object version() {
                    return version;
                }

                @Override
                public Collection<Element<T>> elements() {
                    return elements.values();
                }

                @Override
                public Collection<Object> elementKeys() {
                    return elements.keySet();
                }

                @Override
                public Element<T> get(Object elementKey) {
                    return elements.get(elementKey);
                }

                public String toString() {
                    return key.toString() + "#" + version + elements.values();
                }

                @Override
                public boolean containsAll(Collection<Object> elementKeys) {
                    return elements.keySet().containsAll(elementKeys);
                }

                @Override
                public Collection<Union<T>> unions() {
                    return unions;
                }

                @Override
                public boolean isEmpty() {
                    return elements.isEmpty();
                }

                @Override
                public T getInstance() {
                    return instance;
                }
            };
            this.callbacks.forEach(c -> c.created(m));
            return m;
        }
    }

    public static class ElementBuilder<T>
    extends BuildCallback<Member<T>> {
        private final Object key;
        private final Object version;
        private final List<BuildCallback<Element<T>>> callbacks = new ArrayList<BuildCallback<Element<T>>>();
        private final List<Member<T>> members = new ArrayList<Member<T>>();

        private ElementBuilder(Object key, Object version) {
            this.key = Objects.requireNonNull(key);
            this.version = Objects.requireNonNull(version);
        }

        private ElementBuilder<T> addCallback(MemberBuilder<T> callback) {
            this.callbacks.add(callback);
            callback.callbacks.add(this);
            return this;
        }

        private Element<T> build() {
            Element e = new Element<T>(){

                @Override
                public Object key() {
                    return key;
                }

                @Override
                public Collection<Member<T>> members() {
                    return members;
                }

                public String toString() {
                    return key.toString() + "#" + version;
                }
            };
            this.callbacks.forEach(c -> c.created(e));
            return e;
        }

        @Override
        protected void created(Member<T> t) {
            this.members.add(t);
        }
    }
}

