/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.config.PropertiesUtil;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import io.quarkus.registry.config.RegistryMavenRepoConfig;
import io.quarkus.registry.config.json.JsonRegistriesConfig;
import io.quarkus.registry.config.json.JsonRegistryConfig;
import io.quarkus.registry.config.json.JsonRegistryDescriptorConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenRepoConfig;
import io.quarkus.registry.config.json.JsonRegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.json.JsonRegistryPlatformsConfig;
import io.quarkus.registry.config.json.RegistriesConfigMapperHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class RegistriesConfigLocator {
    public static final String CONFIG_RELATIVE_PATH = ".quarkus/config.yaml";
    public static final String CONFIG_FILE_PATH_PROPERTY = "quarkus.tools.config";

    public static RegistriesConfig resolveConfig() {
        Path configYaml = RegistriesConfigLocator.locateConfigYaml();
        if (configYaml == null) {
            return RegistriesConfigLocator.completeRequiredConfig(new JsonRegistriesConfig());
        }
        return RegistriesConfigLocator.load(configYaml);
    }

    public static RegistriesConfig load(Path configYaml) {
        try {
            return RegistriesConfigLocator.completeRequiredConfig(RegistriesConfigMapperHelper.deserialize(configYaml, JsonRegistriesConfig.class));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse config file " + configYaml, e);
        }
    }

    public static RegistriesConfig load(InputStream configYaml) {
        try {
            return RegistriesConfigLocator.completeRequiredConfig(RegistriesConfigMapperHelper.deserializeYaml(configYaml, JsonRegistriesConfig.class));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse config file " + configYaml, e);
        }
    }

    public static RegistriesConfig load(Reader configYaml) {
        try {
            return RegistriesConfigLocator.completeRequiredConfig(RegistriesConfigMapperHelper.deserializeYaml(configYaml, JsonRegistriesConfig.class));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse config file " + configYaml, e);
        }
    }

    public static Path locateConfigYaml() {
        String prop = PropertiesUtil.getProperty(CONFIG_FILE_PATH_PROPERTY);
        if (prop != null) {
            Path configYaml = Paths.get(prop, new String[0]);
            if (!Files.exists(configYaml, new LinkOption[0])) {
                throw new IllegalStateException("Quarkus extensions registry configuration file " + configYaml + " specified with the system property quarkus.tools.config does not exist");
            }
            return configYaml;
        }
        Path configYaml = Paths.get("", new String[0]).normalize().toAbsolutePath().resolve(CONFIG_RELATIVE_PATH);
        if (Files.exists(configYaml, new LinkOption[0])) {
            return configYaml;
        }
        configYaml = Paths.get(PropertiesUtil.getProperty("user.home"), new String[0]).resolve(CONFIG_RELATIVE_PATH);
        return Files.exists(configYaml, new LinkOption[0]) ? configYaml : null;
    }

    private static RegistriesConfig completeRequiredConfig(RegistriesConfig original) {
        JsonRegistriesConfig config = new JsonRegistriesConfig();
        config.setDebug(original.isDebug());
        if (original.getRegistries().isEmpty()) {
            config.addRegistry(RegistriesConfigLocator.getDefaultRegistry());
        } else {
            boolean sawEnabled = false;
            for (RegistryConfig qerConfig : original.getRegistries()) {
                config.addRegistry(RegistriesConfigLocator.completeRequiredConfig(qerConfig));
                sawEnabled |= qerConfig.isEnabled();
            }
            if (!sawEnabled) {
                config.addRegistry(RegistriesConfigLocator.getDefaultRegistry());
            }
        }
        return config;
    }

    private static RegistryConfig completeRequiredConfig(RegistryConfig original) {
        if (RegistriesConfigLocator.hasRequiredConfig(original)) {
            return original;
        }
        String id = original.getId();
        JsonRegistryConfig config = new JsonRegistryConfig(id);
        config.setUpdatePolicy(original.getUpdatePolicy());
        config.setEnabled(original.isEnabled());
        config.setDescriptor(RegistriesConfigLocator.completeDescriptor(original));
        if (original != null) {
            if (original.getMaven() != null) {
                config.setMaven(original.getMaven());
            }
            if (original.getNonPlatformExtensions() != null) {
                config.setNonPlatformExtensions(original.getNonPlatformExtensions());
            }
            if (original.getPlatforms() != null) {
                config.setPlatforms(original.getPlatforms());
            }
            if (!original.getExtra().isEmpty()) {
                config.setExtra(original.getExtra());
            }
        }
        return config;
    }

    private static RegistryDescriptorConfig completeDescriptor(RegistryConfig config) {
        if (config.getDescriptor() != null && config.getDescriptor().getArtifact() != null) {
            return config.getDescriptor();
        }
        JsonRegistryDescriptorConfig descriptor = new JsonRegistryDescriptorConfig();
        String host = config.getId();
        if (host == null) {
            RegistryMavenRepoConfig repo;
            RegistryMavenRepoConfig registryMavenRepoConfig = repo = config.getMaven() == null ? null : config.getMaven().getRepository();
            if (repo != null && repo.getUrl() != null) {
                throw new IllegalStateException("Failed to determine the descriptor coordinates for a registry with no ID and no Maven configuration");
            }
            host = Objects.requireNonNull(RegistriesConfigLocator.toUrlOrNull(repo.getUrl()), "REST endpoint is not a valid URL").getHost();
        }
        String[] parts = host.split("\\.");
        StringBuilder buf = new StringBuilder(host.length());
        int i = parts.length;
        buf.append(parts[--i]);
        while (--i >= 0) {
            buf.append('.').append(parts[i]);
        }
        descriptor.setArtifact(new ArtifactCoords(buf.toString(), "quarkus-registry-descriptor", null, "json", "1.0-SNAPSHOT"));
        return descriptor;
    }

    private static URL toUrlOrNull(String str) {
        try {
            return new URL(str);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static boolean hasRequiredConfig(RegistryConfig qerConfig) {
        if (qerConfig.getId() == null) {
            return false;
        }
        return qerConfig.getDescriptor() != null;
    }

    public static RegistryConfig getDefaultRegistry() {
        JsonRegistryConfig qer = new JsonRegistryConfig();
        qer.setId("registry.quarkus.io");
        JsonRegistryDescriptorConfig descriptor = new JsonRegistryDescriptorConfig();
        qer.setDescriptor(descriptor);
        descriptor.setArtifact(new ArtifactCoords("io.quarkus.registry", "quarkus-registry-descriptor", null, "json", "1.0-SNAPSHOT"));
        JsonRegistryMavenConfig mavenConfig = new JsonRegistryMavenConfig();
        qer.setMaven(mavenConfig);
        JsonRegistryPlatformsConfig platformsConfig = new JsonRegistryPlatformsConfig();
        qer.setPlatforms(platformsConfig);
        platformsConfig.setArtifact(new ArtifactCoords("io.quarkus.registry", "quarkus-platforms", null, "json", "1.0-SNAPSHOT"));
        JsonRegistryNonPlatformExtensionsConfig nonPlatformExtensionsConfig = new JsonRegistryNonPlatformExtensionsConfig();
        qer.setNonPlatformExtensions(nonPlatformExtensionsConfig);
        nonPlatformExtensionsConfig.setArtifact(new ArtifactCoords("io.quarkus.registry", "quarkus-non-platform-extensions", null, "json", "1.0-SNAPSHOT"));
        JsonRegistryMavenRepoConfig mavenRepo = new JsonRegistryMavenRepoConfig();
        mavenConfig.setRepository(mavenRepo);
        mavenRepo.setId("registry.quarkus.io");
        mavenRepo.setUrl("https://registry.quarkus.io/maven");
        return qer;
    }
}

