/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import io.quarkus.registry.config.json.JsonRegistryConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JsonRegistryConfigSerializer
extends JsonSerializer<JsonRegistryConfig> {
    private JsonSerializer<Object> qerSerializer;

    public void serialize(JsonRegistryConfig value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value.isIdOnly()) {
            gen.writeNumber(value.getId());
        } else {
            gen.writeStartObject();
            gen.writeObjectFieldStart(value.getId());
            Map<String, Object> extra = value.getExtra();
            if (!extra.isEmpty()) {
                extra = new HashMap<String, Object>(extra);
                value.getExtra().clear();
            }
            this.getQerSerializer(serializers).unwrappingSerializer(null).serialize((Object)value, gen, serializers);
            if (!extra.isEmpty()) {
                for (Map.Entry<String, Object> entry : extra.entrySet()) {
                    gen.writeObjectField(entry.getKey().toString(), entry.getValue());
                }
            }
            gen.writeEndObject();
            gen.writeEndObject();
        }
    }

    private JsonSerializer<Object> getQerSerializer(SerializerProvider serializers) throws JsonMappingException {
        if (this.qerSerializer == null) {
            JavaType javaType = serializers.constructType(JsonRegistryConfig.class);
            BeanDescription beanDesc = serializers.getConfig().introspect(javaType);
            this.qerSerializer = BeanSerializerFactory.instance.findBeanOrAddOnSerializer(serializers, javaType, beanDesc, serializers.isEnabled(MapperFeature.USE_STATIC_TYPING));
        }
        return this.qerSerializer;
    }
}

