/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.util;

import io.quarkus.maven.ArtifactCoords;

public class PlatformArtifacts {
    public static ArtifactCoords getCatalogArtifactForBom(ArtifactCoords bom) {
        return PlatformArtifacts.getCatalogArtifactForBom(bom.getGroupId(), bom.getArtifactId(), bom.getVersion());
    }

    public static ArtifactCoords getCatalogArtifactForBom(String bomGroupId, String bomArtifactId, String bomVersion) {
        return new ArtifactCoords(bomGroupId, bomArtifactId + "-quarkus-platform-descriptor", bomVersion, "json", bomVersion);
    }

    public static ArtifactCoords ensureCatalogArtifact(ArtifactCoords coords) {
        return PlatformArtifacts.isCatalogArtifact(coords) ? coords : PlatformArtifacts.getCatalogArtifactForBom(coords.getGroupId(), coords.getArtifactId(), coords.getVersion());
    }

    public static String ensureCatalogArtifactId(String artifactId) {
        return PlatformArtifacts.isCatalogArtifactId(artifactId) ? artifactId : artifactId + "-quarkus-platform-descriptor";
    }

    public static boolean isCatalogArtifactId(String artifactId) {
        return artifactId != null && artifactId.endsWith("-quarkus-platform-descriptor");
    }

    public static boolean isCatalogArtifact(ArtifactCoords coords) {
        return PlatformArtifacts.isCatalogArtifactId(coords.getArtifactId());
    }

    public static String ensureBomArtifactId(String artifactId) {
        return PlatformArtifacts.isCatalogArtifactId(artifactId) ? artifactId.substring(0, artifactId.length() - "-quarkus-platform-descriptor".length()) : artifactId;
    }

    public static ArtifactCoords ensureBomArtifact(ArtifactCoords coords) {
        return PlatformArtifacts.isCatalogArtifactId(coords.getArtifactId()) ? PlatformArtifacts.getBomArtifactForCatalog(coords) : coords;
    }

    public static ArtifactCoords getBomArtifactForCatalog(ArtifactCoords coords) {
        return new ArtifactCoords(coords.getGroupId(), coords.getArtifactId().substring(0, coords.getArtifactId().length() - "-quarkus-platform-descriptor".length()), null, "pom", coords.getVersion());
    }
}

