/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.registry.config.RegistryQuarkusVersionsConfig;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RegistryQuarkusVersionsConfigImpl
implements RegistryQuarkusVersionsConfig {
    private final String recognizedVersionsExpression;
    private final boolean exclusiveProvider;

    private RegistryQuarkusVersionsConfigImpl(String recognizedVersionsExpression, boolean exclusiveProvider) {
        this.exclusiveProvider = exclusiveProvider;
        this.recognizedVersionsExpression = recognizedVersionsExpression;
    }

    @Override
    public String getRecognizedVersionsExpression() {
        return this.recognizedVersionsExpression;
    }

    @Override
    public boolean isExclusiveProvider() {
        return this.exclusiveProvider;
    }

    public boolean equals(Object o) {
        return RegistryQuarkusVersionsConfigImpl.quarkusVersionConfigEquals(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.exclusiveProvider, this.recognizedVersionsExpression);
    }

    public String toString() {
        return RegistryQuarkusVersionsConfigImpl.quarkusVersionConfigToString(this);
    }

    static boolean quarkusVersionConfigEquals(RegistryQuarkusVersionsConfig v, Object o) {
        if (v == o) {
            return true;
        }
        if (!(o instanceof RegistryQuarkusVersionsConfig)) {
            return false;
        }
        RegistryQuarkusVersionsConfig that = (RegistryQuarkusVersionsConfig)o;
        return v.isExclusiveProvider() == that.isExclusiveProvider() && Objects.equals(v.getRecognizedVersionsExpression(), that.getRecognizedVersionsExpression());
    }

    static String quarkusVersionConfigToString(RegistryQuarkusVersionsConfig v) {
        return "RegistryQuarkusVersionsConfig{exclusiveProvider=" + v.isExclusiveProvider() + ", recognizedVersionsExpression='" + v.getRecognizedVersionsExpression() + "'}";
    }

    public static class Builder
    implements RegistryQuarkusVersionsConfig.Mutable {
        protected String recognizedVersionsExpression;
        protected boolean exclusiveProvider;

        public Builder() {
        }

        @JsonIgnore
        Builder(RegistryQuarkusVersionsConfig config) {
            this.recognizedVersionsExpression = config.getRecognizedVersionsExpression();
            this.exclusiveProvider = config.isExclusiveProvider();
        }

        @Override
        public RegistryQuarkusVersionsConfigImpl build() {
            return new RegistryQuarkusVersionsConfigImpl(this.recognizedVersionsExpression, this.exclusiveProvider);
        }

        @Override
        public String getRecognizedVersionsExpression() {
            return this.recognizedVersionsExpression;
        }

        @Override
        public RegistryQuarkusVersionsConfig.Mutable setRecognizedVersionsExpression(String recognizedVersionsExpression) {
            this.recognizedVersionsExpression = recognizedVersionsExpression;
            return this;
        }

        @Override
        public boolean isExclusiveProvider() {
            return this.exclusiveProvider;
        }

        @Override
        public RegistryQuarkusVersionsConfig.Mutable setExclusiveProvider(boolean exclusiveProvider) {
            this.exclusiveProvider = exclusiveProvider;
            return this;
        }

        public boolean equals(Object o) {
            return RegistryQuarkusVersionsConfigImpl.quarkusVersionConfigEquals(this, o);
        }

        public int hashCode() {
            return Objects.hash(this.exclusiveProvider, this.recognizedVersionsExpression);
        }

        public String toString() {
            return RegistryQuarkusVersionsConfigImpl.quarkusVersionConfigToString(this);
        }
    }
}

