/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.CatalogMergeUtility;
import io.quarkus.registry.ExclusiveProviderConflictException;
import io.quarkus.registry.RegistryExtensionResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformReleaseVersion;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.catalog.PlatformStreamCoords;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.client.RegistryClientFactory;
import io.quarkus.registry.client.maven.MavenRegistryClientFactory;
import io.quarkus.registry.client.spi.RegistryClientEnvironment;
import io.quarkus.registry.client.spi.RegistryClientFactoryProvider;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistriesConfigLocator;
import io.quarkus.registry.config.RegistryConfig;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ExtensionCatalogResolver {
    private MessageWriter log;
    private RegistriesConfig config;
    private List<RegistryExtensionResolver> registries;

    public static ExtensionCatalogResolver empty() {
        ExtensionCatalogResolver resolver = new ExtensionCatalogResolver();
        resolver.registries = Collections.emptyList();
        resolver.log = MessageWriter.info();
        return resolver;
    }

    public static Builder builder() {
        return new ExtensionCatalogResolver().new Builder();
    }

    public RegistriesConfig getConfig() {
        return this.config;
    }

    public boolean hasRegistries() {
        return !this.registries.isEmpty();
    }

    public PlatformCatalog resolvePlatformCatalog() throws RegistryResolutionException {
        return this.resolvePlatformCatalog(null);
    }

    public PlatformCatalog resolvePlatformCatalog(String quarkusVersion) throws RegistryResolutionException {
        ArrayList<PlatformCatalog.Mutable> catalogs = new ArrayList<PlatformCatalog.Mutable>(this.registries.size());
        for (RegistryExtensionResolver qer : this.registries) {
            PlatformCatalog.Mutable catalog = qer.resolvePlatformCatalog(quarkusVersion);
            if (catalog == null) continue;
            catalogs.add(catalog);
        }
        if (catalogs.isEmpty()) {
            return null;
        }
        if (catalogs.size() == 1) {
            return (PlatformCatalog)catalogs.get(0);
        }
        ArrayList<Platform> collectedPlatforms = new ArrayList<Platform>();
        HashSet<String> collectedPlatformKeys = new HashSet<String>();
        String lastUpdated = null;
        boolean sawUnknownLastUpdate = false;
        for (PlatformCatalog platformCatalog : catalogs) {
            this.collectPlatforms(platformCatalog, collectedPlatforms, collectedPlatformKeys);
            if (sawUnknownLastUpdate) continue;
            Object catalogLastUpdated = platformCatalog.getMetadata().get("last-updated");
            if (catalogLastUpdated == null) {
                lastUpdated = null;
                sawUnknownLastUpdate = true;
                continue;
            }
            if (lastUpdated == null) {
                lastUpdated = catalogLastUpdated.toString();
                continue;
            }
            if (lastUpdated.compareTo(catalogLastUpdated.toString()) >= 0) continue;
            lastUpdated = catalogLastUpdated.toString();
        }
        PlatformCatalog.Mutable result = PlatformCatalog.builder();
        if (lastUpdated != null) {
            result.getMetadata().put("last-updated", lastUpdated);
        }
        result.setPlatforms(collectedPlatforms);
        return result.build();
    }

    private void collectPlatforms(PlatformCatalog catalog, List<Platform> collectedPlatforms, Set<String> collectedPlatformKeys) {
        for (Platform p : catalog.getPlatforms()) {
            if (!collectedPlatformKeys.add(p.getPlatformKey())) continue;
            collectedPlatforms.add(p);
        }
    }

    public PlatformCatalog resolvePlatformCatalogFromRegistry(String registryId) throws RegistryResolutionException {
        return this.registries.get(this.getRegistryIndex(registryId)).resolvePlatformCatalog();
    }

    public PlatformCatalog resolvePlatformCatalogFromRegistry(String registryId, String quarkusVersion) throws RegistryResolutionException {
        return quarkusVersion == null ? this.resolvePlatformCatalogFromRegistry(registryId) : this.registries.get(this.getRegistryIndex(registryId)).resolvePlatformCatalog(quarkusVersion);
    }

    public ExtensionCatalog resolveExtensionCatalog() throws RegistryResolutionException {
        this.ensureRegistriesConfigured();
        ExtensionCatalogBuilder catalogBuilder = new ExtensionCatalogBuilder();
        for (int registryIndex = 0; registryIndex < this.registries.size(); ++registryIndex) {
            this.collectPlatformExtensions(catalogBuilder, registryIndex);
        }
        return catalogBuilder.build();
    }

    private void collectPlatformExtensions(ExtensionCatalogBuilder catalogBuilder, int registryIndex) throws RegistryResolutionException {
        RegistryExtensionResolver registry = this.registries.get(registryIndex);
        ArrayList<PlatformCatalog> downstreamPreferences = new ArrayList<PlatformCatalog>(catalogBuilder.upstreamQuarkusVersions.size());
        for (String quarkusVersion : catalogBuilder.upstreamQuarkusVersions) {
            PlatformCatalog.Mutable pc;
            if (!registry.isAcceptsQuarkusVersionQueries(quarkusVersion) || (pc = registry.resolvePlatformCatalog(quarkusVersion)) == null) continue;
            downstreamPreferences.add(pc);
        }
        PlatformCatalog pc = registry.resolvePlatformCatalog();
        if (pc == null && downstreamPreferences.isEmpty()) {
            return;
        }
        if (!downstreamPreferences.isEmpty()) {
            downstreamPreferences.add(pc);
            pc = CatalogMergeUtility.mergePlatformCatalogs(downstreamPreferences);
        }
        int platformIndex = 0;
        for (Platform platform : pc.getPlatforms()) {
            ++platformIndex;
            for (PlatformStream stream : platform.getStreams()) {
                int releaseIndex = 0;
                for (PlatformRelease release : stream.getReleases()) {
                    ++releaseIndex;
                    String quarkusVersion = release.getQuarkusCoreVersion();
                    int compatiblityCode = catalogBuilder.getCompatibilityCode(quarkusVersion, release.getUpstreamQuarkusCoreVersion());
                    if (!registry.isExclusiveProviderOf(quarkusVersion)) {
                        catalogBuilder.addUpstreamQuarkusVersion(quarkusVersion);
                    }
                    if (release.getUpstreamQuarkusCoreVersion() != null) {
                        catalogBuilder.addUpstreamQuarkusVersion(release.getUpstreamQuarkusCoreVersion());
                    }
                    int memberIndex = 0;
                    for (ArtifactCoords bom : release.getMemberBoms()) {
                        ++memberIndex;
                        ExtensionCatalog.Mutable ec = registry.resolvePlatformExtensions(bom);
                        if (ec != null) {
                            OriginPreference originPreference = new OriginPreference(registryIndex, platformIndex, releaseIndex, memberIndex, compatiblityCode);
                            this.addOriginPreference(ec, originPreference);
                            catalogBuilder.addCatalog(ec);
                            continue;
                        }
                        this.log.warn("Failed to resolve extension catalog for %s from registry %s", new Object[]{bom, registry.getId()});
                    }
                }
            }
        }
    }

    private void addOriginPreference(ExtensionCatalog.Mutable ec, OriginPreference originPreference) {
        Map<String, Object> metadata = ec.getMetadata();
        metadata.put("origin-preference", originPreference);
    }

    public ExtensionCatalog resolveExtensionCatalog(String quarkusCoreVersion) throws RegistryResolutionException {
        if (quarkusCoreVersion == null) {
            return this.resolveExtensionCatalog();
        }
        int registriesTotal = this.registries.size();
        if (registriesTotal == 0) {
            throw new RegistryResolutionException("No registries configured");
        }
        return this.resolveExtensionCatalog(quarkusCoreVersion, new ExtensionCatalogBuilder(), Collections.emptySet());
    }

    private ExtensionCatalog resolveExtensionCatalog(String quarkusCoreVersion, ExtensionCatalogBuilder catalogBuilder, Set<String> preferredPlatforms) throws RegistryResolutionException {
        this.collectPlatformExtensions(quarkusCoreVersion, catalogBuilder, preferredPlatforms);
        int i = 0;
        while (i < catalogBuilder.upstreamQuarkusVersions.size()) {
            this.collectPlatformExtensions(catalogBuilder.upstreamQuarkusVersions.get(i++), catalogBuilder, preferredPlatforms);
        }
        return catalogBuilder.build();
    }

    public ExtensionCatalog resolveExtensionCatalog(PlatformStreamCoords streamCoords) throws RegistryResolutionException {
        this.ensureRegistriesConfigured();
        String platformKey = streamCoords.getPlatformKey();
        String streamId = streamCoords.getStreamId();
        PlatformStream stream = null;
        int registryIndex = 0;
        while (registryIndex < this.registries.size() && stream == null) {
            RegistryExtensionResolver qer;
            PlatformCatalog.Mutable platforms;
            if ((platforms = (qer = this.registries.get(registryIndex++)).resolvePlatformCatalog()) == null) continue;
            if (platformKey == null) {
                Platform p;
                Iterator<Platform> iterator = platforms.getPlatforms().iterator();
                while (iterator.hasNext() && (stream = (p = iterator.next()).getStream(streamId)) == null) {
                }
                continue;
            }
            Platform platform = platforms.getPlatform(platformKey);
            if (platform == null || (stream = platform.getStream(streamId)) == null) continue;
            break;
        }
        if (stream == null) {
            Platform requestedPlatform = null;
            ArrayList<Platform> knownPlatforms = new ArrayList<Platform>();
            for (RegistryExtensionResolver qer : this.registries) {
                PlatformCatalog.Mutable platforms = qer.resolvePlatformCatalog();
                if (platforms == null) continue;
                if (platformKey != null && (requestedPlatform = platforms.getPlatform(platformKey)) != null) break;
                for (Platform platform : platforms.getPlatforms()) {
                    knownPlatforms.add(platform);
                }
            }
            StringBuilder buf = new StringBuilder();
            if (requestedPlatform != null) {
                buf.append("Failed to locate stream ").append(streamId).append(" in platform " + requestedPlatform.getPlatformKey());
            } else if (knownPlatforms.isEmpty()) {
                buf.append("None of the registries provided any platform");
            } else {
                if (platformKey == null) {
                    buf.append("Failed to locate stream ").append(streamId).append(" in platform(s): ");
                } else {
                    buf.append("Failed to locate platform ").append(platformKey).append(" among available platform(s): ");
                }
                buf.append(((Platform)knownPlatforms.get(0)).getPlatformKey());
                for (int i = 1; i < knownPlatforms.size(); ++i) {
                    buf.append(", ").append(((Platform)knownPlatforms.get(i)).getPlatformKey());
                }
            }
            throw new RegistryResolutionException(buf.toString());
        }
        ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>();
        for (PlatformRelease release : stream.getReleases()) {
            catalogs.add(this.resolveExtensionCatalog(release.getMemberBoms()));
        }
        return CatalogMergeUtility.merge(catalogs);
    }

    public ExtensionCatalog resolveExtensionCatalog(Collection<ArtifactCoords> preferredPlatforms) throws RegistryResolutionException {
        if (preferredPlatforms.isEmpty()) {
            return this.resolveExtensionCatalog();
        }
        ExtensionCatalogBuilder catalogBuilder = new ExtensionCatalogBuilder();
        HashSet<String> preferredPlatformKeys = new HashSet<String>();
        String quarkusVersion = null;
        int platformIndex = 0;
        for (ArtifactCoords bom : preferredPlatforms) {
            Object o;
            Map md;
            List<RegistryExtensionResolver> registries;
            try {
                registries = this.filterRegistries(r -> r.checkPlatform(bom));
            }
            catch (ExclusiveProviderConflictException e) {
                StringBuilder buf = new StringBuilder();
                buf.append("The following registries were configured as exclusive providers of the ");
                buf.append(bom);
                buf.append("platform: ").append(e.conflictingRegistries.get(0).getId());
                for (int i = 1; i < e.conflictingRegistries.size(); ++i) {
                    buf.append(", ").append(e.conflictingRegistries.get(i).getId());
                }
                throw new RegistryResolutionException(buf.toString());
            }
            if (registries.isEmpty()) {
                this.log.warn("None of the configured registries recognizes platform %s", new Object[]{bom});
                continue;
            }
            ExtensionCatalog catalog = null;
            RegistryExtensionResolver registry = null;
            for (int i = 0; i < registries.size(); ++i) {
                registry = registries.get(i);
                try {
                    catalog = registry.resolvePlatformExtensions(bom);
                    break;
                }
                catch (RegistryResolutionException registryResolutionException) {
                    continue;
                }
            }
            if (catalog == null) {
                StringBuilder buf = new StringBuilder();
                buf.append("Failed to resolve platform ").append(bom).append(" using the following registries: ");
                buf.append(registries.get(0).getId());
                for (int i = 1; i < registries.size(); ++i) {
                    buf.append(", ").append(registries.get(i++));
                }
                this.log.warn(buf.toString());
                throw new RegistryResolutionException(buf.toString());
            }
            if (quarkusVersion == null) {
                quarkusVersion = catalog.getQuarkusCoreVersion();
            }
            if ((md = catalog.getMetadata()) != null && (o = md.get("platform-release")) instanceof Map && (o = (md = (Map)o).get("platform-key")) instanceof String) {
                String platformKey = o.toString();
                if (!preferredPlatformKeys.add(platformKey)) continue;
                Platform.Mutable p = Platform.builder().setPlatformKey(platformKey);
                PlatformStream.Mutable stream = PlatformStream.builder().setId(String.valueOf(md.getOrDefault("stream", "default")));
                p.addStream(stream);
                PlatformRelease.Mutable release = PlatformRelease.builder().setVersion(PlatformReleaseVersion.fromString(String.valueOf(md.getOrDefault("version", "default")))).setQuarkusCoreVersion(catalog.getQuarkusCoreVersion()).setUpstreamQuarkusCoreVersion(catalog.getUpstreamQuarkusCoreVersion());
                stream.addRelease(release);
                o = md.get("members");
                if (o != null) {
                    Collection col = (Collection)o;
                    ArrayList<ArtifactCoords> coords = new ArrayList<ArtifactCoords>(col.size());
                    for (String s : col) {
                        coords.add(ArtifactCoords.fromString((String)s));
                    }
                    release.setMemberBoms(coords);
                }
                this.collectPlatformExtensions(quarkusVersion, catalogBuilder, registry, platformIndex, p);
                continue;
            }
            OriginPreference originPreference = new OriginPreference(0, ++platformIndex, 1, 1, catalogBuilder.getCompatibilityCode(quarkusVersion));
            this.addOriginPreference((ExtensionCatalog.Mutable)catalog, originPreference);
            catalogBuilder.addCatalog((ExtensionCatalog.Mutable)catalog);
        }
        return preferredPlatforms.isEmpty() ? catalogBuilder.build() : this.resolveExtensionCatalog(quarkusVersion, catalogBuilder, preferredPlatformKeys);
    }

    public void clearRegistryCache() throws RegistryResolutionException {
        for (RegistryExtensionResolver registry : this.registries) {
            registry.clearCache();
        }
    }

    private void ensureRegistriesConfigured() throws RegistryResolutionException {
        int registriesTotal = this.registries.size();
        if (registriesTotal == 0) {
            throw new RegistryResolutionException("No registries configured");
        }
    }

    private void appendNonPlatformExtensions(ExtensionCatalogBuilder catalogBuilder, String quarkusVersion) throws RegistryResolutionException {
        for (RegistryExtensionResolver registry : catalogBuilder.getRegistriesForQuarkusCore(quarkusVersion)) {
            this.appendNonPlatformExtensions(registry, catalogBuilder, quarkusVersion);
        }
    }

    public void appendNonPlatformExtensions(RegistryExtensionResolver registry, ExtensionCatalogBuilder catalogBuilder, String quarkusVersion) throws RegistryResolutionException {
        ExtensionCatalog.Mutable nonPlatformCatalog = registry.resolveNonPlatformExtensions(quarkusVersion);
        if (nonPlatformCatalog == null) {
            return;
        }
        int compatibilityCode = catalogBuilder.getCompatibilityCode(quarkusVersion);
        OriginPreference originPreference = new OriginPreference(registry.getIndex(), Integer.MAX_VALUE, compatibilityCode, 0, compatibilityCode);
        this.addOriginPreference(nonPlatformCatalog, originPreference);
        catalogBuilder.addCatalog(nonPlatformCatalog);
    }

    private int getRegistryIndex(String registryId) {
        for (int registryIndex = 0; registryIndex < this.registries.size(); ++registryIndex) {
            if (!this.registries.get(registryIndex).getId().equals(registryId)) continue;
            return registryIndex;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to locate ").append(registryId).append(" among the configured registries:");
        this.registries.forEach(r -> buf.append(" ").append(r.getId()));
        throw new IllegalStateException(buf.toString());
    }

    private void collectPlatformExtensions(String quarkusCoreVersion, ExtensionCatalogBuilder catalogBuilder, Set<String> processedPlatforms) throws RegistryResolutionException {
        List<RegistryExtensionResolver> quarkusVersionRegistries = catalogBuilder.getRegistriesForQuarkusCore(quarkusCoreVersion);
        for (RegistryExtensionResolver registry : quarkusVersionRegistries) {
            Collection<Platform> platforms;
            PlatformCatalog.Mutable platformCatalog = registry.resolvePlatformCatalog(quarkusCoreVersion);
            if (platformCatalog == null || (platforms = platformCatalog.getPlatforms()).isEmpty()) continue;
            int platformIndex = processedPlatforms.size();
            for (Platform p : platforms) {
                if (processedPlatforms.contains(p.getPlatformKey())) continue;
                this.collectPlatformExtensions(quarkusCoreVersion, catalogBuilder, registry, ++platformIndex, p);
            }
        }
    }

    private void collectPlatformExtensions(String quarkusCoreVersion, ExtensionCatalogBuilder catalogBuilder, RegistryExtensionResolver registry, int platformIndex, Platform p) throws RegistryResolutionException {
        for (PlatformStream s : p.getStreams()) {
            int releaseIndex = 0;
            for (PlatformRelease r : s.getReleases()) {
                ++releaseIndex;
                int memberIndex = 0;
                int compatibilityCode = catalogBuilder.getCompatibilityCode(r.getQuarkusCoreVersion(), r.getUpstreamQuarkusCoreVersion());
                for (ArtifactCoords bom : r.getMemberBoms()) {
                    ExtensionCatalog.Mutable catalog = registry.resolvePlatformExtensions(bom);
                    if (catalog == null) continue;
                    OriginPreference originPreference = new OriginPreference(registry.getIndex(), platformIndex, releaseIndex, ++memberIndex, compatibilityCode);
                    this.addOriginPreference(catalog, originPreference);
                    catalogBuilder.addCatalog(catalog);
                }
                String upstreamQuarkusVersion = r.getUpstreamQuarkusCoreVersion();
                if (upstreamQuarkusVersion == null) continue;
                catalogBuilder.addUpstreamQuarkusVersion(upstreamQuarkusVersion);
            }
        }
    }

    private List<RegistryExtensionResolver> getRegistriesForQuarkusVersion(String quarkusCoreVersion) {
        try {
            return this.filterRegistries(r -> r.checkQuarkusVersion(quarkusCoreVersion));
        }
        catch (ExclusiveProviderConflictException e) {
            StringBuilder buf = new StringBuilder();
            buf.append("The following registries were configured as exclusive providers of extensions based on Quarkus version ");
            buf.append(quarkusCoreVersion);
            buf.append(": ").append(e.conflictingRegistries.get(0).getId());
            for (int i = 1; i < e.conflictingRegistries.size(); ++i) {
                buf.append(", ").append(e.conflictingRegistries.get(i).getId());
            }
            throw new RuntimeException(buf.toString());
        }
    }

    private List<RegistryExtensionResolver> filterRegistries(Function<RegistryExtensionResolver, Integer> recognizer) throws ExclusiveProviderConflictException {
        RegistryExtensionResolver exclusiveProvider = null;
        List<RegistryExtensionResolver> filtered = null;
        ArrayList<RegistryExtensionResolver> conflicts = null;
        for (int i = 0; i < this.registries.size(); ++i) {
            RegistryExtensionResolver registry = this.registries.get(i);
            int versionCheck = recognizer.apply(registry);
            if (versionCheck == -1) {
                if (exclusiveProvider != null || filtered != null) continue;
                filtered = new ArrayList<RegistryExtensionResolver>(this.registries.size() - 1);
                for (int j = 0; j < i; ++j) {
                    filtered.add(this.registries.get(j));
                }
                continue;
            }
            if (versionCheck == 2) {
                if (exclusiveProvider == null) {
                    exclusiveProvider = registry;
                } else {
                    if (conflicts == null) {
                        conflicts = new ArrayList<RegistryExtensionResolver>();
                        conflicts.add(exclusiveProvider);
                    }
                    conflicts.add(registry);
                }
            }
            if (filtered == null) continue;
            filtered.add(registry);
        }
        if (conflicts != null) {
            throw new ExclusiveProviderConflictException(conflicts);
        }
        return exclusiveProvider == null ? (filtered == null ? this.registries : filtered) : Arrays.asList(exclusiveProvider);
    }

    private class ExtensionCatalogBuilder {
        private final List<ExtensionCatalog.Mutable> catalogs = new ArrayList<ExtensionCatalog.Mutable>();
        final Map<String, List<RegistryExtensionResolver>> registriesByQuarkusCore = new HashMap<String, List<RegistryExtensionResolver>>();
        private final Map<String, Integer> compatibilityCodes = new LinkedHashMap<String, Integer>();
        final List<String> upstreamQuarkusVersions = new ArrayList<String>(1);

        private ExtensionCatalogBuilder() {
        }

        void addCatalog(ExtensionCatalog.Mutable c) {
            this.catalogs.add(c);
        }

        void addUpstreamQuarkusVersion(String quarkusVersion) {
            if (!this.upstreamQuarkusVersions.contains(quarkusVersion)) {
                this.upstreamQuarkusVersions.add(quarkusVersion);
            }
        }

        List<RegistryExtensionResolver> getRegistriesForQuarkusCore(String quarkusVersion) {
            return this.registriesByQuarkusCore.computeIfAbsent(quarkusVersion, v -> ExtensionCatalogResolver.this.getRegistriesForQuarkusVersion((String)v));
        }

        public int getCompatibilityCode(String quarkusVersion) {
            return this.getCompatibilityCode(quarkusVersion, null);
        }

        public int getCompatibilityCode(String quarkusVersion, String upstreamQuarkusVersion) {
            Integer i = this.compatibilityCodes.get(quarkusVersion);
            if (i == null) {
                if (upstreamQuarkusVersion != null) {
                    i = this.compatibilityCodes.get(upstreamQuarkusVersion);
                    if (i == null) {
                        i = this.compatibilityCodes.size();
                        this.compatibilityCodes.put(upstreamQuarkusVersion, i);
                    }
                } else {
                    i = this.compatibilityCodes.size();
                }
                this.compatibilityCodes.put(quarkusVersion, i);
            }
            return i;
        }

        void appendAllNonPlatformExtensions() throws RegistryResolutionException {
            for (String quarkusVersion : this.compatibilityCodes.keySet()) {
                ExtensionCatalogResolver.this.appendNonPlatformExtensions(this, quarkusVersion);
            }
        }

        ExtensionCatalog build() throws RegistryResolutionException {
            this.appendAllNonPlatformExtensions();
            if (this.catalogs.isEmpty()) {
                List<RegistryExtensionResolver> registries = ExtensionCatalogResolver.this.registries;
                if (registries.isEmpty()) {
                    throw new RegistryResolutionException("Quarkus extension registry is not available");
                }
                if (registries.size() == 1) {
                    throw new RegistryResolutionException("Quarkus extension registry " + registries.get(0).getId() + " did not provide any extension catalog");
                }
                StringBuilder buf = new StringBuilder();
                buf.append("Quarkus extension registries ");
                buf.append(registries.get(0).getId());
                for (int i = 1; i < registries.size(); ++i) {
                    buf.append(", ").append(registries.get(i).getId());
                }
                buf.append(" did not provide any extension catalog");
                throw new RegistryResolutionException(buf.toString());
            }
            return CatalogMergeUtility.merge(this.catalogs);
        }
    }

    public class Builder {
        private MavenArtifactResolver artifactResolver;
        private boolean built;
        private RegistryClientFactory defaultClientFactory;
        private RegistryClientEnvironment clientEnv;

        private Builder() {
        }

        public Builder artifactResolver(MavenArtifactResolver resolver) {
            this.assertNotBuilt();
            this.artifactResolver = resolver;
            return this;
        }

        public Builder messageWriter(MessageWriter messageWriter) {
            this.assertNotBuilt();
            ExtensionCatalogResolver.this.log = messageWriter;
            return this;
        }

        public Builder config(RegistriesConfig registriesConfig) {
            this.assertNotBuilt();
            ExtensionCatalogResolver.this.config = registriesConfig;
            return this;
        }

        public ExtensionCatalogResolver build() throws RegistryResolutionException {
            this.assertNotBuilt();
            this.built = true;
            this.completeConfig();
            this.buildRegistryClients();
            return ExtensionCatalogResolver.this;
        }

        private void completeConfig() {
            if (ExtensionCatalogResolver.this.config == null) {
                ExtensionCatalogResolver.this.config = RegistriesConfigLocator.resolveConfig();
            }
            if (ExtensionCatalogResolver.this.log == null) {
                MessageWriter messageWriter = ExtensionCatalogResolver.this.log = ExtensionCatalogResolver.this.config.isDebug() ? MessageWriter.debug() : MessageWriter.info();
            }
            if (this.artifactResolver == null) {
                try {
                    this.artifactResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setWorkspaceDiscovery(false)).setArtifactTransferLogging(ExtensionCatalogResolver.this.config.isDebug())).build();
                }
                catch (BootstrapMavenException e) {
                    throw new IllegalStateException("Failed to intialize the default Maven artifact resolver", e);
                }
            }
        }

        private void buildRegistryClients() throws RegistryResolutionException {
            ExtensionCatalogResolver.this.registries = new ArrayList<RegistryExtensionResolver>(ExtensionCatalogResolver.this.config.getRegistries().size());
            for (RegistryConfig config : ExtensionCatalogResolver.this.config.getRegistries()) {
                if (!config.isEnabled()) continue;
                RegistryClientFactory clientFactory = this.getClientFactory(config);
                ExtensionCatalogResolver.this.registries.add(new RegistryExtensionResolver(clientFactory.buildRegistryClient(config), ExtensionCatalogResolver.this.log, ExtensionCatalogResolver.this.registries.size()));
            }
        }

        private RegistryClientFactory getClientFactory(RegistryConfig config) {
            if (config.getExtra().isEmpty()) {
                return this.getDefaultClientFactory();
            }
            Object provider = config.getExtra().get("client-factory-artifact");
            if (provider != null) {
                return this.loadFromArtifact(config, provider);
            }
            provider = config.getExtra().get("client-factory-url");
            if (provider != null) {
                URL url;
                try {
                    url = new URL((String)provider);
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Failed to translate " + provider + " to URL", e);
                }
                return this.loadFromUrl(url);
            }
            return this.getDefaultClientFactory();
        }

        public RegistryClientFactory loadFromArtifact(RegistryConfig config, Object providerValue) {
            URL url;
            File providerJar;
            ArtifactCoords providerArtifact;
            try {
                String providerStr = (String)providerValue;
                providerArtifact = ArtifactCoords.fromString((String)providerStr);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to process configuration of " + config.getId() + " registry: failed to cast " + providerValue + " to String", e);
            }
            try {
                providerJar = this.artifactResolver.resolve((Artifact)new DefaultArtifact(providerArtifact.getGroupId(), providerArtifact.getArtifactId(), providerArtifact.getClassifier(), providerArtifact.getType(), providerArtifact.getVersion())).getArtifact().getFile();
            }
            catch (BootstrapMavenException e) {
                throw new IllegalStateException("Failed to resolve the registry client factory provider artifact " + providerArtifact, e);
            }
            ExtensionCatalogResolver.this.log.debug("Loading registry client factory for %s from %s", new Object[]{config.getId(), providerArtifact});
            try {
                url = providerJar.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to translate " + providerJar + " to URL", e);
            }
            return this.loadFromUrl(url);
        }

        private RegistryClientFactory loadFromUrl(URL url) {
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                URLClassLoader providerCl = new URLClassLoader(new URL[]{url}, originalCl);
                Iterator<RegistryClientFactoryProvider> i = ServiceLoader.load(RegistryClientFactoryProvider.class, providerCl).iterator();
                if (!i.hasNext()) {
                    throw new Exception("Failed to locate an implementation of " + RegistryClientFactoryProvider.class.getName() + " service provider");
                }
                RegistryClientFactoryProvider provider = i.next();
                if (i.hasNext()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Found more than one registry client factory provider ").append(provider.getClass().getName());
                    while (i.hasNext()) {
                        buf.append(", ").append(i.next().getClass().getName());
                    }
                    throw new Exception(buf.toString());
                }
                RegistryClientFactory registryClientFactory = provider.newRegistryClientFactory(this.getClientEnv());
                return registryClientFactory;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load registry client factory from " + url, e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }

        private RegistryClientFactory getDefaultClientFactory() {
            return this.defaultClientFactory == null ? (this.defaultClientFactory = new MavenRegistryClientFactory(this.artifactResolver, ExtensionCatalogResolver.this.log)) : this.defaultClientFactory;
        }

        private RegistryClientEnvironment getClientEnv() {
            return this.clientEnv == null ? (this.clientEnv = new RegistryClientEnvironment(){

                @Override
                public MessageWriter log() {
                    return ExtensionCatalogResolver.this.log;
                }

                @Override
                public MavenArtifactResolver resolver() {
                    return Builder.this.artifactResolver;
                }
            }) : this.clientEnv;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("The builder has already built an instance");
            }
        }
    }
}

