/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.client.RegistryCache;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import io.quarkus.registry.config.RegistryConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class MavenRegistryCache
implements RegistryCache {
    private final RegistryConfig config;
    private final Collection<ArtifactCoords> artifacts;
    private final MavenRegistryArtifactResolver resolver;
    private final MessageWriter log;

    public MavenRegistryCache(RegistryConfig config, MavenRegistryArtifactResolver resolver, MessageWriter log) {
        this.config = config;
        ArrayList<ArtifactCoords> artifacts = new ArrayList<ArtifactCoords>(3);
        artifacts.add(config.getDescriptor().getArtifact());
        if (config.getNonPlatformExtensions() != null) {
            artifacts.add(config.getNonPlatformExtensions().getArtifact());
        }
        if (config.getPlatforms() != null) {
            artifacts.add(config.getPlatforms().getArtifact());
        }
        this.artifacts = artifacts;
        this.resolver = Objects.requireNonNull(resolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public void clearCache() throws RegistryResolutionException {
        this.log.debug("%s clearCache", new Object[]{this.config.getId()});
        for (ArtifactCoords coords : this.artifacts) {
            Path dir;
            try {
                dir = this.resolver.findArtifactDirectory((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()));
            }
            catch (BootstrapMavenException e) {
                throw new RegistryResolutionException("Failed to resolve " + String.valueOf(coords) + " locally", e);
            }
            if (!Files.exists(dir, new LinkOption[0])) continue;
            try {
                Stream<Path> dirPaths = Files.list(dir);
                try {
                    dirPaths.forEach(path -> {
                        try {
                            Files.delete(path);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
                finally {
                    if (dirPaths == null) continue;
                    dirPaths.close();
                }
            }
            catch (IOException e) {
                throw new RegistryResolutionException("Failed to read directory " + String.valueOf(dir), e);
            }
        }
    }
}

