/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalogImpl;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.ExtensionOriginImpl;
import io.quarkus.registry.json.JsonBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ExtensionImpl
implements Extension {
    private final String name;
    private final String description;
    private final Map<String, Object> metadata;
    private final ArtifactCoords artifact;
    private final List<ExtensionOrigin> origins;

    private ExtensionImpl(Builder builder, List<ExtensionOrigin> origins) {
        this.name = builder.getName();
        this.description = builder.getDescription();
        this.artifact = builder.getArtifact();
        this.origins = origins;
        this.metadata = JsonBuilder.toUnmodifiableMap(builder.metadata);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ArtifactCoords getArtifact() {
        return this.artifact;
    }

    @Override
    @JsonIdentityReference(alwaysAsId=true)
    @JsonSerialize(contentAs=ExtensionOriginImpl.class)
    public List<ExtensionOrigin> getOrigins() {
        return this.origins;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        return ExtensionImpl.extensionEquals(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.getArtifact());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{artifact=" + String.valueOf(this.getArtifact()) + "}";
    }

    static boolean extensionEquals(Extension o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (!(o2 instanceof Extension)) {
            return false;
        }
        Extension extension = (Extension)o2;
        return Objects.equals(o1.getArtifact(), extension.getArtifact());
    }

    public static class Builder
    implements Extension.Mutable {
        private String name;
        private String description;
        private Map<String, Object> metadata;
        private ArtifactCoords artifact;
        private List<ExtensionOrigin> origins;
        private String groupId;
        private String artifactId;
        private String version;

        Builder() {
        }

        @JsonIgnore
        Builder(Extension e) {
            this.artifact = e.getArtifact();
            this.name = e.getName();
            this.description = e.getDescription();
            this.origins = JsonBuilder.modifiableListOrNull(e.getOrigins());
            this.setMetadata((Map)e.getMetadata());
        }

        @Override
        public Builder setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public Builder setArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Override
        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ArtifactCoords getArtifact() {
            if (this.artifact == null && this.artifactId != null) {
                this.artifact = ArtifactCoords.jar((String)this.groupId, (String)this.artifactId, (String)this.version);
            }
            return this.artifact;
        }

        @Override
        public Builder setArtifact(ArtifactCoords coords) {
            this.artifact = coords;
            return this;
        }

        @Override
        @JsonIdentityReference(alwaysAsId=true)
        public List<ExtensionOrigin> getOrigins() {
            return this.origins == null ? (this.origins = new ArrayList<ExtensionOrigin>()) : this.origins;
        }

        @Override
        @JsonDeserialize(contentAs=ExtensionOriginImpl.Builder.class)
        @JsonIdentityReference(alwaysAsId=true)
        public Builder setOrigins(List<ExtensionOrigin> origins) {
            this.origins = JsonBuilder.modifiableListOrNull(origins);
            return this;
        }

        @Override
        public Map<String, Object> getMetadata() {
            return this.metadata == null ? (this.metadata = new HashMap<String, Object>()) : this.metadata;
        }

        @Override
        public Builder setMetadata(Map<String, Object> newValues) {
            this.metadata = JsonBuilder.modifiableMapOrNull(newValues, HashMap::new);
            return this;
        }

        @Override
        @JsonIgnore
        public Builder setMetadata(String key, Object value) {
            this.getMetadata().put(key, value);
            return this;
        }

        @Override
        public Builder removeMetadata(String key) {
            this.getMetadata().remove(key);
            return this;
        }

        @Override
        public void persist(Path p) throws IOException {
            this.build().persist(p);
        }

        @Override
        public ExtensionImpl build() {
            List<ExtensionOrigin> built = this.origins == null || this.origins.isEmpty() ? Collections.emptyList() : this.origins.stream().map(x -> this.buildOrigin((ExtensionOrigin)x)).collect(Collectors.toUnmodifiableList());
            return new ExtensionImpl(this, built);
        }

        public ExtensionOrigin buildOrigin(ExtensionOrigin x) {
            if (x instanceof ExtensionCatalogImpl.Builder) {
                return ExtensionOrigin.builder().setBom(x.getBom()).setId(x.getId()).setPlatform(x.isPlatform()).setMetadata(x.getMetadata()).build();
            }
            return JsonBuilder.buildIfBuilder(x);
        }

        public boolean equals(Object o) {
            return ExtensionImpl.extensionEquals(this, o);
        }

        public int hashCode() {
            return Objects.hash(this.getArtifact());
        }
    }
}

