/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.TestInfo;

public class SnapshotTesting {
    public static final Path SNAPSHOTS_DIR = Paths.get("src/test/resources/__snapshots__/", new String[0]);
    public static final String UPDATE_SNAPSHOTS_PROPERTY = "update-snapshots";
    public static final String UPDATE_SNAPSHOTS_PROPERTY_SHORTCUT = "snap";

    public static AbstractPathAssert<?> assertThatMatchSnapshot(TestInfo testInfo, Path parentDir, String fileRelativePath) throws Throwable {
        String snapshotDirName = SnapshotTesting.getSnapshotDirName(testInfo);
        String normalizedFileName = snapshotDirName + "/" + SnapshotTesting.normalizePathAsName(fileRelativePath);
        return SnapshotTesting.assertThatMatchSnapshot(parentDir.resolve(fileRelativePath), normalizedFileName);
    }

    public static AbstractPathAssert<?> assertThatMatchSnapshot(Path fileToCheck, String snapshotIdentifier) throws Throwable {
        Path snapshotFile = SNAPSHOTS_DIR.resolve(snapshotIdentifier);
        Assertions.assertThat((Path)fileToCheck).isRegularFile();
        boolean updateSnapshot = SnapshotTesting.shouldUpdateSnapshot(snapshotIdentifier);
        if (updateSnapshot) {
            if (Files.isRegularFile(snapshotFile, new LinkOption[0])) {
                SnapshotTesting.deleteExistingSnapshots(snapshotIdentifier, snapshotFile);
            }
            FileUtils.copyFile((File)fileToCheck.toFile(), (File)snapshotFile.toFile());
        }
        String snapshotNotFoundDescription = "corresponding snapshot not found for " + snapshotIdentifier + " (Use -Dsnap to create it automatically)";
        String description = "Snapshot is not matching (use -Dsnap to udpate it automatically): " + snapshotIdentifier;
        if (SnapshotTesting.isUTF8File(fileToCheck)) {
            ((AbstractPathAssert)Assertions.assertThat((Path)snapshotFile).as(snapshotNotFoundDescription, new Object[0])).isRegularFile();
            ((AbstractPathAssert)Assertions.assertThat((Path)fileToCheck).as(description, new Object[0])).exists().usingCharset(StandardCharsets.UTF_8).hasSameTextualContentAs(snapshotFile, StandardCharsets.UTF_8);
        } else {
            ((AbstractPathAssert)Assertions.assertThat((Path)snapshotFile).as(snapshotNotFoundDescription, new Object[0])).isRegularFile();
            ((AbstractPathAssert)Assertions.assertThat((Path)fileToCheck).as(description, new Object[0])).hasSameBinaryContentAs(snapshotFile);
        }
        return Assertions.assertThat((Path)fileToCheck);
    }

    public static ListAssert<String> assertThatDirectoryTreeMatchSnapshots(TestInfo testInfo, Path dir) throws Throwable {
        return SnapshotTesting.assertThatDirectoryTreeMatchSnapshots(SnapshotTesting.getSnapshotDirName(testInfo), dir);
    }

    public static ListAssert<String> assertThatDirectoryTreeMatchSnapshots(String snapshotDirName, Path dir) throws Throwable {
        String snapshotName = snapshotDirName + "/dir-tree.snapshot";
        Path snapshotFile = SNAPSHOTS_DIR.resolve(snapshotName);
        Assertions.assertThat((Path)dir).isDirectory();
        List tree = Files.walk(dir, new FileVisitOption[0]).map(p -> {
            String r = dir.relativize((Path)p).toString().replace('\\', '/');
            if (Files.isDirectory(p, new LinkOption[0])) {
                return r + "/";
            }
            return r;
        }).sorted().collect(Collectors.toList());
        boolean updateSnapshot = SnapshotTesting.shouldUpdateSnapshot(snapshotName);
        if (updateSnapshot) {
            if (Files.isRegularFile(snapshotFile, new LinkOption[0])) {
                SnapshotTesting.deleteExistingSnapshots(snapshotName, snapshotFile);
            }
            Files.createDirectories(snapshotFile.getParent(), new FileAttribute[0]);
            Files.write(snapshotFile, String.join((CharSequence)"\n", tree).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        ((AbstractPathAssert)Assertions.assertThat((Path)snapshotFile).as("corresponding snapshot not found for " + snapshotName + " (Use -Dsnap to create it automatically)", new Object[0])).isRegularFile();
        List content = Arrays.stream(SnapshotTesting.getTextContent(snapshotFile).split("\\v")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return (ListAssert)((ListAssert)Assertions.assertThat(tree).as("Snapshot is not matching (use -Dsnap to udpate it automatically):" + snapshotName, new Object[0])).containsExactlyInAnyOrderElementsOf(content);
    }

    public static String getTextContent(Path file) {
        try {
            return new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + file.toString(), e);
        }
    }

    public static void deleteTestDirectory(File file) throws IOException {
        FileUtils.deleteDirectory((File)file);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(file.toPath(), new LinkOption[0]), (String)"Directory still exists");
    }

    public static Consumer<Path> checkContains(String s) {
        return p -> Assertions.assertThat((String)SnapshotTesting.getTextContent(p)).contains(new CharSequence[]{s});
    }

    public static Consumer<Path> checkMatches(String regex) {
        return p -> Assertions.assertThat((String)SnapshotTesting.getTextContent(p)).matches((CharSequence)regex);
    }

    public static String getSnapshotDirName(TestInfo testInfo) {
        return ((Class)testInfo.getTestClass().get()).getSimpleName() + "/" + ((Method)testInfo.getTestMethod().get()).getName();
    }

    public static String normalizePathAsName(String fileRelativePath) {
        return fileRelativePath.replace("/", "_");
    }

    private static boolean shouldUpdateSnapshot(String identifier) {
        return SnapshotTesting.getUpdateSnapshotsProp().filter(u -> u.isEmpty() || "true".equalsIgnoreCase((String)u) || u.contains(identifier)).isPresent();
    }

    private static boolean isUTF8File(Path file) {
        try {
            byte[] inputBytes = Files.readAllBytes(file);
            String converted = new String(inputBytes, StandardCharsets.UTF_8);
            byte[] outputBytes = converted.getBytes(StandardCharsets.UTF_8);
            return Arrays.equals(inputBytes, outputBytes);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void deleteExistingSnapshots(String name, Path snapshots) {
        System.out.println("\n>>>>>> DELETING EXISTING TEST SNAPSHOTS FOR:\n>>>>>> " + name + "\n");
        FileUtils.deleteQuietly((File)snapshots.toFile());
    }

    static Optional<String> getUpdateSnapshotsProp() {
        Optional<String> property = Optional.ofNullable(System.getProperty(UPDATE_SNAPSHOTS_PROPERTY, System.getenv(UPDATE_SNAPSHOTS_PROPERTY)));
        if (property.isPresent()) {
            return property;
        }
        return Optional.ofNullable(System.getProperty(UPDATE_SNAPSHOTS_PROPERTY_SHORTCUT, System.getenv(UPDATE_SNAPSHOTS_PROPERTY_SHORTCUT)));
    }
}

