/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing.codestarts;

import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.DataKey;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.testing.RegistryClientTestHelper;
import io.quarkus.devtools.testing.SnapshotTesting;
import io.quarkus.devtools.testing.WrapperRunner;
import io.quarkus.devtools.testing.codestarts.QuarkusCodestartTestBuilder;
import io.quarkus.devtools.testing.codestarts.QuarkusCodestartTesting;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class QuarkusCodestartTest
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final String DEFAULT_PACKAGE_DIR = "org.acme";
    public static final String DEFAULT_PACKAGE_FOR_TESTING = "ilove.quark.us";
    private final Set<String> codestarts;
    private final Set<QuarkusCodestartCatalog.Language> languages;
    private final Map<String, Object> data;
    private final AtomicReference<ExtensionContext> currentTestContext = new AtomicReference();
    private final BuildTool buildTool;
    private final Set<QuarkusCodestartCatalog.Language> hasGeneratedProjectsWithMockedData = new HashSet<QuarkusCodestartCatalog.Language>();
    private final Set<QuarkusCodestartCatalog.Language> hasGeneratedProjectsWithRealData = new HashSet<QuarkusCodestartCatalog.Language>();
    private final boolean enableRegistryClient;
    private final Collection<String> artifacts;
    private final Collection<ArtifactCoords> extensions;
    private Path targetDir;
    private ExtensionCatalog extensionCatalog;
    private QuarkusCodestartCatalog quarkusCodestartCatalog;

    QuarkusCodestartTest(QuarkusCodestartTestBuilder builder) {
        this.codestarts = builder.codestarts;
        this.languages = builder.languages;
        this.buildTool = builder.buildTool;
        this.quarkusCodestartCatalog = builder.quarkusCodestartCatalog;
        this.extensionCatalog = builder.extensionCatalog;
        this.enableRegistryClient = builder.extensionCatalog == null;
        this.data = builder.data;
        this.artifacts = builder.artifacts;
        this.extensions = builder.extensions;
    }

    public static QuarkusCodestartTestBuilder builder() {
        return new QuarkusCodestartTestBuilder();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        if (this.enableRegistryClient) {
            RegistryClientTestHelper.enableRegistryClientTestConfig();
        }
        this.targetDir = Paths.get("target/quarkus-codestart-test/" + this.getTestId(), new String[0]);
        SnapshotTesting.deleteTestDirectory(this.targetDir.toFile());
    }

    private String getTestId() {
        String tool = this.buildTool != null ? this.buildTool.getKey() + "-" : "";
        return tool + String.join((CharSequence)"-", this.codestarts);
    }

    public QuarkusCodestartCatalog getQuarkusCodestartCatalog() throws IOException {
        return this.quarkusCodestartCatalog == null ? (this.quarkusCodestartCatalog = QuarkusCodestartCatalog.fromExtensionsCatalog((ExtensionCatalog)this.getExtensionsCatalog(), this.getCodestartsResourceLoaders())) : this.quarkusCodestartCatalog;
    }

    public ExtensionCatalog getExtensionsCatalog() {
        if (this.extensionCatalog == null) {
            try {
                this.extensionCatalog = QuarkusProjectHelper.getCatalogResolver().resolveExtensionCatalog();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve extensions catalog", e);
            }
        }
        return this.extensionCatalog;
    }

    private void generateRealDataProjectIfNeeded(Path path, QuarkusCodestartCatalog.Language language) throws IOException {
        if (!this.hasGeneratedProjectsWithRealData.contains(language)) {
            this.generateProject(path, language, QuarkusCodestartTesting.getRealTestInputData(this.getExtensionsCatalog(), Collections.emptyMap()));
        }
        this.hasGeneratedProjectsWithRealData.add(language);
    }

    private void generateMockedDataProjectIfNeeded(Path path, QuarkusCodestartCatalog.Language language) throws IOException {
        if (!this.hasGeneratedProjectsWithMockedData.contains(language)) {
            this.generateProject(path, language, QuarkusCodestartTesting.getMockedTestInputData(Collections.emptyMap()));
        }
        this.hasGeneratedProjectsWithMockedData.add(language);
    }

    public void buildAllProjects() throws IOException {
        for (QuarkusCodestartCatalog.Language language : this.languages) {
            this.buildProject(language);
        }
    }

    public void buildProject(QuarkusCodestartCatalog.Language language) throws IOException {
        int exitCode = WrapperRunner.run(this.getProjectWithRealDataDir(language));
        ((AbstractIntegerAssert)Assertions.assertThat((int)exitCode).as("Run project return status is zero", new Object[0])).isZero();
    }

    public void checkGeneratedSource(String className) throws Throwable {
        for (QuarkusCodestartCatalog.Language language : this.languages) {
            this.checkGeneratedSource(language, className);
        }
    }

    public AbstractPathAssert<?> assertThatGeneratedFile(QuarkusCodestartCatalog.Language language, String fileRelativePat) throws Throwable {
        return Assertions.assertThat((Path)this.getProjectWithMockedDataDir(language).resolve(fileRelativePat));
    }

    public void checkGeneratedTestSource(String className) throws Throwable {
        for (QuarkusCodestartCatalog.Language language : this.languages) {
            this.checkGeneratedTestSource(language, className);
        }
    }

    public AbstractPathAssert<?> checkGeneratedSource(QuarkusCodestartCatalog.Language language, String className) throws Throwable {
        return this.checkGeneratedSource("main", language, className);
    }

    public AbstractPathAssert<?> checkGeneratedTestSource(QuarkusCodestartCatalog.Language language, String className) throws Throwable {
        return this.checkGeneratedSource("test", language, className);
    }

    public AbstractPathAssert<?> checkGeneratedSource(String sourceDir, QuarkusCodestartCatalog.Language language, String className) throws Throwable {
        String modifiedClassName = className.replace(DEFAULT_PACKAGE_DIR, DEFAULT_PACKAGE_FOR_TESTING).replace(".", "/");
        String fileRelativePath = "src/" + sourceDir + "/" + language.key() + "/" + modifiedClassName + this.getSourceFileExtension(language);
        return (AbstractPathAssert)this.assertThatGeneratedFileMatchSnapshot(language, fileRelativePath).satisfies(SnapshotTesting.checkContains("package ilove.quark.us"));
    }

    public AbstractPathAssert<?> assertThatGeneratedFileMatchSnapshot(QuarkusCodestartCatalog.Language language, String fileRelativePath) throws Throwable {
        ExtensionContext context = Objects.requireNonNull(this.currentTestContext.get(), "Context must be present");
        String snapshotDirName = ((Class)context.getTestClass().get()).getSimpleName() + "/" + ((Method)context.getTestMethod().get()).getName();
        String normalizedFileName = snapshotDirName + "/" + SnapshotTesting.normalizePathAsName(fileRelativePath);
        return SnapshotTesting.assertThatMatchSnapshot(this.getProjectWithMockedDataDir(language).resolve(fileRelativePath), normalizedFileName);
    }

    public ListAssert<String> assertThatGeneratedTreeMatchSnapshots(QuarkusCodestartCatalog.Language language) throws Throwable {
        return this.assertThatGeneratedTreeMatchSnapshots(language, null);
    }

    public ListAssert<String> assertThatGeneratedTreeMatchSnapshots(QuarkusCodestartCatalog.Language language, String dirRelativePath) throws Throwable {
        ExtensionContext context = Objects.requireNonNull(this.currentTestContext.get(), "Context must be present");
        String snapshotDirName = ((Class)context.getTestClass().get()).getSimpleName() + "/" + ((Method)context.getTestMethod().get()).getName();
        Path dir = dirRelativePath != null ? this.getProjectWithMockedDataDir(language).resolve(dirRelativePath) : this.getProjectWithMockedDataDir(language);
        return SnapshotTesting.assertThatDirectoryTreeMatchSnapshots(snapshotDirName, dir);
    }

    private void generateProject(Path projectDir, QuarkusCodestartCatalog.Language language, Map<String, Object> inputData) throws IOException {
        QuarkusCodestartProjectInput input = QuarkusCodestartProjectInput.builder().addCodestart(language.key()).buildTool(this.buildTool).addCodestarts(this.codestarts).addData(inputData).addData(this.data).addBoms(QuarkusCodestartTesting.getBoms(inputData)).addExtensions(this.extensions).putData((DataKey)QuarkusCodestartData.QuarkusDataKey.PROJECT_PACKAGE_NAME, (Object)DEFAULT_PACKAGE_FOR_TESTING).build();
        this.getQuarkusCodestartCatalog().createProject((CodestartProjectInput)input).generate(projectDir);
    }

    private Path getProjectWithRealDataDir(QuarkusCodestartCatalog.Language language) throws IOException {
        Path dir = this.targetDir.resolve("real-data").resolve(language.key());
        this.generateRealDataProjectIfNeeded(dir, language);
        return dir;
    }

    private Path getProjectWithMockedDataDir(QuarkusCodestartCatalog.Language language) throws IOException {
        Path dir = this.targetDir.resolve("mocked-data").resolve(language.key());
        this.generateMockedDataProjectIfNeeded(dir, language);
        return dir;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (this.enableRegistryClient) {
            RegistryClientTestHelper.disableRegistryClientTestConfig();
        }
    }

    protected List<ResourceLoader> getCodestartsResourceLoaders() {
        return CodestartResourceLoadersBuilder.codestartLoadersBuilder().catalog(this.getExtensionsCatalog()).addExtraCodestartsArtifactCoords(this.artifacts).build();
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.currentTestContext.set(null);
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.currentTestContext.set(extensionContext);
    }

    private String getSourceFileExtension(QuarkusCodestartCatalog.Language language) {
        return QuarkusCodestartCatalog.Language.KOTLIN.equals((Object)language) ? ".kt" : "." + language.key();
    }
}

