/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing.codestarts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.quarkus.devtools.codestarts.DataKey;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.devtools.testing.codestarts.QuarkusCodestartTest;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonCatalogMapperHelper;
import io.quarkus.registry.catalog.json.JsonExtension;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class QuarkusCodestartTestBuilder {
    public Map<String, Object> data = new HashMap<String, Object>();
    public Collection<String> artifacts = new ArrayList<String>();
    BuildTool buildTool;
    Set<String> codestarts = new HashSet<String>();
    Set<QuarkusCodestartCatalog.Language> languages;
    QuarkusCodestartCatalog quarkusCodestartCatalog;
    ExtensionCatalog extensionCatalog;
    Collection<ArtifactCoords> extensions = new ArrayList<ArtifactCoords>();

    public QuarkusCodestartTestBuilder codestarts(String ... codestarts) {
        this.codestarts = new HashSet<String>(Arrays.asList(codestarts));
        return this;
    }

    public QuarkusCodestartTestBuilder languages(QuarkusCodestartCatalog.Language ... languages) {
        this.languages = new HashSet<QuarkusCodestartCatalog.Language>(Arrays.asList(languages));
        return this;
    }

    public QuarkusCodestartTestBuilder buildTool(BuildTool buildTool) {
        this.buildTool = buildTool;
        return this;
    }

    public QuarkusCodestartTestBuilder putData(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public QuarkusCodestartTestBuilder putData(DataKey key, Object value) {
        this.data.put(key.key(), value);
        return this;
    }

    public QuarkusCodestartTestBuilder extensions(Collection<ArtifactCoords> extensions) {
        this.extensions.addAll(extensions);
        return this;
    }

    public QuarkusCodestartTestBuilder extension(ArtifactCoords extension) {
        this.extensions.add(extension);
        return this;
    }

    public QuarkusCodestartTestBuilder extension(ArtifactKey extension) {
        this.extensions.add(Extensions.toCoords((ArtifactKey)extension, null));
        return this;
    }

    public QuarkusCodestartTestBuilder addArtifacts(Collection<String> artifacts) {
        this.artifacts = artifacts;
        return this;
    }

    public QuarkusCodestartTestBuilder quarkusCodestartCatalog(QuarkusCodestartCatalog quarkusCodestartCatalog) {
        this.quarkusCodestartCatalog = quarkusCodestartCatalog;
        return this;
    }

    public QuarkusCodestartTestBuilder extensionCatalog(ExtensionCatalog extensionCatalog) {
        this.extensionCatalog = extensionCatalog;
        return this;
    }

    public QuarkusCodestartTestBuilder standaloneExtensionCatalog() {
        try {
            String quarkusVersion = null;
            ArrayList<JsonExtension> extensions = new ArrayList<JsonExtension>();
            for (URL url : Collections.list(Thread.currentThread().getContextClassLoader().getResources("META-INF/quarkus-extension.yaml"))) {
                ObjectMapper mapper = JsonCatalogMapperHelper.initMapper((ObjectMapper)new YAMLMapper());
                JsonExtension extension = (JsonExtension)ResourceLoaders.processAsPath((URL)url, path -> {
                    try {
                        return (JsonExtension)JsonCatalogMapperHelper.deserialize((ObjectMapper)mapper, (Path)path, JsonExtension.class);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                extensions.add(extension);
                if (quarkusVersion != null) continue;
                quarkusVersion = ExtensionProcessor.getBuiltWithQuarkusCore((Extension)extension);
            }
            Objects.requireNonNull(quarkusVersion, "quarkus version not found in extensions");
            ExtensionCatalog extensionCatalog = QuarkusProjectHelper.getExtensionCatalog(quarkusVersion);
            if (!(extensionCatalog instanceof JsonExtensionCatalog)) {
                throw new IllegalStateException("Problem with the given ExtensionCatalog type");
            }
            extensions.addAll(extensionCatalog.getExtensions());
            ((JsonExtensionCatalog)extensionCatalog).setExtensions(extensions);
            this.extensionCatalog = extensionCatalog;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while reading standalone extension catalog", e);
        }
        return this;
    }

    public QuarkusCodestartTest build() {
        return new QuarkusCodestartTest(this);
    }
}

