/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing;

import io.quarkus.paths.MultiRootPathTree;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.TestInfo;

public class SnapshotTesting {
    private static volatile PathTree snapshotsBaseRoot;
    private static final String SNAPSHOTS_DIR_NAME = "__snapshots__";
    public static final Path SNAPSHOTS_DIR;
    public static final String UPDATE_SNAPSHOTS_PROPERTY = "update-snapshots";
    public static final String UPDATE_SNAPSHOTS_PROPERTY_SHORTCUT = "snap";

    public static PathTree getSnapshotsBaseTree() {
        if (snapshotsBaseRoot != null) {
            return snapshotsBaseRoot;
        }
        PathTree srcTree = null;
        if (Files.isDirectory(SNAPSHOTS_DIR, new LinkOption[0])) {
            srcTree = PathTree.ofDirectoryOrArchive((Path)SNAPSHOTS_DIR.getParent());
        } else if (SnapshotTesting.shouldUpdateSnapshot(SNAPSHOTS_DIR_NAME)) {
            try {
                Files.createDirectories(SNAPSHOTS_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            srcTree = PathTree.ofDirectoryOrArchive((Path)SNAPSHOTS_DIR.getParent());
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(SNAPSHOTS_DIR_NAME);
        if (url == null) {
            if (srcTree == null) {
                org.junit.jupiter.api.Assertions.fail((String)("Failed to locate __snapshots__ directory on the classpath and " + SNAPSHOTS_DIR.toAbsolutePath() + " directory does not exist (use -Dsnap to create it automatically)"));
            }
            snapshotsBaseRoot = srcTree;
            return snapshotsBaseRoot;
        }
        if ("file".equals(url.getProtocol())) {
            Path p;
            try {
                p = Path.of(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Failed to translate " + url + " to path", e);
            }
            snapshotsBaseRoot = new MultiRootPathTree(new PathTree[]{PathTree.ofDirectoryOrArchive((Path)p.getParent()), srcTree});
            return snapshotsBaseRoot;
        }
        if ("jar".equals(url.getProtocol())) {
            String jarUrlStr = url.toExternalForm();
            String fileUrlStr = jarUrlStr.substring("jar:".length(), jarUrlStr.length() - "!/__snapshots__".length());
            Path p = Path.of(URI.create(fileUrlStr));
            snapshotsBaseRoot = new MultiRootPathTree(new PathTree[]{PathTree.ofDirectoryOrArchive((Path)p), srcTree});
            return snapshotsBaseRoot;
        }
        throw new IllegalStateException("Unexpected URL protocol in " + url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withSnapshotsDir(String relativePath, Function<Path, T> function) {
        PathTree snapshotsBaseRoot = SnapshotTesting.getSnapshotsBaseTree();
        try (OpenPathTree tree = snapshotsBaseRoot.open();){
            Path t = function.apply(tree.getPath(SNAPSHOTS_DIR_NAME).resolve(relativePath));
            return (T)t;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to open " + snapshotsBaseRoot.getRoots(), e);
        }
    }

    public static AbstractPathAssert<?> assertThatMatchSnapshot(TestInfo testInfo, Path parentDir, String fileRelativePath) throws Throwable {
        String snapshotDirName = SnapshotTesting.getSnapshotDirName(testInfo);
        String normalizedFileName = snapshotDirName + "/" + SnapshotTesting.normalizePathAsName(fileRelativePath);
        return SnapshotTesting.assertThatMatchSnapshot(parentDir.resolve(fileRelativePath), normalizedFileName);
    }

    public static AbstractPathAssert<?> assertThatMatchSnapshot(Path fileToCheck, String snapshotIdentifier) throws Throwable {
        Assertions.assertThat((Path)fileToCheck).isRegularFile();
        boolean updateSnapshot = SnapshotTesting.shouldUpdateSnapshot(snapshotIdentifier);
        return SnapshotTesting.withSnapshotsDir(snapshotIdentifier, snapshotFile -> {
            if (updateSnapshot) {
                Path srcSnapshotFile = SNAPSHOTS_DIR.resolve(snapshotIdentifier);
                if (Files.isRegularFile(srcSnapshotFile, new LinkOption[0])) {
                    SnapshotTesting.deleteExistingSnapshots(snapshotIdentifier, srcSnapshotFile);
                }
                try {
                    FileUtils.copyFile((File)fileToCheck.toFile(), (File)srcSnapshotFile.toFile());
                    System.out.println("COPIED " + fileToCheck + " -> " + srcSnapshotFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                snapshotFile = srcSnapshotFile;
            }
            String snapshotNotFoundDescription = "corresponding snapshot file not found for " + snapshotIdentifier + " (Use -Dsnap to create it automatically)";
            String description = "Snapshot is not matching (use -Dsnap to udpate it automatically): " + snapshotIdentifier;
            if (SnapshotTesting.isUTF8File(fileToCheck)) {
                ((AbstractPathAssert)Assertions.assertThat((Path)snapshotFile).as(snapshotNotFoundDescription, new Object[0])).isRegularFile();
                ((AbstractPathAssert)Assertions.assertThat((Path)fileToCheck).as(description, new Object[0])).exists().usingCharset(StandardCharsets.UTF_8).hasSameTextualContentAs(snapshotFile, StandardCharsets.UTF_8);
            } else {
                ((AbstractPathAssert)Assertions.assertThat((Path)snapshotFile).as(snapshotNotFoundDescription, new Object[0])).isRegularFile();
                ((AbstractPathAssert)Assertions.assertThat((Path)fileToCheck).as(description, new Object[0])).hasSameBinaryContentAs(snapshotFile);
            }
            return Assertions.assertThat((Path)fileToCheck);
        });
    }

    public static ListAssert<String> assertThatDirectoryTreeMatchSnapshots(TestInfo testInfo, Path dir) throws Throwable {
        return SnapshotTesting.assertThatDirectoryTreeMatchSnapshots(SnapshotTesting.getSnapshotDirName(testInfo), dir);
    }

    public static ListAssert<String> assertThatDirectoryTreeMatchSnapshots(String snapshotDirName, Path dir) throws Throwable {
        Assertions.assertThat((Path)dir).isDirectory();
        List tree = Files.walk(dir, new FileVisitOption[0]).map(p -> {
            String r = dir.relativize((Path)p).toString().replace('\\', '/');
            if (Files.isDirectory(p, new LinkOption[0])) {
                return r + "/";
            }
            return r;
        }).sorted().collect(Collectors.toList());
        String snapshotName = snapshotDirName + "/dir-tree.snapshot";
        boolean updateSnapshot = SnapshotTesting.shouldUpdateSnapshot(snapshotName);
        return SnapshotTesting.withSnapshotsDir(snapshotName, snapshotFile -> {
            try {
                if (updateSnapshot) {
                    Path srcSnapshotFile = SNAPSHOTS_DIR.resolve(snapshotName);
                    if (Files.isRegularFile(srcSnapshotFile, new LinkOption[0])) {
                        SnapshotTesting.deleteExistingSnapshots(snapshotName, srcSnapshotFile);
                    }
                    Files.createDirectories(srcSnapshotFile.getParent(), new FileAttribute[0]);
                    Files.write(srcSnapshotFile, String.join((CharSequence)"\n", tree).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    snapshotFile = srcSnapshotFile;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ((AbstractPathAssert)Assertions.assertThat((Path)snapshotFile).as("corresponding snapshot file not found for " + snapshotName + " (Use -Dsnap to create it automatically)", new Object[0])).isRegularFile();
            List content = Arrays.stream(SnapshotTesting.getTextContent(snapshotFile).split("\\v")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            return (ListAssert)((ListAssert)Assertions.assertThat((List)tree).as("Snapshot is not matching (use -Dsnap to udpate it automatically):" + snapshotName, new Object[0])).containsExactlyInAnyOrderElementsOf(content);
        });
    }

    public static String getTextContent(Path file) {
        try {
            return Files.readString(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + file.toString(), e);
        }
    }

    public static void deleteTestDirectory(File file) throws IOException {
        FileUtils.deleteDirectory((File)file);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(file.toPath(), new LinkOption[0]), (String)"Directory still exists");
    }

    public static Consumer<Path> checkContains(String s) {
        return p -> Assertions.assertThat((String)SnapshotTesting.getTextContent(p)).contains(new CharSequence[]{s});
    }

    public static Consumer<Path> checkNotContains(String s) {
        return p -> Assertions.assertThat((String)SnapshotTesting.getTextContent(p)).doesNotContainIgnoringCase(new CharSequence[]{s});
    }

    public static Consumer<Path> checkMatches(String regex) {
        return p -> Assertions.assertThat((String)SnapshotTesting.getTextContent(p)).matches((CharSequence)regex);
    }

    public static String getSnapshotDirName(TestInfo testInfo) {
        return ((Class)testInfo.getTestClass().get()).getSimpleName() + "/" + ((Method)testInfo.getTestMethod().get()).getName();
    }

    public static String normalizePathAsName(String fileRelativePath) {
        return fileRelativePath.replace('/', '_');
    }

    private static boolean shouldUpdateSnapshot(String identifier) {
        return SnapshotTesting.getUpdateSnapshotsProp().filter(u -> u.isEmpty() || "true".equalsIgnoreCase((String)u) || u.contains(identifier)).isPresent();
    }

    private static boolean isUTF8File(Path file) {
        try {
            byte[] inputBytes = Files.readAllBytes(file);
            String converted = new String(inputBytes, StandardCharsets.UTF_8);
            byte[] outputBytes = converted.getBytes(StandardCharsets.UTF_8);
            return Arrays.equals(inputBytes, outputBytes);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void deleteExistingSnapshots(String name, Path snapshots) {
        System.out.println("\n>>>>>> DELETING EXISTING TEST SNAPSHOTS FOR:\n>>>>>> " + name + "\n");
        FileUtils.deleteQuietly((File)snapshots.toFile());
    }

    static Optional<String> getUpdateSnapshotsProp() {
        Optional<String> property = Optional.ofNullable(System.getProperty(UPDATE_SNAPSHOTS_PROPERTY, System.getenv(UPDATE_SNAPSHOTS_PROPERTY)));
        if (property.isPresent()) {
            return property;
        }
        return Optional.ofNullable(System.getProperty(UPDATE_SNAPSHOTS_PROPERTY_SHORTCUT, System.getenv(UPDATE_SNAPSHOTS_PROPERTY_SHORTCUT)));
    }

    static {
        SNAPSHOTS_DIR = Path.of("src/test/resources", new String[0]).resolve(SNAPSHOTS_DIR_NAME);
    }
}

