/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.ide;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.ide.IdeRecorder;
import io.smallrye.common.process.ProcessBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class IdeProcessor {
    private static final Logger log = Logger.getLogger(IdeProcessor.class);
    private static final Map<String, String> LANG_TO_EXT = Map.of("java", "java", "kotlin", "kt");
    private static final String FILE_PROTOCOL = "file://";
    private static final String NAMESPACE = "devui-ide-interaction";

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createOpenInIDEService(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, BuildProducer<RouteBuildItem> routeProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, IdeRecorder recorder) {
        Ide ide;
        if (effectiveIdeBuildItem.isPresent() && (ide = effectiveIdeBuildItem.get().getIde()) != null) {
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route("open-in-ide/:fileName/:lang/:lineNumber").handler(recorder.openInIde()).build());
            BuildTimeActionBuildItem ideActions = new BuildTimeActionBuildItem(NAMESPACE);
            ideActions.addAction("open", map -> {
                String fileName = (String)map.get("fileName");
                String lang = (String)map.get("lang");
                String lineNumber = (String)map.get("lineNumber");
                if (fileName != null && fileName.startsWith(FILE_PROTOCOL)) {
                    fileName = fileName.substring(FILE_PROTOCOL.length());
                    return this.typicalProcessLaunch(fileName, lineNumber, ide);
                }
                if (this.isNullOrEmpty(fileName) || this.isNullOrEmpty(lang)) {
                    return false;
                }
                return this.typicalProcessLaunch(fileName, lang, lineNumber, ide);
            });
            buildTimeActionProducer.produce((BuildItem)ideActions);
        }
    }

    private boolean typicalProcessLaunch(String className, String lang, String line, Ide ide) {
        String fileName = this.toFileName(className, lang);
        if (fileName == null) {
            return false;
        }
        return this.typicalProcessLaunch(fileName, line, ide);
    }

    private boolean typicalProcessLaunch(String fileName, String line, Ide ide) {
        List args = ide.createFileOpeningArgs(fileName, line);
        return this.launchInIDE(ide, args);
    }

    private String toFileName(String className, String lang) {
        String fileName;
        Path sourceFile;
        String effectiveClassName = className;
        int dollarIndex = className.indexOf("$");
        if (dollarIndex > -1) {
            effectiveClassName = className.substring(0, dollarIndex);
        }
        if ((sourceFile = Ide.findSourceFile((String)(fileName = effectiveClassName.replace('.', File.separatorChar) + "." + LANG_TO_EXT.get(lang)))) == null) {
            return null;
        }
        return sourceFile.toAbsolutePath().toString();
    }

    protected boolean launchInIDE(Ide ide, final List<String> args) {
        final String effectiveCommand = ide.getEffectiveCommand();
        if (this.isNullOrEmpty(effectiveCommand)) {
            return false;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessBuilder.newBuilder((String)effectiveCommand).arguments(args).output().inherited().gatherOnFail(true).run();
                }
                catch (Exception e) {
                    log.error((Object)"Could not launch IDE", (Throwable)e);
                }
            }
        }, "Launch in IDE Action").start();
        return true;
    }

    private boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isBlank();
    }
}

