/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.dev.devservices.DevServiceDescriptionBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.deployment.DevUIConfig;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public class DevServicesProcessor {
    private static final String NAMESPACE = "devui-dev-services";

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    InternalPageBuildItem createDevServicesPages(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, List<DevServiceDescriptionBuildItem> devServiceDescriptions, List<DevServicesResultBuildItem> devServicesResultBuildItems, LaunchModeBuildItem launchModeBuildItem, DevUIConfig config) {
        List<DevServiceDescriptionBuildItem> otherDevServices = this.getOtherDevServices(devServicesResultBuildItems);
        InternalPageBuildItem devServicesPages = new InternalPageBuildItem("Dev Services", 40);
        devServicesPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NAMESPACE)).title("Dev services")).icon("font-awesome-solid:wand-magic-sparkles")).componentLink("qwc-dev-services.js"));
        Collection<DevServiceDescriptionBuildItem> services = this.getServices(devServiceDescriptions, otherDevServices);
        devServicesPages.addBuildTimeData("devServices", services);
        if (launchModeBuildItem.getDevModeType().isPresent() && ((DevModeType)launchModeBuildItem.getDevModeType().get()).equals((Object)DevModeType.LOCAL) && config.allowExtensionManagement()) {
            BuildTimeActionBuildItem buildTimeActions = new BuildTimeActionBuildItem(NAMESPACE);
            this.getDevServices(buildTimeActions, devServiceDescriptions, otherDevServices);
            buildTimeActionProducer.produce((BuildItem)buildTimeActions);
        }
        return devServicesPages;
    }

    private void addToMap(Map<String, DevServiceDescriptionBuildItem> m, List<DevServiceDescriptionBuildItem> list) {
        if (!list.isEmpty()) {
            for (DevServiceDescriptionBuildItem i : list) {
                if (m.containsKey(i.getName())) continue;
                m.put(i.getName(), i);
            }
        }
    }

    private List<DevServiceDescriptionBuildItem> getOtherDevServices(List<DevServicesResultBuildItem> devServicesResultBuildItems) {
        ArrayList<DevServiceDescriptionBuildItem> devServiceDescriptions = new ArrayList<DevServiceDescriptionBuildItem>();
        for (DevServicesResultBuildItem devServicesResultBuildItem : devServicesResultBuildItems) {
            if (devServicesResultBuildItem.getContainerId() != null) continue;
            devServiceDescriptions.add(new DevServiceDescriptionBuildItem(devServicesResultBuildItem.getName(), devServicesResultBuildItem.getDescription(), devServicesResultBuildItem.getConfig()));
        }
        return devServiceDescriptions;
    }

    private void getDevServices(BuildTimeActionBuildItem buildTimeActions, List<DevServiceDescriptionBuildItem> devServiceDescriptions, List<DevServiceDescriptionBuildItem> otherDevServices) {
        buildTimeActions.addAction(new Object(){}.getClass().getEnclosingMethod().getName(), ignored -> CompletableFuture.supplyAsync(() -> this.getServices(devServiceDescriptions, otherDevServices)));
    }

    private Collection<DevServiceDescriptionBuildItem> getServices(List<DevServiceDescriptionBuildItem> devServiceDescriptions, List<DevServiceDescriptionBuildItem> otherDevServices) {
        TreeMap<String, DevServiceDescriptionBuildItem> combined = new TreeMap<String, DevServiceDescriptionBuildItem>();
        this.addToMap(combined, devServiceDescriptions);
        this.addToMap(combined, otherDevServices);
        return combined.values();
    }
}

