/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.quarkus.devui.runtime.DevUIBuildTimeStaticService;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;

public class DevUIBuildTimeStaticHandler
implements Handler<RoutingContext> {
    private static final int STATUS = 200;
    private static final String OK = "OK";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String CONTENT_TYPE = "Content-Type";

    public void handle(RoutingContext event) {
        DevUIBuildTimeStaticService buildTimeStaticService = (DevUIBuildTimeStaticService)CDI.current().select(DevUIBuildTimeStaticService.class, new Annotation[0]).get();
        String normalizedPath = event.normalizedPath();
        if (normalizedPath.contains(SLASH)) {
            int si = normalizedPath.lastIndexOf(SLASH) + 1;
            String path = normalizedPath.substring(0, si);
            String fileName = normalizedPath.substring(si);
            if (path.startsWith(buildTimeStaticService.getBasePath()) && buildTimeStaticService.getUrlAndPath().containsKey(fileName)) {
                String pathOnDisk = buildTimeStaticService.getUrlAndPath().get(fileName);
                try {
                    byte[] content = Files.readAllBytes(Path.of(pathOnDisk, new String[0]));
                    event.response().setStatusCode(200).setStatusMessage(OK).putHeader(CONTENT_TYPE, this.getMimeType(fileName)).end(Buffer.buffer((byte[])content));
                }
                catch (IOException ex) {
                    event.next();
                }
            } else {
                event.next();
            }
        } else {
            event.next();
        }
    }

    private String getMimeType(String fileName) {
        int dotIndex;
        String ext;
        if (fileName.contains(DOT) && !(ext = fileName.substring(dotIndex = fileName.lastIndexOf(DOT) + 1)).isEmpty()) {
            if (ext.equalsIgnoreCase("html") || ext.equalsIgnoreCase("htm")) {
                return "text/html; charset=utf-8";
            }
            if (ext.equalsIgnoreCase("js")) {
                return "text/javascript; charset=utf-8";
            }
            if (ext.equalsIgnoreCase("css")) {
                return "text/css; charset=utf-8";
            }
            if (ext.equalsIgnoreCase("json")) {
                return "application/json";
            }
        }
        return "text/plain; charset=utf-8";
    }

    public static interface FileExtension {
        public static final String HTML = "html";
        public static final String HTM = "htm";
        public static final String JS = "js";
        public static final String JSON = "json";
        public static final String CSS = "css";
    }

    public static interface MimeType {
        public static final String HTML = "text/html; charset=utf-8";
        public static final String JS = "text/javascript; charset=utf-8";
        public static final String JSON = "application/json";
        public static final String CSS = "text/css; charset=utf-8";
        public static final String PLAIN = "text/plain; charset=utf-8";
    }
}

