/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.tree;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.tree.DefaultTreeProcessingContext;
import io.quarkus.domino.tree.DependencyTreeVisitScheduler;
import io.quarkus.domino.tree.DependencyTreeVisitor;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.artifact.Artifact;

abstract class BaseDependencyTreeProcessScheduler<E>
implements DependencyTreeVisitScheduler {
    private static final long ESTIMATE_TIME_AFTER_MS = 60000L;
    private static final int ESTIMATE_TIME_AFTER_PERCENTS = 42;
    private static final String FORMAT_BASE = "[%s/%s %.1f%%] ";
    private static final String FORMAT_SECONDS_LEFT = "[%s/%s %.1f%%, ~ %ds left] ";
    private static final String FORMAT_MINUTES_LEFT = "[%s/%s %.1f%%, ~ %dm %ds left] ";
    private static final String FORMAT_HOURS_LEFT = "[%s/%s %.1f%%, ~ %dh %dm %dsec left] ";
    protected final List<Artifact> resolutionFailures = new ArrayList<Artifact>();
    protected final DefaultTreeProcessingContext<E> ctx;
    protected final AtomicInteger counter = new AtomicInteger();
    protected final int rootsTotal;
    private long startTime = -1L;
    private long totalSecEstimate = -1L;
    private long firstEstimateStart;
    private final long[] treeTimes;
    private final AtomicInteger treeIndex = new AtomicInteger();

    BaseDependencyTreeProcessScheduler(DependencyTreeVisitor<E> processor, MessageWriter log, int rootsTotal) {
        this.ctx = new DefaultTreeProcessingContext<E>(processor, log);
        this.rootsTotal = rootsTotal;
        this.treeTimes = new long[rootsTotal];
    }

    public List<Artifact> getResolutionFailures() {
        return this.resolutionFailures;
    }

    protected String getResolvedTreeMessage(Artifact a) {
        StringBuilder sb = new StringBuilder(160);
        Formatter formatter = new Formatter(sb);
        int treeIndex = this.counter.incrementAndGet();
        double percents = (double)treeIndex * 100.0 / (double)this.rootsTotal;
        boolean estimateTime = false;
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
            estimateTime = false;
        }
        if (estimateTime && this.totalSecEstimate == -1L) {
            this.firstEstimateStart = System.currentTimeMillis();
            this.totalSecEstimate = (long)(this.rootsTotal - treeIndex) * (this.firstEstimateStart - this.startTime) / (long)(treeIndex - 1) / 1000L;
        }
        if (estimateTime) {
            long durationMs = System.currentTimeMillis() - this.startTime;
            if (durationMs > 60000L) {
                long remainingSeconds = Math.round((100.0 - percents) * (double)this.totalSecEstimate / 100.0);
                long hours = remainingSeconds / 3600L;
                long minutes = remainingSeconds % 3600L / 60L;
                long seconds = remainingSeconds % 60L;
                if (hours > 0L) {
                    formatter.format(FORMAT_HOURS_LEFT, treeIndex, this.rootsTotal, percents, hours, minutes, seconds);
                } else if (minutes > 0L) {
                    formatter.format(FORMAT_MINUTES_LEFT, treeIndex, this.rootsTotal, percents, minutes, seconds);
                } else if (seconds > 0L) {
                    formatter.format(FORMAT_SECONDS_LEFT, treeIndex, this.rootsTotal, percents, seconds);
                } else {
                    formatter.format(FORMAT_BASE, treeIndex, this.rootsTotal, percents);
                }
            } else {
                formatter.format(FORMAT_BASE, treeIndex, this.rootsTotal, percents);
            }
        } else {
            formatter.format(FORMAT_BASE, treeIndex, this.rootsTotal, percents);
        }
        sb.append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':');
        if (!a.getClassifier().isEmpty()) {
            sb.append(a.getClassifier()).append(':');
        }
        if (!"jar".equals(a.getExtension())) {
            if (a.getClassifier().isEmpty()) {
                sb.append(':');
            }
            sb.append(a.getExtension()).append(':');
        }
        return sb.append(a.getVersion()).toString();
    }
}

