/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.tree;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.domino.tree.DependencyTreeRoot;
import io.quarkus.domino.tree.NonResolvingDependencyTreeBuilder;
import io.quarkus.domino.tree.ResolvingDependencyTreeBuilder;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public abstract class DependencyTreeBuilder {
    private static final Artifact root = new DefaultArtifact("io.domino", "resolver-root", "pom", "1.0");
    protected final MavenArtifactResolver resolver;

    public static DependencyTreeBuilder resolvingTreeBuilder(MavenArtifactResolver resolver) {
        return new ResolvingDependencyTreeBuilder(resolver);
    }

    public static DependencyTreeBuilder nonResolvingTreeBuilder(MavenArtifactResolver resolver) {
        return new NonResolvingDependencyTreeBuilder(resolver);
    }

    DependencyTreeBuilder(MavenArtifactResolver resolver) {
        this.resolver = Objects.requireNonNull(resolver);
    }

    public DependencyNode buildTree(DependencyTreeRoot root) {
        DependencyNode rootNode = this.doBuildTree(root);
        if (rootNode.getChildren().size() != 1) {
            throw new RuntimeException("Expected a single child node but got " + rootNode.getChildren());
        }
        return (DependencyNode)rootNode.getChildren().get(0);
    }

    public abstract DependencyNode doBuildTree(DependencyTreeRoot var1);

    protected CollectRequest createCollectRequest(DependencyTreeRoot root) {
        return new CollectRequest().setRootArtifact(DependencyTreeBuilder.root).setDependencies(List.of(new Dependency(root.getArtifact(), "runtime", Boolean.valueOf(false), root.getExclusions()))).setManagedDependencies(root.getConstraints()).setRepositories(this.resolver.getRepositories());
    }
}

