/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.tree;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.tree.DependencyTreeBuilder;
import io.quarkus.domino.tree.DependencyTreeRoot;
import io.quarkus.domino.tree.DependencyTreeVisitScheduler;
import io.quarkus.domino.tree.DependencyTreeVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class DependencyTreeProcessor {
    private String settings;
    private List<String> profiles = List.of();
    private String repoDir;
    private MavenArtifactResolver resolver;
    private boolean resolveDependencies;
    private DependencyTreeBuilder treeBuilder;
    private DependencyTreeVisitor<?> treeVisitor;
    private boolean parallelProcessing;
    private MessageWriter log;
    private List<DependencyTreeRoot> roots = new ArrayList<DependencyTreeRoot>();

    public static DependencyTreeProcessor configure() {
        return new DependencyTreeProcessor();
    }

    private DependencyTreeProcessor() {
    }

    public DependencyTreeProcessor setTreeBuilder(DependencyTreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        return this;
    }

    public DependencyTreeProcessor setArtifactResolver(MavenArtifactResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public DependencyTreeProcessor setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
        return this;
    }

    public DependencyTreeProcessor setTreeVisitor(DependencyTreeVisitor<?> treeVisitor) {
        this.treeVisitor = treeVisitor;
        return this;
    }

    public DependencyTreeProcessor setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
        return this;
    }

    public DependencyTreeProcessor setMessageWriter(MessageWriter log) {
        this.log = log;
        return this;
    }

    public DependencyTreeProcessor addRoot(Artifact artifact) {
        return this.addRoot(artifact, List.of(), List.of());
    }

    public DependencyTreeProcessor addRoot(Artifact artifact, List<Dependency> constraints) {
        return this.addRoot(artifact, constraints, List.of());
    }

    public DependencyTreeProcessor addRoot(Artifact artifact, List<Dependency> constraints, Collection<Exclusion> exclusions) {
        this.roots.add(new DependencyTreeRoot(artifact, constraints, exclusions));
        return this;
    }

    public void process() {
        if (this.resolver == null) {
            BootstrapMavenContextConfig config = BootstrapMavenContext.config().setWorkspaceDiscovery(false).setArtifactTransferLogging(false);
            if (this.settings != null) {
                File f = new File(this.settings);
                if (!f.exists()) {
                    throw new IllegalArgumentException(f + " does not exist");
                }
                config.setUserSettings(f);
            }
            if (this.repoDir != null) {
                config.setLocalRepository(this.repoDir);
            }
            if (this.profiles != null && !this.profiles.isEmpty()) {
                System.setProperty("quarkus-internal.maven-cmd-line-args", "-P" + this.profiles);
            }
            try {
                this.resolver = new MavenArtifactResolver(new BootstrapMavenContext(config));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
            }
        }
        if (this.treeBuilder == null) {
            Objects.requireNonNull(this.resolver);
            DependencyTreeBuilder dependencyTreeBuilder = this.treeBuilder = this.resolveDependencies ? DependencyTreeBuilder.resolvingTreeBuilder(this.resolver) : DependencyTreeBuilder.nonResolvingTreeBuilder(this.resolver);
        }
        if (this.log == null) {
            this.log = MessageWriter.info();
        }
        if (this.treeVisitor == null) {
            this.treeVisitor = new DependencyTreeVisitor<Object>(){

                @Override
                public void visitTree(DependencyTreeVisitor.DependencyTreeVisit<Object> ctx) {
                }

                @Override
                public void onEvent(Object event, MessageWriter log) {
                }

                @Override
                public void handleResolutionFailures(Collection<Artifact> artifacts) {
                }
            };
        }
        DependencyTreeVisitScheduler scheduler = this.parallelProcessing ? DependencyTreeVisitScheduler.parallel(this.treeBuilder, this.treeVisitor, this.log, this.roots.size()) : DependencyTreeVisitScheduler.sequencial(this.treeBuilder, this.treeVisitor, this.log, this.roots.size());
        for (DependencyTreeRoot r : this.roots) {
            scheduler.scheduleProcessing(r);
        }
        scheduler.waitForCompletion();
        if (!scheduler.getResolutionFailures().isEmpty()) {
            this.treeVisitor.handleResolutionFailures(scheduler.getResolutionFailures());
        }
    }
}

