/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.tree;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.processor.ExecutionContext;
import io.quarkus.domino.processor.NodeProcessor;
import io.quarkus.domino.processor.ParallelTreeProcessor;
import io.quarkus.domino.processor.TaskResult;
import io.quarkus.domino.tree.BaseDependencyTreeProcessScheduler;
import io.quarkus.domino.tree.DependencyTreeBuilder;
import io.quarkus.domino.tree.DependencyTreeRoot;
import io.quarkus.domino.tree.DependencyTreeVisitor;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;

public interface DependencyTreeVisitScheduler {
    public static <E> DependencyTreeVisitScheduler sequencial(final DependencyTreeBuilder treeBuilder, final DependencyTreeVisitor<E> processor, final MessageWriter log, int treesTotal) {
        return new BaseDependencyTreeProcessScheduler<E>(processor, log, treesTotal){

            @Override
            public void scheduleProcessing(DependencyTreeRoot root) {
                DependencyNode rootNode;
                try {
                    rootNode = treeBuilder.buildTree(root);
                    log.info(this.getResolvedTreeMessage(rootNode.getArtifact()));
                }
                catch (Exception e) {
                    this.resolutionFailures.add(root.getArtifact());
                    log.error(e.getLocalizedMessage());
                    return;
                }
                this.ctx.root = rootNode;
                processor.visitTree(this.ctx);
            }

            @Override
            public void waitForCompletion() {
            }
        };
    }

    public static <E> DependencyTreeVisitScheduler parallel(final DependencyTreeBuilder treeBuilder, final DependencyTreeVisitor<E> processor, final MessageWriter log, int treesTotal) {
        return new BaseDependencyTreeProcessScheduler<E>(processor, log, treesTotal){
            final ParallelTreeProcessor<String, DependencyTreeRoot, DependencyNode> treeProcessor;
            int scheduledTotal;
            {
                super(processor2, log2, rootsTotal);
                this.treeProcessor = ParallelTreeProcessor.with(new NodeProcessor<String, DependencyTreeRoot, DependencyNode>(){

                    @Override
                    public String getNodeId(DependencyTreeRoot request) {
                        return request.getId();
                    }

                    @Override
                    public Iterable<DependencyTreeRoot> getChildren(DependencyTreeRoot node) {
                        return List.of();
                    }

                    @Override
                    public Function<ExecutionContext<String, DependencyTreeRoot, DependencyNode>, TaskResult<String, DependencyTreeRoot, DependencyNode>> createFunction() {
                        return ctx -> {
                            DependencyTreeRoot request = (DependencyTreeRoot)ctx.getNode();
                            try {
                                DependencyNode node = treeBuilder.buildTree(request);
                                log.info(this.getResolvedTreeMessage(request.getArtifact()));
                                return ctx.success(node);
                            }
                            catch (Exception e) {
                                return ctx.failure(e);
                            }
                        };
                    }
                });
                this.scheduledTotal = 0;
            }

            @Override
            public void scheduleProcessing(DependencyTreeRoot root) {
                ++this.scheduledTotal;
                this.treeProcessor.addRoot(root);
            }

            @Override
            public void waitForCompletion() {
                List<TaskResult<String, DependencyTreeRoot, DependencyNode>> results = this.treeProcessor.schedule().join();
                for (TaskResult<String, DependencyTreeRoot, DependencyNode> r : results) {
                    if (r.isFailure()) {
                        this.resolutionFailures.add(r.getNode().getArtifact());
                        log.error("Failed to resolve dependencies of " + r.getId());
                        continue;
                    }
                    this.ctx.root = r.getOutcome();
                    processor.visitTree(this.ctx);
                }
            }
        };
    }

    default public void scheduleProcessing(Artifact rootArtifact, List<Dependency> constraints, Collection<Exclusion> exclusions) {
        this.scheduleProcessing(new DependencyTreeRoot(rootArtifact, constraints, exclusions));
    }

    public void scheduleProcessing(DependencyTreeRoot var1);

    public void waitForCompletion();

    public Collection<Artifact> getResolutionFailures();

    public static interface TreeProcessingResultHandler<R> {
        public void handleResult(R var1, MessageWriter var2);
    }
}

