/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.util.GlobUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class ArtifactCoordsPattern {
    private static final char DELIMITER = ':';
    private static final String DELIMITER_STRING = String.valueOf(':');
    private static volatile ArtifactCoordsPattern matchAll;
    private static volatile ArtifactCoordsPattern matchSnapshots;
    static final String MULTI_WILDCARD = "*";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    final ArtifactCoordsSegmentPattern groupIdPattern;
    final ArtifactCoordsSegmentPattern artifactIdPattern;
    final ArtifactCoordsSegmentPattern classifierPattern;
    final ArtifactCoordsSegmentPattern typePattern;
    final ArtifactCoordsSegmentPattern versionPattern;
    private final String source;

    public static Builder builder() {
        return new Builder();
    }

    public static ArtifactCoordsPattern of(ArtifactCoords c) {
        Builder pattern = ArtifactCoordsPattern.builder();
        pattern.setGroupId(c.getGroupId());
        pattern.setArtifactId(c.getArtifactId());
        if (c.getClassifier() != null && !c.getClassifier().isEmpty()) {
            pattern.setClassifier(c.getClassifier());
        }
        if (c.getType() != null && !c.getType().isEmpty()) {
            pattern.setType(c.getType());
        }
        return pattern.setVersion(c.getVersion()).build();
    }

    public static List<ArtifactCoordsPattern> toPatterns(Collection<ArtifactCoords> coords) {
        if (coords.isEmpty()) {
            return List.of();
        }
        ArrayList<ArtifactCoordsPattern> result = new ArrayList<ArtifactCoordsPattern>(coords.size());
        for (ArtifactCoords c : coords) {
            result.add(ArtifactCoordsPattern.of(c));
        }
        return result;
    }

    public static ArtifactCoordsPattern matchAll() {
        if (matchAll == null) {
            matchAll = new ArtifactCoordsPattern(ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL);
        }
        return matchAll;
    }

    public static ArtifactCoordsPattern matchSnapshots() {
        if (matchSnapshots == null) {
            matchSnapshots = new ArtifactCoordsPattern(ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, new ArtifactCoordsSegmentPattern("*-SNAPSHOT"));
        }
        return matchSnapshots;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArtifactCoordsPattern of(String wildcardPattern) {
        ArtifactCoordsSegmentPattern groupIdPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        ArtifactCoordsSegmentPattern artifactIdPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        ArtifactCoordsSegmentPattern typePattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        ArtifactCoordsSegmentPattern classifierPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        ArtifactCoordsSegmentPattern versionPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        String[] parts = wildcardPattern.split(DELIMITER_STRING);
        if (parts.length <= 0) return new ArtifactCoordsPattern(groupIdPattern, artifactIdPattern, classifierPattern, typePattern, versionPattern);
        groupIdPattern = new ArtifactCoordsSegmentPattern(parts[0]);
        if (parts.length <= 1) return new ArtifactCoordsPattern(groupIdPattern, artifactIdPattern, classifierPattern, typePattern, versionPattern);
        artifactIdPattern = new ArtifactCoordsSegmentPattern(parts[1]);
        if (parts.length <= 2) return new ArtifactCoordsPattern(groupIdPattern, artifactIdPattern, classifierPattern, typePattern, versionPattern);
        String third = parts[2];
        if (parts.length > 3) {
            String fourth = parts[3];
            if (parts.length <= 4) throw new IllegalStateException(ArtifactCoordsSegmentPattern.class.getName() + ".of() expects groupId:artifactId:version or groupId:artifactId:classifier:type:version; found: " + wildcardPattern);
            classifierPattern = new ArtifactCoordsSegmentPattern(third);
            typePattern = new ArtifactCoordsSegmentPattern(fourth);
            versionPattern = new ArtifactCoordsSegmentPattern(parts[4]);
            return new ArtifactCoordsPattern(groupIdPattern, artifactIdPattern, classifierPattern, typePattern, versionPattern);
        } else {
            versionPattern = new ArtifactCoordsSegmentPattern(third);
        }
        return new ArtifactCoordsPattern(groupIdPattern, artifactIdPattern, classifierPattern, typePattern, versionPattern);
    }

    ArtifactCoordsPattern(ArtifactCoordsSegmentPattern groupIdPattern, ArtifactCoordsSegmentPattern artifactIdPattern, ArtifactCoordsSegmentPattern classifierPattern, ArtifactCoordsSegmentPattern typePattern, ArtifactCoordsSegmentPattern versionPattern) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.classifierPattern = classifierPattern;
        this.typePattern = typePattern;
        this.versionPattern = versionPattern;
        StringBuilder source = new StringBuilder(groupIdPattern.getSource().length() + artifactIdPattern.getSource().length() + classifierPattern.getSource().length() + typePattern.getSource().length() + versionPattern.getSource().length() + 3);
        source.append(groupIdPattern.getSource());
        boolean artifactMatchesAll = artifactIdPattern.matchesAll();
        boolean classifierMatchesAll = classifierPattern.matchesAll();
        boolean typeMatchesAll = typePattern.matchesAll();
        boolean versionMatchesAll = versionPattern.matchesAll();
        if (!versionMatchesAll) {
            source.append(':').append(artifactIdPattern.getSource());
            if (!typeMatchesAll || !classifierMatchesAll) {
                source.append(':').append(classifierPattern.getSource());
                source.append(':').append(typePattern.getSource());
            }
            source.append(':').append(versionPattern.getSource());
        } else if (!typeMatchesAll || !classifierMatchesAll) {
            source.append(':').append(artifactIdPattern.getSource());
            source.append(':').append(classifierPattern.getSource());
            source.append(':').append(typePattern.getSource());
        } else if (!artifactMatchesAll) {
            source.append(':').append(artifactIdPattern.getSource());
        }
        this.source = source.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactCoordsPattern other = (ArtifactCoordsPattern)obj;
        return this.source.equals(other.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean matches(ArtifactCoords coords) {
        return this.groupIdPattern.matches(coords.getGroupId()) && this.artifactIdPattern.matches(coords.getArtifactId()) && this.classifierPattern.matches(coords.getClassifier()) && this.typePattern.matches(coords.getType()) && this.versionPattern.matches(coords.getVersion());
    }

    public boolean matches(String groupId, String artifactId, String classifier, String type, String version) {
        return this.groupIdPattern.matches(groupId) && this.artifactIdPattern.matches(artifactId) && this.classifierPattern.matches(classifier) && this.typePattern.matches(type) && this.versionPattern.matches(version);
    }

    public String toString() {
        return this.source;
    }

    static class ArtifactCoordsSegmentPattern {
        private static final ArtifactCoordsSegmentPattern MATCH_ALL = new ArtifactCoordsSegmentPattern("*");
        private final Pattern pattern;
        private final String source;

        ArtifactCoordsSegmentPattern(String wildcardSource) {
            this.pattern = Pattern.compile(GlobUtil.toRegexPattern((String)wildcardSource));
            this.source = wildcardSource;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArtifactCoordsSegmentPattern other = (ArtifactCoordsSegmentPattern)obj;
            return this.source.equals(other.source);
        }

        public String getSource() {
            return this.source;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean matches(String input) {
            if (input == null) {
                return MATCH_ALL.equals(this);
            }
            return this.pattern.matcher(input).matches();
        }

        public boolean matchesAll() {
            return MATCH_ALL.equals(this);
        }

        public String toString() {
            return this.source;
        }
    }

    public static class Builder {
        private ArtifactCoordsSegmentPattern groupIdPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        private ArtifactCoordsSegmentPattern artifactIdPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        private ArtifactCoordsSegmentPattern typePattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        private ArtifactCoordsSegmentPattern classifierPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        private ArtifactCoordsSegmentPattern versionPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;

        private Builder() {
        }

        public ArtifactCoordsPattern build() {
            return new ArtifactCoordsPattern(this.groupIdPattern, this.artifactIdPattern, this.classifierPattern, this.typePattern, this.versionPattern);
        }

        public Builder setGroupId(String wildcardPattern) {
            this.groupIdPattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }

        public Builder setArtifactId(String wildcardPattern) {
            this.artifactIdPattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }

        public Builder setClassifier(String wildcardPattern) {
            this.classifierPattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }

        public Builder setType(String wildcardPattern) {
            this.typePattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }

        public Builder setVersion(String wildcardPattern) {
            this.versionPattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }
    }
}

