/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class MessageWriterOutputStream
extends OutputStream {
    protected final byte[] buf;
    protected int count;
    private final MessageWriter log;

    public MessageWriterOutputStream(MessageWriter log) {
        this(log, 8192);
    }

    public MessageWriterOutputStream(MessageWriter log, int size) {
        this.log = Objects.requireNonNull(log);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.log(new String(this.buf, 0, this.count));
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.log(new String(b, off, len));
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
    }

    private void log(String msg) {
        String ls = System.lineSeparator();
        int from = 0;
        int i = msg.indexOf(ls);
        while (i >= 0) {
            this.println(msg.substring(from, i));
            from = i + ls.length();
            i = msg.indexOf(ls, from);
        }
        if (from < msg.length()) {
            if (msg.endsWith(ls)) {
                this.println(msg.substring(from, msg.length() - ls.length()));
            } else {
                this.println(msg.substring(from));
            }
        }
    }

    private void println(String line) {
        this.log.info(line);
    }
}

