/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import io.quarkus.bom.resolver.EffectiveModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.domino.ProductInfo;
import io.quarkus.domino.ProductReleaseNotes;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.domino.manifest.ManifestGenerator;
import io.quarkus.domino.manifest.PncSbomTransformer;
import io.quarkus.domino.manifest.SbomTransformer;
import io.quarkus.domino.manifest.VisitedComponent;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.maven.model.Model;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.ReleaseNotes;
import org.cyclonedx.model.Tool;
import org.eclipse.jgit.util.Hex;
import org.jboss.logging.Logger;

public class SbomGenerator {
    private static final List<String> HASH_ALGS = List.of("MD5", "SHA-1", "SHA-256", "SHA-512", "SHA-384", "SHA3-384", "SHA3-256", "SHA3-512");
    private static final Logger log = Logger.getLogger(SbomGenerator.class);
    private MavenArtifactResolver resolver;
    private EffectiveModelResolver effectiveModelResolver;
    private Path outputFile;
    private ProductInfo productInfo;
    private boolean enableTransformers;
    private List<VisitedComponent> topComponents;
    private boolean recordDependencies = true;
    private Bom bom;
    private Set<String> addedBomRefs;

    public static Builder builder() {
        return new SbomGenerator().new Builder();
    }

    private SbomGenerator() {
    }

    public Bom generate() {
        this.bom = new Bom();
        this.addedBomRefs = new HashSet<String>();
        Metadata metadata = new Metadata();
        this.bom.setMetadata(metadata);
        this.addToolInfo(metadata);
        for (VisitedComponent c : SbomGenerator.sortAlphabetically(this.topComponents)) {
            this.addComponent(c);
        }
        this.bom = this.transform(this.bom);
        this.addProductInfo(metadata);
        BomJsonGenerator bomGenerator = BomGeneratorFactory.createJson((CycloneDxSchema.Version)ManifestGenerator.schemaVersion(), (Bom)this.bom);
        String bomString = bomGenerator.toJsonString();
        if (this.outputFile == null) {
            System.out.println(bomString);
        } else {
            if (this.outputFile.getParent() != null) {
                try {
                    Files.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create " + this.outputFile.getParent(), e);
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, new OpenOption[0]);){
                writer.write(bomString);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write to " + this.outputFile, e);
            }
        }
        return this.bom;
    }

    private void addComponent(VisitedComponent visited) {
        if (visited.getBomRef() == null) {
            throw new IllegalStateException("bom-ref has not been initialized for " + visited.getPurl());
        }
        if (!this.addedBomRefs.add(visited.getBomRef())) {
            return;
        }
        Model model = this.effectiveModelResolver.resolveEffectiveModel(visited.getArtifactCoords(), visited.getRepositories());
        Component c = new Component();
        ManifestGenerator.extractMetadata(visited.getRevision(), model, c);
        if (c.getPublisher() == null) {
            c.setPublisher("central");
        }
        ArtifactCoords coords = visited.getArtifactCoords();
        c.setGroup(coords.getGroupId());
        c.setName(coords.getArtifactId());
        c.setVersion(coords.getVersion());
        c.setPurl(visited.getPurl());
        c.setBomRef(visited.getBomRef());
        ArrayList<Property> props = new ArrayList<Property>(2);
        ManifestGenerator.addProperty(props, "package:type", "maven");
        if (!"pom".equals(coords.getType())) {
            ManifestGenerator.addProperty(props, "package:language", "java");
        }
        c.setProperties(props);
        c.setType(Component.Type.LIBRARY);
        if (RhVersionPattern.isRhVersion(c.getVersion())) {
            PncSbomTransformer.addMrrc(c);
        }
        this.bom.addComponent(c);
        List<VisitedComponent> dependencies = visited.getDependencies();
        if (!dependencies.isEmpty()) {
            Dependency d = this.recordDependencies ? new Dependency(c.getBomRef()) : null;
            for (VisitedComponent child : SbomGenerator.sortAlphabetically(dependencies)) {
                if (d != null) {
                    d.addDependency(new Dependency(child.getBomRef()));
                }
                this.addComponent(child);
            }
            if (d != null) {
                this.bom.addDependency(d);
            }
        }
    }

    private void addProductInfo(Metadata metadata) {
        if (this.productInfo != null) {
            Property prop;
            String group = this.productInfo.getGroup();
            String name = this.productInfo.getName();
            String version = this.productInfo.getVersion();
            Component c = new Component();
            if (group != null) {
                c.setGroup(group);
            }
            if (name != null) {
                c.setName(name);
            }
            if (version != null) {
                c.setVersion(version);
            }
            if (this.productInfo.getPurl() != null) {
                c.setPurl(this.productInfo.getPurl());
            }
            if (this.productInfo.getType() != null) {
                c.setType(Component.Type.valueOf((String)this.productInfo.getType()));
            }
            if (this.productInfo.getCpe() != null) {
                c.setCpe(this.productInfo.getCpe());
            }
            if (this.productInfo.getDescription() != null) {
                c.setDescription(this.productInfo.getDescription());
            }
            if (group != null && name != null && version != null) {
                Component addedComponent = null;
                block0: for (VisitedComponent visited : this.topComponents) {
                    ArtifactCoords coords = visited.getArtifactCoords();
                    if (!name.equals(coords.getArtifactId()) || !group.equals(coords.getGroupId()) || !version.equals(coords.getVersion())) continue;
                    for (Component added : this.bom.getComponents()) {
                        if (!added.getBomRef().equals(visited.getBomRef())) continue;
                        addedComponent = added;
                        break block0;
                    }
                }
                if (addedComponent != null) {
                    c.setLicenseChoice(addedComponent.getLicenseChoice());
                    if (c.getPurl() == null) {
                        c.setPurl(addedComponent.getPurl());
                    }
                }
            }
            if (this.productInfo.getReleaseNotes() != null) {
                ProductReleaseNotes config = this.productInfo.getReleaseNotes();
                ReleaseNotes rn = new ReleaseNotes();
                if (config.getTitle() != null) {
                    rn.setTitle(config.getTitle());
                }
                if (config.getType() != null) {
                    rn.setType(config.getType());
                }
                if (!config.getAliases().isEmpty()) {
                    rn.setAliases(config.getAliases());
                }
                if (!config.getProperties().isEmpty()) {
                    ArrayList<String> names = new ArrayList<String>(config.getProperties().keySet());
                    Collections.sort(names);
                    ArrayList<Property> propList = new ArrayList<Property>(names.size());
                    for (String propName : names) {
                        Property prop2 = new Property();
                        prop2.setName(propName);
                        prop2.setValue(config.getProperties().get(propName));
                        propList.add(prop2);
                    }
                    rn.setProperties(propList);
                }
                c.setReleaseNotes(rn);
            }
            if (this.productInfo.getId() != null) {
                prop = new Property();
                prop.setName("product-id");
                prop.setValue(this.productInfo.getId());
                c.addProperty(prop);
            }
            if (this.productInfo.getStream() != null) {
                prop = new Property();
                prop.setName("product-stream");
                prop.setValue(this.productInfo.getStream());
                c.addProperty(prop);
            }
            metadata.setComponent(c);
        }
    }

    private Bom transform(Bom bom) {
        Iterator<SbomTransformer> i;
        if (this.enableTransformers && (i = ServiceLoader.load(SbomTransformer.class).iterator()).hasNext()) {
            ManifestGenerator.SbomTransformContextImpl ctx = new ManifestGenerator.SbomTransformContextImpl(bom);
            while (i.hasNext()) {
                Bom transformed = i.next().transform(ctx);
                if (transformed != null) {
                    ctx.bom = transformed;
                }
                bom = ctx.bom;
            }
        }
        return bom;
    }

    private void addToolInfo(Metadata metadata) {
        Tool tool = new Tool();
        tool.setName("Quarkus - Platform BOM Tools - Domino - Dependency analyzer");
        tool.setVendor("Quarkus Community");
        tool.setVersion("0.0.103");
        metadata.setTools(List.of(tool));
        Path toolLocation = this.getToolLocation();
        if (toolLocation == null) {
            return;
        }
        String toolName = toolLocation.getFileName().toString();
        if (toolName.endsWith(".jar")) {
            toolName = toolName.substring(0, toolName.length() - ".jar".length());
        }
        String[] parts = toolName.split("-");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (s.isBlank()) continue;
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() > 1) {
                sb.append(s.substring(1));
            }
            sb.append(' ');
        }
        tool.setName(sb.append("SBOM Generator").toString());
        if (!Files.isDirectory(toolLocation, new LinkOption[0])) {
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(toolLocation);
            }
            catch (IOException e) {
                log.warn((Object)"Failed to read the tool's binary", (Throwable)e);
                return;
            }
            ArrayList<Hash> hashes = new ArrayList<Hash>(HASH_ALGS.size());
            for (String alg : HASH_ALGS) {
                Hash hash = SbomGenerator.getHash(alg, bytes);
                if (hash == null) continue;
                hashes.add(hash);
            }
            if (!hashes.isEmpty()) {
                tool.setHashes(hashes);
            }
        } else {
            log.warn((Object)("skipping tool hashing because " + toolLocation + " appears to be a directory"));
        }
    }

    private static Hash getHash(String alg, byte[] content) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(alg);
        }
        catch (NoSuchAlgorithmException e) {
            log.warn((Object)("Failed to initialize a message digest with algorithm " + alg + ": " + e.getLocalizedMessage()));
            return null;
        }
        return new Hash(md.getAlgorithm(), Hex.toHexString((byte[])md.digest(content)));
    }

    private Path getToolLocation() {
        CodeSource cs = this.getClass().getProtectionDomain().getCodeSource();
        if (cs == null) {
            log.warn((Object)"Failed to determine code source of the tool");
            return null;
        }
        URL url = cs.getLocation();
        if (url == null) {
            log.warn((Object)"Failed to determine code source URL of the tool");
            return null;
        }
        try {
            return Path.of(url.toURI());
        }
        catch (URISyntaxException e) {
            log.warn((Object)("Failed to translate " + url + " to a file system path"), (Throwable)e);
            return null;
        }
    }

    private static List<VisitedComponent> sortAlphabetically(List<VisitedComponent> col) {
        col.sort((o1, o2) -> {
            ArtifactCoords coords1 = o1.getArtifactCoords();
            ArtifactCoords coords2 = o2.getArtifactCoords();
            int i = coords1.getGroupId().compareTo(coords2.getGroupId());
            if (i != 0) {
                return i;
            }
            i = coords1.getArtifactId().compareTo(coords2.getArtifactId());
            if (i != 0) {
                return i;
            }
            i = coords1.getClassifier().compareTo(coords2.getClassifier());
            if (i != 0) {
                return i;
            }
            i = coords1.getType().compareTo(coords2.getType());
            if (i != 0) {
                return i;
            }
            return coords1.getVersion().compareTo(coords2.getVersion());
        });
        return col;
    }

    public class Builder {
        private boolean built;

        private Builder() {
        }

        public Builder setArtifactResolver(MavenArtifactResolver resolver) {
            this.ensureNotBuilt();
            SbomGenerator.this.resolver = resolver;
            return this;
        }

        public MavenArtifactResolver getArtifactResolver() {
            return SbomGenerator.this.resolver;
        }

        public Builder setOutputFile(Path outputFile) {
            this.ensureNotBuilt();
            SbomGenerator.this.outputFile = outputFile;
            return this;
        }

        public Builder setProductInfo(ProductInfo productInfo) {
            this.ensureNotBuilt();
            SbomGenerator.this.productInfo = productInfo;
            return this;
        }

        public ProductInfo getProductInfo() {
            return SbomGenerator.this.productInfo;
        }

        public Builder setEnableTransformers(boolean enableTransformers) {
            this.ensureNotBuilt();
            SbomGenerator.this.enableTransformers = enableTransformers;
            return this;
        }

        public Builder setRecordDependencies(boolean recordDependencies) {
            this.ensureNotBuilt();
            SbomGenerator.this.recordDependencies = recordDependencies;
            return this;
        }

        public Builder setTopComponents(List<VisitedComponent> topComponents) {
            this.ensureNotBuilt();
            SbomGenerator.this.topComponents = topComponents;
            return this;
        }

        public SbomGenerator build() {
            this.ensureNotBuilt();
            if (SbomGenerator.this.topComponents == null || SbomGenerator.this.topComponents.isEmpty()) {
                throw new IllegalArgumentException("Top components have not been provided");
            }
            if (SbomGenerator.this.resolver == null) {
                try {
                    SbomGenerator.this.resolver = MavenArtifactResolver.builder().build();
                }
                catch (BootstrapMavenException e) {
                    throw new IllegalStateException("Failed to initialize Maven artifact resolver", e);
                }
            }
            SbomGenerator.this.effectiveModelResolver = new EffectiveModelResolver(SbomGenerator.this.resolver);
            return SbomGenerator.this;
        }

        private void ensureNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("This builder instance has already been built");
            }
        }
    }
}

