/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.repository.RemoteRepository;

public class ReleaseRepo {
    final ScmRevision revision;
    final Map<ArtifactCoords, List<RemoteRepository>> artifacts = new HashMap<ArtifactCoords, List<RemoteRepository>>();
    final Map<ScmRevision, ReleaseRepo> dependants = new HashMap<ScmRevision, ReleaseRepo>();
    final Map<ScmRevision, ReleaseRepo> dependencies = new LinkedHashMap<ScmRevision, ReleaseRepo>();

    ReleaseRepo(ScmRevision revision) {
        this.revision = revision;
    }

    @Deprecated(forRemoval=true)
    public ReleaseId id() {
        return this.revision;
    }

    public ScmRevision getRevision() {
        return this.revision;
    }

    public Map<ArtifactCoords, List<RemoteRepository>> getArtifacts() {
        return this.artifacts;
    }

    public Collection<ReleaseRepo> getDependencies() {
        return this.dependencies.values();
    }

    void addRepoDependency(ReleaseRepo repo) {
        if (repo != this) {
            this.dependencies.putIfAbsent(repo.getRevision(), repo);
            repo.dependants.putIfAbsent(this.getRevision(), this);
        }
    }

    public boolean isRoot() {
        return this.dependants.isEmpty();
    }
}

