/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.inspect;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class DependencyTreeRequest {
    private static final byte ROOT = 1;
    private static final byte DEPENDENCY = 2;
    private static final byte PLUGIN = 4;
    private static final AtomicInteger counter = new AtomicInteger();
    private final Integer id;
    private final Artifact root;
    private final List<Dependency> constraints;
    private final Collection<Exclusion> exclusions;
    private final byte type;

    public static DependencyTreeRequest ofRoot(Artifact artifact, List<Dependency> constraints, Collection<Exclusion> exclusions) {
        return new DependencyTreeRequest(artifact, constraints, exclusions, 1);
    }

    public static DependencyTreeRequest ofDependency(Artifact artifact, List<Dependency> constraints, Collection<Exclusion> exclusions) {
        return new DependencyTreeRequest(artifact, constraints, exclusions, 2);
    }

    public static DependencyTreeRequest ofPlugin(Artifact artifact) {
        return DependencyTreeRequest.ofPlugin(artifact, List.of());
    }

    public static DependencyTreeRequest ofPlugin(Artifact artifact, Collection<Exclusion> exclusions) {
        return new DependencyTreeRequest(artifact, List.of(), exclusions, 4);
    }

    private DependencyTreeRequest(Artifact root, List<Dependency> constraints, Collection<Exclusion> exclusions, byte type) {
        this.root = root;
        this.constraints = constraints;
        this.exclusions = exclusions;
        this.type = type;
        this.id = counter.incrementAndGet();
    }

    Integer getId() {
        return this.id;
    }

    public Artifact getArtifact() {
        return this.root;
    }

    public List<Dependency> getConstraints() {
        return this.constraints;
    }

    public Collection<Exclusion> getExclusions() {
        return this.exclusions;
    }

    boolean isRoot() {
        return this.type == 1;
    }

    boolean isDependency() {
        return this.type == 2;
    }

    boolean isPlugin() {
        return this.type == 4;
    }
}

