/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.SimpleDependencyGraphTransformationContext;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.MavenArtifactVersion;
import io.quarkus.domino.MavenArtifactVersionConstraint;
import io.quarkus.domino.MessageWriterOutputStream;
import io.quarkus.domino.gradle.GradleActionOutcome;
import io.quarkus.domino.gradle.GradleDependency;
import io.quarkus.domino.gradle.GradleModuleDependencies;
import io.quarkus.domino.gradle.GradleProjectDependencies;
import io.quarkus.domino.gradle.GradleProjectDependencyResolver;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.util.graph.transformer.ConflictMarker;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;

public class GradleProjectReader {
    public static Map<ArtifactCoords, DependencyNode> resolveModuleDependencies(Path projectDir, boolean java8, String javaHome, MavenArtifactResolver mavenResolver, MessageWriter log) {
        Collection<GradleModuleDependencies> modules = GradleProjectReader.resolveDirtyTrees(projectDir, java8, javaHome, log);
        HashMap<ArtifactCoords, DependencyNode> result = new HashMap<ArtifactCoords, DependencyNode>(modules.size());
        for (GradleModuleDependencies module : modules) {
            DefaultDependencyNode moduleNode = GradleProjectReader.createNode(new Dependency((Artifact)new DefaultArtifact(module.getGroup(), module.getName(), "jar", module.getVersion()), "runtime"));
            moduleNode.setChildren(GradleProjectReader.toMavenDeps(module.getDependencies()));
            try {
                DependencyNode node = GradleProjectReader.converge(mavenResolver.getSession(), (DependencyNode)moduleNode);
                Artifact a = node.getArtifact();
                ArtifactCoords coords = ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
                result.put(coords, node);
            }
            catch (AppModelResolverException e) {
                throw new RuntimeException("Failed to converge Gradle dependency tree for module " + module, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<GradleModuleDependencies> resolveDirtyTrees(Path projectDir, boolean java8, String javaHome, MessageWriter log) {
        log.debug("Loading project %s", new Object[]{projectDir});
        ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(projectDir.toFile()).connect();
        Path dominoInitScript = GradleProjectReader.generateDominoInitScript(projectDir);
        try {
            BuildActionExecuter actionExecuter = (BuildActionExecuter)((BuildActionExecuter)connection.action((BuildAction)new GradleProjectDependencyResolver()).withArguments(new String[]{"--init-script=" + dominoInitScript, "-PskipAndroid=true"})).setStandardOutput(log == null ? System.out : new MessageWriterOutputStream(log));
            if ((javaHome == null || javaHome.isEmpty()) && java8 && (javaHome = System.getenv("JAVA8_HOME")) == null) {
                throw new IllegalArgumentException("Gradle Java 8 option was enabled but JAVA8_HOME environment variable was not set");
            }
            if (javaHome != null && !javaHome.isEmpty()) {
                File jh = new File(javaHome);
                if (!jh.isDirectory()) {
                    throw new IllegalArgumentException("Provided Java home directory " + jh + " does not exist");
                }
                actionExecuter.setJavaHome(jh);
            }
            GradleActionOutcome outcome = GradleActionOutcome.of();
            actionExecuter.run((ResultHandler)outcome);
            Collection collection = ((GradleProjectDependencies)outcome.getResult()).getModules();
            return collection;
        }
        finally {
            connection.close();
            dominoInitScript.toFile().deleteOnExit();
        }
    }

    private static Path generateDominoInitScript(Path projectDir) {
        Path dominoInitScript = projectDir.resolve("domino-init.gradle");
        try (PrintStream out = new PrintStream(Files.newOutputStream(dominoInitScript, new OpenOption[0]));){
            out.println("initscript {");
            out.println("    repositories {");
            out.println("        mavenCentral()");
            out.println("        mavenLocal()");
            out.println("        maven { url 'https://repo.gradle.org/gradle/libs-releases' }");
            out.println("    }");
            out.println("    dependencies {");
            out.println("        classpath \"io.quarkus.domino:io.quarkus.domino.gradle.plugin:0.0.107\"");
            out.println("    }");
            out.println("}");
            out.println("allprojects {");
            out.println("    apply plugin: io.quarkus.domino.gradle.DependencyPlugin");
            out.println("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to persist Gradle init script " + dominoInitScript, e);
        }
        return dominoInitScript;
    }

    private static void log(DependencyNode node, int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        if (depth == 0) {
            sb.append("MODULE: ");
        }
        sb.append(node.getArtifact());
        System.out.println(sb);
        sb = null;
        for (DependencyNode c : node.getChildren()) {
            GradleProjectReader.log(c, depth + 1);
        }
    }

    private static DependencyNode converge(RepositorySystemSession session, DependencyNode root) throws AppModelResolverException {
        SimpleDependencyGraphTransformationContext context = new SimpleDependencyGraphTransformationContext(session);
        try {
            root = new ConflictMarker().transformGraph(root, (DependencyGraphTransformationContext)context);
            root = new ConflictIdSorter().transformGraph(root, (DependencyGraphTransformationContext)context);
            root = session.getDependencyGraphTransformer().transformGraph(root, (DependencyGraphTransformationContext)context);
        }
        catch (RepositoryException e) {
            throw new AppModelResolverException("Failed to normalize the dependency graph", (Throwable)e);
        }
        return root;
    }

    private static List<DependencyNode> toMavenDeps(List<GradleDependency> deps) {
        ArrayList<DependencyNode> result = new ArrayList<DependencyNode>(deps.size());
        for (GradleDependency d : deps) {
            DefaultDependencyNode node = GradleProjectReader.createNode(new Dependency((Artifact)new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion()), "runtime"));
            result.add((DependencyNode)node);
            node.setChildren(GradleProjectReader.toMavenDeps(d.getDependencies()));
        }
        return result;
    }

    private static DefaultDependencyNode createNode(Dependency dep) {
        DefaultDependencyNode node = new DefaultDependencyNode(dep);
        MavenArtifactVersion v = new MavenArtifactVersion(dep.getArtifact().getVersion());
        node.setVersion((Version)v);
        node.setVersionConstraint((VersionConstraint)new MavenArtifactVersionConstraint(v));
        return node;
    }
}

