/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;

public enum BuildTool {
    MAVEN(List.of("pom.xml")),
    GRADLE(List.of("build.gradle", "build.gradle.kts"));

    private final Collection<String> buildFiles;

    private BuildTool(Collection<String> buildFile) {
        this.buildFiles = buildFile;
    }

    public boolean canBuild(Path dir) {
        for (String s : this.buildFiles) {
            if (!Files.exists(dir.resolve(s), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    public static BuildTool forProjectDir(Path projectDir) {
        if (Files.isDirectory(projectDir, new LinkOption[0])) {
            for (BuildTool bt : BuildTool.values()) {
                if (!bt.canBuild(projectDir)) continue;
                return bt;
            }
        }
        throw new IllegalArgumentException("Unable to determine the build tool for " + projectDir);
    }
}

