/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.domino.scm.ScmRevision;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CircularReleaseDependency {
    private final List<ScmRevision> chain;

    public static CircularReleaseDependency of(List<ScmRevision> chain) {
        return new CircularReleaseDependency(chain);
    }

    private CircularReleaseDependency(List<ScmRevision> chain) {
        if (chain == null || chain.size() < 2) {
            throw new IllegalArgumentException("Invalid circular release dependency chain " + chain);
        }
        this.chain = List.copyOf(chain);
    }

    public List<ScmRevision> getDependencyChain() {
        return this.chain;
    }

    @Deprecated(forRemoval=true)
    public List<ReleaseId> getReleaseDependencyChain() {
        ArrayList<ReleaseId> result = new ArrayList<ReleaseId>(this.chain.size());
        for (ScmRevision r : this.chain) {
            result.add((ReleaseId)r);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(this.chain.get(0));
        for (int i = 1; i < this.chain.size(); ++i) {
            sb.append(",").append(this.chain.get(i));
        }
        return sb.append(')').toString();
    }

    public int hashCode() {
        return Objects.hash(this.chain);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CircularReleaseDependency other = (CircularReleaseDependency)obj;
        return Objects.equals(this.chain, other.chain);
    }
}

