/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.inspect;

import io.quarkus.domino.inspect.DependencyTreeError;
import io.quarkus.domino.inspect.DependencyTreeRequest;
import io.quarkus.domino.inspect.DependencyTreeVisitContext;
import io.quarkus.domino.inspect.DependencyTreeVisitScheduler;
import java.util.Deque;
import java.util.Formatter;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.artifact.Artifact;

abstract class DependencyTreeVisitSchedulerBase<E>
implements DependencyTreeVisitScheduler {
    private static final String FORMAT_BASE = "[%s/%s %.1f%%] ";
    protected final Deque<DependencyTreeError> errors = new ConcurrentLinkedDeque<DependencyTreeError>();
    protected final DependencyTreeVisitContext<E> ctx;
    protected final AtomicInteger counter = new AtomicInteger();
    protected final int rootsTotal;
    private final String progressTrackerPrefix;

    DependencyTreeVisitSchedulerBase(DependencyTreeVisitContext<E> ctx, int rootsTotal, String progressTrackerPrefix) {
        this.ctx = ctx;
        this.rootsTotal = rootsTotal;
        this.progressTrackerPrefix = progressTrackerPrefix;
    }

    public Deque<DependencyTreeError> getResolutionFailures() {
        return this.errors;
    }

    protected String getResolvedTreeMessage(Artifact a) {
        StringBuilder sb = new StringBuilder(180);
        Formatter formatter = new Formatter(sb);
        int treeIndex = this.counter.incrementAndGet();
        double percents = (double)treeIndex * 100.0 / (double)this.rootsTotal;
        formatter.format(FORMAT_BASE, treeIndex, this.rootsTotal, percents);
        if (this.progressTrackerPrefix != null) {
            sb.append(this.progressTrackerPrefix);
        }
        sb.append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':');
        if (!a.getClassifier().isEmpty()) {
            sb.append(a.getClassifier()).append(':');
        }
        if (!"jar".equals(a.getExtension())) {
            if (a.getClassifier().isEmpty()) {
                sb.append(':');
            }
            sb.append(a.getExtension()).append(':');
        }
        return sb.append(a.getVersion()).toString();
    }

    protected String formatErrorMessage(DependencyTreeRequest request, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to process dependencies of ").append(request.getArtifact());
        if (e != null) {
            if (e.getCause() != null) {
                e = e.getCause();
            }
            String error = e.getLocalizedMessage();
            sb.append(" because ").append(Character.toLowerCase(error.charAt(0))).append(error.substring(1));
        }
        return sb.toString();
    }
}

