/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.inspect.quarkus;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.domino.inspect.quarkus.QuarkusPlatformInfo;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class QuarkusPlatformInfoReader {
    private static volatile ObjectMapper mapper;
    private static final String PLATFORM_COMMUNITY_GROUP_ID = "io.quarkus.platform";
    private static final String PLATFORM_REDHAT_GROUP_ID = "com.redhat.quarkus.platform";
    private static final String QUARKUS_BOM = "quarkus-bom";
    private static final String QUARKUS_PLATFORM_DESCRIPTOR = "-quarkus-platform-descriptor";
    private static final String REDHAT = "redhat";
    private MavenArtifactResolver resolver;
    private String platformKey;
    private String version;

    public static Builder builder() {
        return new QuarkusPlatformInfoReader().new Builder();
    }

    private QuarkusPlatformInfoReader() {
    }

    public QuarkusPlatformInfo readPlatformInfo() {
        ArrayList<QuarkusPlatformInfo.Member> allMembers;
        if (QuarkusPlatformInfoReader.isBlank(this.version)) {
            throw new IllegalArgumentException("Platform version wasn't provided");
        }
        if (QuarkusPlatformInfoReader.isBlank(this.platformKey)) {
            String string = this.platformKey = this.version.contains(REDHAT) ? PLATFORM_REDHAT_GROUP_ID : PLATFORM_COMMUNITY_GROUP_ID;
        }
        if (this.resolver == null) {
            throw new IllegalArgumentException("Artifact resolver was not initialized");
        }
        QuarkusPlatformInfo.Member coreMember = this.readMember(this.platformKey, QUARKUS_BOM, this.version);
        if (coreMember.getRelease() == null) {
            allMembers = new ArrayList<QuarkusPlatformInfo.Member>(1);
            allMembers.add(coreMember);
        } else {
            allMembers = new ArrayList(coreMember.getRelease().getMemberBoms().size());
            allMembers.add(coreMember);
            for (ArtifactCoords memberBom : coreMember.getRelease().getMemberBoms()) {
                if (memberBom.equals(coreMember.getBom())) continue;
                allMembers.add(this.readMember(memberBom.getGroupId(), memberBom.getArtifactId(), memberBom.getVersion()));
            }
        }
        return new QuarkusPlatformInfo(coreMember, allMembers, ArtifactCoords.jar((String)coreMember.getBom().getGroupId(), (String)"quarkus-maven-plugin", (String)coreMember.getBom().getVersion()));
    }

    private QuarkusPlatformInfo.Member readMember(String bomGroupId, String bomArtifactId, String bomVersion) {
        File quarkusBomJson;
        try {
            quarkusBomJson = this.resolver.resolve((Artifact)new DefaultArtifact(bomGroupId, bomArtifactId + QUARKUS_PLATFORM_DESCRIPTOR, bomVersion, "json", bomVersion)).getArtifact().getFile();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException(e);
        }
        return QuarkusPlatformInfoReader.readMember(quarkusBomJson);
    }

    private static boolean isBlank(String s) {
        return s == null || s.isEmpty();
    }

    private static ObjectMapper getMapper() {
        if (mapper == null) {
            ObjectMapper om = new ObjectMapper();
            om.enable(SerializationFeature.INDENT_OUTPUT);
            om.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
            om.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
            om.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper = om;
        }
        return mapper;
    }

    static QuarkusPlatformInfo.Member readMember(File jsonFile) {
        JsonNode root;
        try (BufferedReader reader = new BufferedReader(new FileReader(jsonFile));){
            root = QuarkusPlatformInfoReader.getMapper().readTree((Reader)reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to deserialize " + jsonFile, e);
        }
        return new QuarkusPlatformInfo.Member(ArtifactCoords.fromString((String)QuarkusPlatformInfoReader.readTextValue(root, "bom")), QuarkusPlatformInfoReader.readTextValue(root, "quarkus-core-version"), QuarkusPlatformInfoReader.readMember(root), QuarkusPlatformInfoReader.readRelease(root));
    }

    static List<ArtifactCoords> readMember(JsonNode root) {
        JsonNode node = root.get("extensions");
        if (node == null || !node.isArray()) {
            throw new RuntimeException("Failed to locate extensions array in the extension catalog");
        }
        ArrayNode arr = (ArrayNode)node;
        ArrayList<ArtifactCoords> extCoords = new ArrayList<ArtifactCoords>(arr.size());
        for (JsonNode e : arr) {
            extCoords.add(ArtifactCoords.fromString((String)QuarkusPlatformInfoReader.readTextValue(e, "artifact")));
        }
        return extCoords;
    }

    private static QuarkusPlatformInfo.Release readRelease(JsonNode root) {
        JsonNode node = root.get("metadata");
        if (node == null) {
            return null;
        }
        if ((node = node.get("platform-release")) == null) {
            return null;
        }
        JsonNode members = node.get("members");
        if (members == null || !members.isArray()) {
            throw new RuntimeException("Failed to locate field metadata/platform-release/members");
        }
        ArrayNode memberArr = (ArrayNode)members;
        ArrayList<ArtifactCoords> memberBoms = new ArrayList<ArtifactCoords>(memberArr.size());
        for (JsonNode m : memberArr) {
            ArtifactCoords coords = ArtifactCoords.fromString((String)m.asText());
            memberBoms.add(ArtifactCoords.pom((String)coords.getGroupId(), (String)coords.getArtifactId().replace(QUARKUS_PLATFORM_DESCRIPTOR, ""), (String)coords.getVersion()));
        }
        return new QuarkusPlatformInfo.Release(QuarkusPlatformInfoReader.readTextValue(node, "platform-key"), QuarkusPlatformInfoReader.readTextValue(node, "stream"), QuarkusPlatformInfoReader.readTextValue(node, "version"), memberBoms);
    }

    private static String readTextValue(JsonNode node, String fieldName) {
        JsonNode value = node.get(fieldName);
        if (value == null) {
            throw new RuntimeException("Field " + fieldName + " isn't present");
        }
        return value.textValue();
    }

    public class Builder {
        private boolean built;

        private Builder() {
        }

        public Builder setResolver(MavenArtifactResolver resolver) {
            this.ensureNotBuilt();
            QuarkusPlatformInfoReader.this.resolver = resolver;
            return this;
        }

        public Builder setVersion(String version) {
            this.ensureNotBuilt();
            QuarkusPlatformInfoReader.this.version = version;
            return this;
        }

        public Builder setPlatformKey(String platformKey) {
            this.ensureNotBuilt();
            QuarkusPlatformInfoReader.this.platformKey = platformKey;
            return this;
        }

        public QuarkusPlatformInfoReader build() {
            this.ensureNotBuilt();
            this.built = true;
            return QuarkusPlatformInfoReader.this;
        }

        private void ensureNotBuilt() {
            if (this.built) {
                throw new RuntimeException("This builder instance has already been built");
            }
        }
    }
}

