/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import io.quarkus.domino.PncBuildInfoProvider;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.domino.manifest.PncArtifactBuildInfo;
import io.quarkus.domino.manifest.SbomTransformContext;
import io.quarkus.domino.manifest.SbomTransformer;
import java.util.ArrayList;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.Property;
import org.jboss.logging.Logger;

public class PncSbomTransformer
implements SbomTransformer {
    private static final String PNC = "PNC";
    private static final String BUILD_SYSTEM = "build-system";
    private static final String BUILD_ID = "build-id";
    private static final String PUBLISHER = "redhat";
    private static final String MRRC_URL = "https://maven.repository.redhat.com/ga/";
    private static final Logger log = Logger.getLogger(PncSbomTransformer.class);
    private final PncBuildInfoProvider pncInfoProvider = new PncBuildInfoProvider();

    @Override
    public Bom transform(SbomTransformContext ctx) {
        Component product;
        log.debug((Object)"Adding PNC build info to the manifest");
        Bom bom = ctx.getOriginalBom();
        Component component = product = bom.getMetadata() == null ? null : bom.getMetadata().getComponent();
        if (product != null) {
            this.addBuildId(product, PncSbomTransformer.getContent(this.pncInfoProvider.getBuildInfo(product.getGroup(), product.getName(), product.getVersion())));
        }
        if (bom.getComponents() == null) {
            return bom;
        }
        for (Component c : bom.getComponents()) {
            this.addPncBuildInfo(c);
        }
        return bom;
    }

    private void addPncBuildInfo(Component c) {
        if (!RhVersionPattern.isRhVersion(c.getVersion())) {
            return;
        }
        PncArtifactBuildInfo buildInfo = this.pncInfoProvider.getBuildInfo(c.getGroup(), c.getName(), c.getVersion());
        PncArtifactBuildInfo.Content content = PncSbomTransformer.getContent(buildInfo);
        if (content == null) {
            log.warn((Object)("PNC build info not found for " + c.getGroup() + ":" + c.getName() + ":" + c.getVersion()));
        } else {
            ArrayList<Hash> hashes = new ArrayList<Hash>(3);
            if (content.getMd5() != null) {
                hashes.add(new Hash(Hash.Algorithm.MD5, content.getMd5()));
            }
            if (content.getSha1() != null) {
                hashes.add(new Hash(Hash.Algorithm.SHA1, content.getSha1()));
            }
            if (content.getSha256() != null) {
                hashes.add(new Hash(Hash.Algorithm.SHA_256, content.getSha256()));
            }
            c.setHashes(hashes);
            this.addBuildId(c, content);
        }
        PncSbomTransformer.addMrrc(c);
    }

    private void addBuildId(Component c, PncArtifactBuildInfo.Content content) {
        if (content == null || content.getBuild() == null) {
            log.warn((Object)("PNC build info not found for " + c.getGroup() + ":" + c.getName() + ":" + c.getVersion()));
        } else {
            ArrayList<Property> props = new ArrayList<Property>(c.getProperties());
            Property prop = new Property();
            prop.setName(BUILD_ID);
            prop.setValue(content.getBuild().getId());
            props.add(prop);
            prop = new Property();
            prop.setName(BUILD_SYSTEM);
            prop.setValue(PNC);
            props.add(prop);
            c.setProperties(props);
        }
    }

    static void addMrrc(Component c) {
        c.setPublisher(PUBLISHER);
        ArrayList<ExternalReference> externalRefs = c.getExternalReferences() == null ? new ArrayList<ExternalReference>() : new ArrayList(c.getExternalReferences());
        ExternalReference dist = null;
        for (ExternalReference r : externalRefs) {
            if (!r.getType().equals((Object)ExternalReference.Type.DISTRIBUTION)) continue;
            dist = r;
            break;
        }
        if (dist == null) {
            dist = new ExternalReference();
            dist.setType(ExternalReference.Type.DISTRIBUTION);
            externalRefs.add(dist);
        }
        dist.setUrl(MRRC_URL);
        c.setExternalReferences(externalRefs);
    }

    private static PncArtifactBuildInfo.Content getContent(PncArtifactBuildInfo info) {
        if (info == null) {
            return null;
        }
        if (info.getContent() == null || info.getContent().isEmpty()) {
            return null;
        }
        return info.getContent().get(0);
    }
}

