/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.inspect;

import io.quarkus.domino.inspect.DependencyTreeBuilder;
import io.quarkus.domino.inspect.DependencyTreeError;
import io.quarkus.domino.inspect.DependencyTreeRequest;
import io.quarkus.domino.inspect.DependencyTreeVisitContext;
import io.quarkus.domino.inspect.DependencyTreeVisitSchedulerBase;
import org.eclipse.aether.graph.DependencyNode;

class SequentialTreeVisitScheduler<E>
extends DependencyTreeVisitSchedulerBase<E> {
    private final DependencyTreeBuilder treeBuilder;

    SequentialTreeVisitScheduler(DependencyTreeVisitContext<E> ctx, int treesTotal, DependencyTreeBuilder treeBuilder, String progressTrackerPrefix) {
        super(ctx, treesTotal, progressTrackerPrefix);
        this.treeBuilder = treeBuilder;
    }

    @Override
    public void process(DependencyTreeRequest req) {
        DependencyNode rootNode;
        try {
            rootNode = this.treeBuilder.buildTree(req);
            this.ctx.log.info(this.getResolvedTreeMessage(rootNode.getArtifact()));
        }
        catch (Exception e) {
            this.errors.add(new DependencyTreeError(req, e));
            this.ctx.log.error(this.formatErrorMessage(req, e));
            return;
        }
        this.ctx.root = rootNode;
        this.ctx.visitor.visit(this.ctx);
    }

    @Override
    public void waitForCompletion() {
    }
}

