/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.manifest.TreeNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

class TreeRecorder
implements DependencyTreeVisitor {
    private long counter;
    private List<TreeNode> roots;
    private ArrayDeque<TreeNode> branch;

    TreeRecorder() {
    }

    @Override
    public void beforeAllRoots() {
        this.roots = new ArrayList<TreeNode>();
        this.branch = new ArrayDeque();
        this.counter = 0L;
    }

    List<TreeNode> getRoots() {
        return this.roots;
    }

    @Override
    public void afterAllRoots() {
    }

    void enterNode(DependencyTreeVisitor.DependencyVisit visit) {
        TreeNode node = TreeNode.of(Long.toString(++this.counter), visit.getCoords().toCompactCoords());
        TreeNode parent = this.branch.peek();
        if (parent == null) {
            this.roots.add(node);
        } else {
            parent.addChild(node);
        }
        this.branch.push(node);
    }

    void leaveNode(DependencyTreeVisitor.DependencyVisit visit) {
        this.branch.pop();
    }

    @Override
    public void enterRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.enterNode(visit);
    }

    @Override
    public void leaveRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.leaveNode(visit);
    }

    @Override
    public void enterDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.enterNode(visit);
    }

    @Override
    public void leaveDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.leaveNode(visit);
    }

    @Override
    public void enterParentPom(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void leaveParentPom(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void enterBomImport(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void leaveBomImport(DependencyTreeVisitor.DependencyVisit visit) {
    }
}

