/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;

public class MavenProjectReader {
    private static final Map<String, String> PACKAGING_TYPE = Map.of("maven-archetype", "jar", "bundle", "jar", "maven-plugin", "jar", "war", "jar");

    private static String getTypeForPackaging(String packaging) {
        return PACKAGING_TYPE.getOrDefault(packaging, packaging);
    }

    public static List<ArtifactCoords> resolveModuleDependencies(LocalWorkspace ws) {
        Objects.requireNonNull(ws, "Workspace is null");
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(ws.getProjects().size());
        for (LocalProject project : ws.getProjects().values()) {
            if (!MavenProjectReader.isPublished(project)) continue;
            String type = MavenProjectReader.getTypeForPackaging(project.getRawModel().getPackaging());
            result.add(ArtifactCoords.of((String)project.getGroupId(), (String)project.getArtifactId(), (String)"", (String)type, (String)project.getVersion()));
        }
        return result;
    }

    private static boolean isPublished(LocalProject project) {
        Model model = project.getModelBuildingResult() == null ? project.getRawModel() : project.getModelBuildingResult().getEffectiveModel();
        Properties modelProps = model.getProperties();
        if (Boolean.parseBoolean(modelProps.getProperty("maven.install.skip")) || Boolean.parseBoolean(modelProps.getProperty("maven.deploy.skip")) || Boolean.parseBoolean(modelProps.getProperty("skipNexusStagingDeployMojo"))) {
            return false;
        }
        if (model.getBuild() != null) {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                if (!plugin.getArtifactId().equals("maven-install-plugin") && !plugin.getArtifactId().equals("maven-deploy-plugin")) continue;
                for (PluginExecution e : plugin.getExecutions()) {
                    if (!e.getId().startsWith("default-") || !e.getPhase().equals("none")) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

