/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.domino.JsonArtifactCoordsMixin;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ProjectDependencyConfigMapper {
    private static ObjectMapper mapper;
    private static ObjectMapper yamlMapper;

    public static ObjectMapper mapper() {
        return mapper == null ? (mapper = ProjectDependencyConfigMapper.initMapper(new ObjectMapper())) : mapper;
    }

    private static ObjectMapper yamlMapper() {
        return yamlMapper == null ? (yamlMapper = ProjectDependencyConfigMapper.initMapper(new ObjectMapper((JsonFactory)new YAMLFactory()))) : yamlMapper;
    }

    private static ObjectMapper mapperForPath(Path p) {
        return p.getFileName().toString().endsWith("json") ? ProjectDependencyConfigMapper.mapper() : ProjectDependencyConfigMapper.yamlMapper();
    }

    public static ObjectMapper initMapper(ObjectMapper mapper) {
        mapper.addMixIn(ArtifactCoords.class, JsonArtifactCoordsMixin.class);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static void serialize(Object catalog, Path p) throws IOException {
        ProjectDependencyConfigMapper.serialize(ProjectDependencyConfigMapper.mapperForPath(p), catalog, p);
    }

    public static void serialize(ObjectMapper mapper, Object catalog, Path p) throws IOException {
        Path parent = p.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(p, new OpenOption[0]);){
            ProjectDependencyConfigMapper.serialize(mapper, catalog, writer);
        }
    }

    public static void serialize(Object catalog, Writer writer) throws IOException {
        ProjectDependencyConfigMapper.serialize(ProjectDependencyConfigMapper.mapper(), catalog, writer);
    }

    public static void serialize(ObjectMapper mapper, Object catalog, Writer writer) throws IOException {
        mapper.writeValue(writer, catalog);
    }

    public static <T> T deserialize(Path p, Class<T> t) throws IOException {
        return ProjectDependencyConfigMapper.deserialize(ProjectDependencyConfigMapper.mapperForPath(p), p, t);
    }

    public static <T> T deserialize(ObjectMapper mapper, Path p, Class<T> t) throws IOException {
        if (!Files.exists(p, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + p + " does not exist");
        }
        try (BufferedReader reader = Files.newBufferedReader(p);){
            Object object = mapper.readValue((Reader)reader, t);
            return (T)object;
        }
    }

    public static <T> T deserialize(InputStream is, Class<T> t) throws IOException {
        return ProjectDependencyConfigMapper.deserialize(ProjectDependencyConfigMapper.mapper(), is, t);
    }

    public static <T> T deserialize(ObjectMapper mapper, InputStream is, Class<T> t) throws IOException {
        return (T)mapper.readValue(is, t);
    }

    public static <T> T deserialize(Reader reader, Class<T> t) throws IOException {
        return ProjectDependencyConfigMapper.deserialize(ProjectDependencyConfigMapper.mapper(), reader, t);
    }

    public static <T> T deserialize(ObjectMapper mapper, Reader reader, Class<T> t) throws IOException {
        return (T)mapper.readValue(reader, t);
    }
}

