/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.domino.PncBuildInfoProvider;
import io.quarkus.domino.manifest.PncArtifactBuildInfo;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class PncReleaseIdDetector
implements ReleaseIdDetector {
    private final PncBuildInfoProvider pncInfoProvider;

    public PncReleaseIdDetector(PncBuildInfoProvider pncInfoProvider) {
        this.pncInfoProvider = pncInfoProvider;
    }

    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        PncArtifactBuildInfo pncInfo = this.pncInfoProvider.getBuildInfo(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (pncInfo == null) {
            return null;
        }
        PncArtifactBuildInfo.Build build = PncReleaseIdDetector.getBuild(pncInfo);
        if (build == null) {
            return null;
        }
        String repoUrl = PncReleaseIdDetector.getRepoUrl(build);
        String tag = PncReleaseIdDetector.getTag(build);
        return repoUrl == null || tag == null ? null : ScmRevision.tag((ScmRepository)ScmRepository.ofUrl((String)repoUrl), (String)tag);
    }

    private static String getRepoUrl(PncArtifactBuildInfo.Build build) {
        return build == null ? null : build.getScmUrl();
    }

    private static String getTag(PncArtifactBuildInfo.Build build) {
        return build == null ? null : build.getScmTag();
    }

    private static PncArtifactBuildInfo.Build getBuild(PncArtifactBuildInfo pncInfo) {
        if (pncInfo == null) {
            return null;
        }
        PncArtifactBuildInfo.Content content = PncArtifactBuildInfo.getContent(pncInfo);
        if (content == null) {
            return null;
        }
        return content.getBuild();
    }
}

