/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.domino.ProductInfoImpl;
import io.quarkus.domino.ProductReleaseNotes;
import io.quarkus.domino.ProjectDependencyConfigMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public interface ProductInfo {
    public String getId();

    public String getStream();

    public String getGroup();

    public String getName();

    public String getType();

    public String getVersion();

    public String getPurl();

    public String getCpe();

    public String getDescription();

    public ProductReleaseNotes getReleaseNotes();

    default public Mutable mutable() {
        return new ProductInfoImpl.Builder(this);
    }

    default public void persist(Path p) throws IOException {
        ProjectDependencyConfigMapper.serialize((Object)this, p);
    }

    public static Mutable builder() {
        return new ProductInfoImpl.Builder();
    }

    public static ProductInfo fromFile(Path path) throws IOException {
        return ProductInfo.mutableFromFile(path).build();
    }

    public static Mutable mutableFromFile(Path path) throws IOException {
        Mutable mutable = ProjectDependencyConfigMapper.deserialize(path, ProductInfoImpl.Builder.class);
        return mutable == null ? ProductInfo.builder() : mutable;
    }

    public static ProductInfo fromStream(InputStream inputStream) throws IOException {
        Mutable mutable = ProjectDependencyConfigMapper.deserialize(inputStream, ProductInfoImpl.Builder.class);
        return mutable == null ? ProductInfo.builder().build() : mutable.build();
    }

    public static interface Mutable
    extends ProductInfo {
        public Mutable setId(String var1);

        public Mutable setStream(String var1);

        public Mutable setGroup(String var1);

        public Mutable setName(String var1);

        public Mutable setType(String var1);

        public Mutable setVersion(String var1);

        public Mutable setPurl(String var1);

        public Mutable setCpe(String var1);

        public Mutable setDescription(String var1);

        public Mutable setReleaseNotes(ProductReleaseNotes var1);

        public ProductInfo build();

        @Override
        default public void persist(Path p) throws IOException {
            ProjectDependencyConfigMapper.serialize((Object)this.build(), p);
        }
    }
}

