/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.domino.ProductReleaseNotes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ProductReleaseNotesImpl
implements ProductReleaseNotes {
    private final String type;
    private final String title;
    private final List<String> aliases;
    private final Map<String, String> properties;

    private ProductReleaseNotesImpl(ProductReleaseNotes other) {
        this.type = other.getType();
        this.title = other.getTitle();
        this.aliases = List.copyOf(other.getAliases());
        this.properties = ProductReleaseNotesImpl.toSortedUnmodifiableMap(other.getProperties());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    static ProductReleaseNotes.Mutable builder() {
        return new Builder();
    }

    private static <K extends Comparable<K>, V> Map<K, V> toSortedUnmodifiableMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Map.of();
        }
        if (map.size() == 1) {
            return Map.copyOf(map);
        }
        return Collections.unmodifiableMap(new TreeMap<K, V>(map));
    }

    public static class Builder
    implements ProductReleaseNotes.Mutable {
        private String type;
        private String title;
        private List<String> aliases = List.of();
        private Map<String, String> properties = Map.of();

        public Builder() {
        }

        Builder(ProductReleaseNotes other) {
            this.type = other.getType();
            this.title = other.getTitle();
            this.aliases = List.copyOf(other.getAliases());
            this.properties = Map.copyOf(other.getProperties());
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public ProductReleaseNotes.Mutable setType(String type) {
            this.type = type;
            return this;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public ProductReleaseNotes.Mutable setTitle(String title) {
            this.title = title;
            return this;
        }

        @Override
        public List<String> getAliases() {
            return this.aliases;
        }

        @Override
        public ProductReleaseNotes.Mutable setAliases(List<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public ProductReleaseNotes.Mutable setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public ProductReleaseNotes build() {
            return new ProductReleaseNotesImpl(this);
        }
    }
}

