/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.ProductInfo;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.manifest.PurgingDependencyTreeVisitor;
import io.quarkus.domino.manifest.SbomDependencyTreeReader;
import io.quarkus.domino.manifest.SbomGenerator;
import io.quarkus.domino.manifest.TreeNode;
import io.quarkus.domino.manifest.TreeRecorder;
import io.quarkus.domino.manifest.VisitedComponent;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;

public class SbomGeneratingDependencyVisitor
implements DependencyTreeVisitor {
    private static final String DOMINO_VALIDATE_SBOM_TREES = "domino.validate.sbom.trees";
    private final SbomGenerator.Builder sbomGenerator;
    private final PurgingDependencyTreeVisitor treeBuilder = new PurgingDependencyTreeVisitor();
    private final boolean validateSbomTrees = Boolean.parseBoolean(System.getProperty("domino.validate.sbom.trees"));
    private final TreeRecorder validatingTreeRecorder = this.validateSbomTrees ? new TreeRecorder() : null;
    private final ProjectDependencyConfig config;

    public SbomGeneratingDependencyVisitor(SbomGenerator.Builder sbomBuilder) {
        this(sbomBuilder, null);
    }

    public SbomGeneratingDependencyVisitor(SbomGenerator.Builder sbomBuilder, ProjectDependencyConfig config) {
        this.sbomGenerator = sbomBuilder;
        this.config = config;
    }

    @Override
    public void beforeAllRoots() {
        this.treeBuilder.beforeAllRoots();
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.beforeAllRoots();
        }
    }

    @Override
    public void afterAllRoots() {
        this.treeBuilder.afterAllRoots();
        List<VisitedComponent> rootComponents = this.treeBuilder.getRoots();
        this.sbomGenerator.setTopComponents(rootComponents);
        if (this.sbomGenerator.getProductInfo() == null) {
            VisitedComponent mainComponent = null;
            if (rootComponents.size() == 1) {
                mainComponent = rootComponents.get(0);
            } else if (this.config != null && this.config.getProjectBom() != null) {
                for (VisitedComponent c : rootComponents) {
                    if (!c.getArtifactCoords().equals(this.config.getProjectBom())) continue;
                    mainComponent = c;
                    break;
                }
            }
            if (mainComponent == null) {
                for (VisitedComponent c : rootComponents) {
                    if ("pom".equals(c.getArtifactCoords().getType())) continue;
                    if (mainComponent == null) {
                        mainComponent = c;
                        continue;
                    }
                    mainComponent = null;
                    break;
                }
            }
            if (mainComponent != null) {
                LocalProject project;
                ProductInfo.Mutable info = ProductInfo.builder().setGroup(mainComponent.getArtifactCoords().getGroupId()).setName(mainComponent.getArtifactCoords().getArtifactId()).setVersion(mainComponent.getArtifactCoords().getVersion()).setPurl(mainComponent.getPurl().toString()).setType(Component.Type.LIBRARY.toString());
                if (this.sbomGenerator.getArtifactResolver() != null && this.sbomGenerator.getArtifactResolver().getMavenContext().getWorkspace() != null && (project = this.sbomGenerator.getArtifactResolver().getMavenContext().getWorkspace().getProject(mainComponent.getArtifactCoords().getGroupId(), mainComponent.getArtifactCoords().getArtifactId())) != null && mainComponent.getArtifactCoords().getVersion().equals(project.getVersion())) {
                    SbomGeneratingDependencyVisitor.setPomInfo(info, project);
                }
                this.sbomGenerator.setProductInfo(info.build());
            } else if (this.sbomGenerator.getArtifactResolver() != null && this.sbomGenerator.getArtifactResolver().getMavenContext().getCurrentProject() != null) {
                LocalProject project = this.sbomGenerator.getArtifactResolver().getMavenContext().getCurrentProject();
                ProductInfo.Mutable info = ProductInfo.builder().setGroup(project.getGroupId()).setName(project.getArtifactId()).setVersion(project.getVersion()).setPurl(PurgingDependencyTreeVisitor.getPurl((ArtifactCoords)project.getAppArtifact()).toString()).setType(Component.Type.LIBRARY.toString());
                SbomGeneratingDependencyVisitor.setPomInfo(info, project);
                this.sbomGenerator.setProductInfo(info.build());
            }
        }
        Bom bom = this.sbomGenerator.build().generate();
        if (this.validatingTreeRecorder != null) {
            System.out.println("Validating recorded trees");
            this.validatingTreeRecorder.afterAllRoots();
            ArrayList<String> rootBomRefs = new ArrayList<String>(rootComponents.size());
            for (VisitedComponent root : rootComponents) {
                if (root.getBomRef() == null) {
                    throw new IllegalStateException("bom-ref is missing for " + root.getArtifactCoords().toCompactCoords());
                }
                rootBomRefs.add(root.getBomRef());
            }
            List<TreeNode> originalRoots = this.validatingTreeRecorder.getRoots();
            HashMap bomRoots = new HashMap(originalRoots.size());
            SbomDependencyTreeReader.readTrees(bom, rootBomRefs).forEach(n -> bomRoots.put(n.name, n));
            for (TreeNode originalRoot : originalRoots) {
                System.out.println("Validating dependencies of " + originalRoot.name);
                TreeNode bomRoot = (TreeNode)bomRoots.get(originalRoot.name);
                if (bomRoot == null) {
                    throw new IllegalStateException("Failed to locate " + originalRoot.name + " among the SBOM components: " + bomRoots.keySet());
                }
                originalRoot.isIdentical(bomRoot);
            }
        }
    }

    @Override
    public void enterRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.enterRootArtifact(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.enterRootArtifact(visit);
        }
    }

    @Override
    public void leaveRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.leaveRootArtifact(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.leaveRootArtifact(visit);
        }
    }

    @Override
    public void enterDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.enterDependency(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.enterDependency(visit);
        }
    }

    @Override
    public void linkDependency(ArtifactCoords coords) {
        this.treeBuilder.linkDependency(coords);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.linkDependency(coords);
        }
    }

    @Override
    public void leaveDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.leaveDependency(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.leaveDependency(visit);
        }
    }

    @Override
    public void enterParentPom(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.enterParentPom(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.enterParentPom(visit);
        }
    }

    @Override
    public void leaveParentPom(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.leaveParentPom(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.leaveParentPom(visit);
        }
    }

    @Override
    public void enterBomImport(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.enterBomImport(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.enterBomImport(visit);
        }
    }

    @Override
    public void leaveBomImport(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.leaveBomImport(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.leaveBomImport(visit);
        }
    }

    private static void setPomInfo(ProductInfo.Mutable productInfo, LocalProject project) {
        productInfo.setDescription(SbomGeneratingDependencyVisitor.getPomElement(project, p -> p.getRawModel().getDescription()));
    }

    private static <R> R getPomElement(LocalProject project, Function<LocalProject, R> func) {
        for (LocalProject p = project; p != null; p = p.getLocalParent()) {
            R r = func.apply(p);
            if (r == null) continue;
            return r;
        }
        return null;
    }
}

